<?php

// Register Custom Janer Taxonomy
function portfolio_cat()  {

    $labels = array(
        'name'                       => __( 'Project Categories', TEXT_DOMAIN ),
        'singular_name'              => __( 'Project Category', TEXT_DOMAIN ),
        'menu_name'                  => __( 'Project Categories', TEXT_DOMAIN ),
        'edit_item'                  => __( 'Edit Project Category', TEXT_DOMAIN ),
        'update_item'                => __( 'Update Project Category', TEXT_DOMAIN ),
        'add_new_item'               => __( 'Add New Project Category', TEXT_DOMAIN ),
        'new_item_name'              => __( 'New Project Category Name', TEXT_DOMAIN ),
        'parent_item'                => __( 'Parent Project Category', TEXT_DOMAIN ),
        'parent_item_colon'          => __( 'Parent Project Category:', TEXT_DOMAIN ),
        'all_items'                  => __( 'All Project Categories', TEXT_DOMAIN ),
        'search_items'               => __( 'Search Project Categories', TEXT_DOMAIN ),
        'popular_items'              => __( 'Popular Project Categories', TEXT_DOMAIN ),
        'separate_items_with_commas' => __( 'Separate Project categories with commas', TEXT_DOMAIN ),
        'add_or_remove_items'        => __( 'Add or remove Project categories', TEXT_DOMAIN ),
        'choose_from_most_used'      => __( 'Choose from the most used Project categories', TEXT_DOMAIN ),
        'not_found'                  => __( 'No Project categories found.', TEXT_DOMAIN ),
        'items_list_navigation'      => __( 'Project categories list navigation', TEXT_DOMAIN ),
        'items_list'                 => __( 'Project categories list', TEXT_DOMAIN ),
    );
    $args = array(
        'labels'                     => $labels,
        'hierarchical'               => true,
        'public'                     => true,
        'show_ui'                    => true,
        'show_admin_column'          => true,
        'show_in_nav_menus'          => true,
        'show_tagcloud'              => true,
        'show_in_rest'               => true,
    );
    register_taxonomy( 'portfolio_cat', 'portfolio', $args );
}


// Hook into the 'init' action
add_action( 'init', 'portfolio_cat', 0 );


// Register Custom Taxonomy
function portfolio_tags() {

    $labels = array(
        'name'                       => __( 'Project Tags', TEXT_DOMAIN ),
        'singular_name'              => __( 'Project Tag', TEXT_DOMAIN ),
        'menu_name'                  => __( 'Project Tags', TEXT_DOMAIN ),
        'edit_item'                  => __( 'Edit Project Tag', TEXT_DOMAIN ),
        'update_item'                => __( 'Update Project Tag', TEXT_DOMAIN ),
        'add_new_item'               => __( 'Add New Project Tag', TEXT_DOMAIN ),
        'new_item_name'              => __( 'New Project Tag Name', TEXT_DOMAIN ),
        'parent_item'                => __( 'Parent Project Tag', TEXT_DOMAIN ),
        'parent_item_colon'          => __( 'Parent Project Tag:', TEXT_DOMAIN ),
        'all_items'                  => __( 'All Project Tags', TEXT_DOMAIN ),
        'search_items'               => __( 'Search Project Tags', TEXT_DOMAIN ),
        'popular_items'              => __( 'Popular Project Tags', TEXT_DOMAIN ),
        'separate_items_with_commas' => __( 'Separate Project tags with commas', TEXT_DOMAIN ),
        'add_or_remove_items'        => __( 'Add or remove Project tags', TEXT_DOMAIN ),
        'choose_from_most_used'      => __( 'Choose from the most used Project tags', TEXT_DOMAIN ),
        'not_found'                  => __( 'No Project tags found.', TEXT_DOMAIN ),
        'items_list_navigation'      => __( 'Project tags list navigation', TEXT_DOMAIN ),
        'items_list'                 => __( 'Project tags list', TEXT_DOMAIN ),
    );
    $args = array(
        'labels'                     => $labels,
        'hierarchical'               => false,
        'public'                     => true,
        'show_ui'                    => true,
        'show_admin_column'          => true,
        'show_in_nav_menus'          => true,
        'show_tagcloud'              => true,
        'show_in_rest'               => true,
    );
    register_taxonomy( 'portfolio_tags', 'portfolio', $args );

}
add_action( 'init', 'portfolio_tags', 0 );