<?php

use RoboTheme\RoboTheme_Loader;

/**
 * all array css classes will output as proper space
 * @param array $classes shortcode css class as array
 * @return proper string
 */
function rbt_get_post_types($args = []) {

    $post_type_args = [
        'show_in_nav_menus' => true,
    ];

    if ( !empty($args['post_type']) ) {
        $post_type_args['name'] = $args['post_type'];
    }

    $_post_types = get_post_types($post_type_args, 'objects');

    $post_types = ['0' => esc_html__('Select Type', TEXT_DOMAIN)];

    foreach ( $_post_types as $post_type => $object ) {
        $post_types[$post_type] = $object->label;
    }

    return $post_types;
}

function rbt_allow_tags($tag = null) {
    $tag_allowed = wp_kses_allowed_html('post');

    $tag_allowed['input']  = [
        'class'   => [],
        'id'      => [],
        'name'    => [],
        'value'   => [],
        'checked' => [],
        'type'    => [],
    ];
    $tag_allowed['select'] = [
        'class'    => [],
        'id'       => [],
        'name'     => [],
        'value'    => [],
        'multiple' => [],
        'type'     => [],
    ];
    $tag_allowed['option'] = [
        'value'    => [],
        'selected' => [],
    ];

    $tag_allowed['title'] = [
        'a'      => [
            'href'  => [],
            'title' => [],
            'class' => [],
        ],
        'br'     => [],
        'em'     => [],
        'strong' => [],
        'hr'     => [],
    ];

    $tag_allowed['text'] = [
        'a'      => [
            'href'  => [],
            'title' => [],
            'class' => [],
        ],
        'br'     => [],
        'em'     => [],
        'strong' => [],
        'hr'     => [],
        'i'      => [
            'class' => [],
        ],
        'span'   => [
            'class' => [],
        ],
    ];

    $tag_allowed['svg'] = [
        'svg'     => [
            'version'     => [],
            'xmlns'       => [],
            'viewbox'     => [],
            'xml:space'   => [],
            'xmlns:xlink' => [],
            'x'           => [],
            'y'           => [],
            'style'       => [],
        ],
        'g'       => [],
        'path'    => [
            'class' => [],
            'd'     => [],
        ],
        'ellipse' => [
            'class' => [],
            'cx'    => [],
            'cy'    => [],
            'rx'    => [],
            'ry'    => [],
        ],
        'circle'  => [
            'class' => [],
            'cx'    => [],
            'cy'    => [],
            'r'     => [],
        ],
        'rect'    => [
            'x'         => [],
            'y'         => [],
            'transform' => [],
            'height'    => [],
            'width'     => [],
            'class'     => [],
        ],
        'line'    => [
            'class' => [],
            'x1'    => [],
            'x2'    => [],
            'y1'    => [],
            'y2'    => [],
        ],
        'style'   => [],


    ];

    if ( $tag == null ) {
        return $tag_allowed;
    } elseif ( is_array($tag) ) {
        $new_tag_allow = [];

        foreach ( $tag as $_tag ) {
            $new_tag_allow[$_tag] = $tag_allowed[$_tag];
        }

        return $new_tag_allow;
    } else {
        return isset($tag_allowed[$tag]) ? $tag_allowed[$tag] : [];
    }
}

/**
 * post pagination
 */
function rbt_post_pagination($wp_query) {

    $paged = get_query_var('paged') ? absint(get_query_var('paged')) : 1;
    $max   = intval($wp_query->max_num_pages);

    /** Add current page to the array */
    if ( $paged >= 1 )
        $links[] = $paged;

    /** Add the pages around the current page to the array */
    if ( $paged >= 3 ) {
        $links[] = $paged - 1;
        $links[] = $paged - 2;
    }

    if ( ($paged + 2) <= $max ) {
        $links[] = $paged + 2;
        $links[] = $paged + 1;
    }

    echo '<ul class="rbt-pagination rbt-flex-center">' . "\n";

    /** Previous Post Link */
    if ( get_previous_posts_link() )
        printf('<li>%s</li>' . "\n", get_previous_posts_link('<span class="ep-arrow-right-4" ></span>'));

    /** Link to first page, plus ellipses if necessary */
    if ( !in_array(1, $links) ) {
        $class = 1 == $paged ? ' class="current"' : '';

        printf('<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url(get_pagenum_link(1)), '1');

        if ( !in_array(2, $links) )
            echo '<li class="rbt-pagination-dot-dot"><span>...</span></li>';
    }

    /** Link to current page, plus 2 pages in either direction if necessary */
    sort($links);
    foreach ( (array)$links as $link ) {
        $class = $paged == $link ? ' class="rbt-active"' : '';
        printf('<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url(get_pagenum_link($link)), $link);
    }

    /** Link to last page, plus ellipses if necessary */
    if ( !in_array($max, $links) ) {
        if ( !in_array($max - 1, $links) )
            echo '<li class="rbt-pagination-dot-dot"><span>...</span></li>' . "\n";

        $class = $paged == $max ? ' class="rbt-active"' : '';
        printf('<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url(get_pagenum_link($max)), $max);
    }

    /** Next Post Link */
    if ( get_next_posts_link() )
        printf('<li>%s</li>' . "\n", get_next_posts_link('<span class="ep-arrow-left-4" ></span>'));

    echo '</ul>' . "\n";
}

function rbt_template_edit_link($template_id) {
    if ( RoboTheme_Loader::elementor()->editor->is_edit_mode() ) {

        $final_url = add_query_arg(['elementor' => ''], get_permalink($template_id));

        $output = sprintf('<a class="rbt-elementor-template-edit-link" href="%s" title="%s" target="_blank"><i class="eicon-edit"></i></a>', esc_url($final_url), esc_html__('Edit Template', TEXT_DOMAIN));

        return $output;
    }
}

function RBT_Get_Taxonomies() {
    $taxonomies = get_taxonomies('','objects');
    foreach ( $taxonomies as $taxonomy ) {
        $items[ $taxonomy->name ] = $taxonomy->label;
    }
    return $items;
}

function RBT_Seo_Title() {
    if(is_singular()){
        $title = get_the_title();
    } elseif (is_category()) {
        $title = single_cat_title( '', false );
    } elseif ( is_tag() ) {
        $title = single_tag_title( '', false );
    } elseif ( is_post_type_archive() ) {
        $title = post_type_archive_title( '', false );
    } elseif ( is_tax() ) {
        $title = single_term_title( '', false );
    } else {
        $title = wp_title( '' );
    }
    return $title;
}

/**
 * @return array of elementor template
 */
function rbt_template_options() {

    $templates = RoboTheme_Loader::elementor()->templates_manager->get_source('local')->get_items();
    $types     = [];

    if ( empty($templates) ) {
        $template_options = ['0' => __('Template Not Found!', TEXT_DOMAIN)];
    } else {
        $template_options = ['0' => __('Select Template', TEXT_DOMAIN)];

        foreach ( $templates as $template ) {
            $template_options[$template['template_id']] = $template['title'] . ' (' . $template['type'] . ')';
            $types[$template['template_id']]            = $template['type'];
        }
    }

    return $template_options;
}

// rbt Blend Type
function rbt_blend_options() {
    $blend_options = [
        'multiply'    => esc_html__('Multiply', TEXT_DOMAIN),
        'screen'      => esc_html__('Screen', TEXT_DOMAIN),
        'overlay'     => esc_html__('Overlay', TEXT_DOMAIN),
        'darken'      => esc_html__('Darken', TEXT_DOMAIN),
        'lighten'     => esc_html__('Lighten', TEXT_DOMAIN),
        'color-dodge' => esc_html__('Color-Dodge', TEXT_DOMAIN),
        'color-burn'  => esc_html__('Color-Burn', TEXT_DOMAIN),
        'hard-light'  => esc_html__('Hard-Light', TEXT_DOMAIN),
        'soft-light'  => esc_html__('Soft-Light', TEXT_DOMAIN),
        'difference'  => esc_html__('Difference', TEXT_DOMAIN),
        'exclusion'   => esc_html__('Exclusion', TEXT_DOMAIN),
        'hue'         => esc_html__('Hue', TEXT_DOMAIN),
        'saturation'  => esc_html__('Saturation', TEXT_DOMAIN),
        'color'       => esc_html__('Color', TEXT_DOMAIN),
        'luminosity'  => esc_html__('Luminosity', TEXT_DOMAIN),
    ];

    return $blend_options;
}

// rbt Position
function rbt_position() {
    $position_options = [
        ''              => esc_html__('Default', TEXT_DOMAIN),
        'top-left'      => esc_html__('Top Left', TEXT_DOMAIN),
        'top-center'    => esc_html__('Top Center', TEXT_DOMAIN),
        'top-right'     => esc_html__('Top Right', TEXT_DOMAIN),
        'center'        => esc_html__('Center', TEXT_DOMAIN),
        'center-left'   => esc_html__('Center Left', TEXT_DOMAIN),
        'center-right'  => esc_html__('Center Right', TEXT_DOMAIN),
        'bottom-left'   => esc_html__('Bottom Left', TEXT_DOMAIN),
        'bottom-center' => esc_html__('Bottom Center', TEXT_DOMAIN),
        'bottom-right'  => esc_html__('Bottom Right', TEXT_DOMAIN),
    ];

    return $position_options;
}

function rbt_navigation_position() {
    $position_options = [
        'top-left'      => esc_html__('Top Left', TEXT_DOMAIN),
        'top-center'    => esc_html__('Top Center', TEXT_DOMAIN),
        'top-right'     => esc_html__('Top Right', TEXT_DOMAIN),
        'center'        => esc_html__('Center', TEXT_DOMAIN),
        'bottom-left'   => esc_html__('Bottom Left', TEXT_DOMAIN),
        'bottom-center' => esc_html__('Bottom Center', TEXT_DOMAIN),
        'bottom-right'  => esc_html__('Bottom Right', TEXT_DOMAIN),
    ];

    return $position_options;
}

function rbt_pagination_position() {
    $position_options = [
        'top-left'      => esc_html__('Top Left', TEXT_DOMAIN),
        'top-center'    => esc_html__('Top Center', TEXT_DOMAIN),
        'top-right'     => esc_html__('Top Right', TEXT_DOMAIN),
        'bottom-left'   => esc_html__('Bottom Left', TEXT_DOMAIN),
        'bottom-center' => esc_html__('Bottom Center', TEXT_DOMAIN),
        'bottom-right'  => esc_html__('Bottom Right', TEXT_DOMAIN),
    ];

    return $position_options;
}

// Title Tags
function rbt_title_tags() {
    $title_tags = [
        'h1'   => esc_html__('H1', TEXT_DOMAIN),
        'h2'   => esc_html__('H2', TEXT_DOMAIN),
        'h3'   => esc_html__('H3', TEXT_DOMAIN),
        'h4'   => esc_html__('H4', TEXT_DOMAIN),
        'h5'   => esc_html__('H5', TEXT_DOMAIN),
        'h6'   => esc_html__('H6', TEXT_DOMAIN),
        'div'  => esc_html__('div', TEXT_DOMAIN),
        'span' => esc_html__('span', TEXT_DOMAIN),
        'p'    => esc_html__('p', TEXT_DOMAIN),
    ];

    return $title_tags;
}

function rbt_mask_shapes() {
    $path       = RBT_ASSETS_URL . 'images/mask/';
    $shape_name = 'shape';
    $extension  = '.svg';
    $list       = [0 => esc_html__('Select Mask', TEXT_DOMAIN)];

    for ( $i = 1; $i <= 20; $i++ ) {
        $list[$path . $shape_name . '-' . $i . $extension] = ucwords($shape_name . ' ' . $i);
    }

    return $list;
}

/**
 * This is a svg file converter function which return a svg content
 * @param svg file
 * @return svg content
 */
function rbt_svg_icon($icon) {

    $icon_path = RBT_ASSETS_PATH . "images/svg/{$icon}.svg";

    if ( !file_exists($icon_path) ) {
        return false;
    }

    ob_start();

    include $icon_path;

    $svg = ob_get_clean();

    return $svg;
}

/**
 * @param int $limit default limit is 25 word
 * @param bool $strip_shortcode if you want to strip shortcode from excert text
 * @param string $trail trail string default is ...
 * @return string return custom limited excerpt text
 */
function rbt_custom_excerpt($limit = 25, $strip_shortcode = false, $trail = '') {

    $output = get_the_content();

    if ($limit) {
        $output = wp_trim_words($output, $limit, $trail);
    }

    if ( $strip_shortcode ) {
        $output = strip_shortcodes($output);
    }

    return wpautop($output);
}

function robotheme_option($option, $section, $default = '') {

	$options = get_option($section);

	if (isset($options[$option])) {
		return $options[$option];
	}

	return $default;
}

function robotheme_get_category($taxonomy = 'category') {

    $post_options = [];

    $post_categories = get_terms([
        'taxonomy'   => $taxonomy,
        'hide_empty' => false,
    ]);

    if ( is_wp_error($post_categories) ) {
        return $post_options;
    }

    if ( false !== $post_categories and is_array($post_categories) ) {
        foreach ( $post_categories as $category ) {
            $post_options[$category->slug] = $category->name;
        }
    }
    return $post_options;
}