<?php

namespace RoboTheme\inc\elementor\Modules\Slider\Widgets;

use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Icons_Manager;
use RoboTheme\RoboTheme_Loader;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class RBT_Slider extends Widget_Base {

	/**
	 * @var \WP_Query
	 */
	private $_query = null;

	public function get_name() {
		return 'rbt-slider';
	}

	public function get_title() {
		return esc_html__( 'Slider', TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-post-slider';
	}

	public function get_categories() {
		return [ RBT_CAT ];
	}

	public function get_keywords() {
		return [ 'slider', 'slide' ];
	}

	public function get_style_depends() {
		return [ 'rbt-font-icon', 'rbt-slider' ];
	}

	public function get_script_depends() {
		return [ 'imagesloaded', 'rbt-slider' ];
	}

	public function on_import( $element ) {
		if ( ! get_post_type_object( $element['settings']['posts_post_type'] ) ) {
			$element['settings']['posts_post_type'] = 'services';
		}

		return $element;
	}

	protected function register_controls() {
		$this->register_controls_content();
		$this->register_controls_content_layout();
		$this->register_controls_content_navigation();
		$this->register_controls_content_slider();
		$this->register_controls_content_button();
		$this->register_controls_style_slider();
		$this->register_controls_style_pre_title();
		$this->register_controls_style_title();
		$this->register_controls_style_text();
		$this->register_controls_style_button();
		$this->register_controls_style_navigation();
		$this->register_controls_style_animation();
	}

    // content //
	protected function register_controls_content() {

		$this->start_controls_section(
			'section_content_sliders',
			[
				'label' => esc_html__( 'Sliders', TEXT_DOMAIN ),
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'source', 
			[
				'label'   => esc_html__( 'Select Source', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'custom',
				'options' => [
					'custom'        => esc_html__( 'Custom Content', TEXT_DOMAIN ),
					"elementor"     => esc_html__( 'Elementor Template', TEXT_DOMAIN ),
				],
			]
		);

		$repeater->add_control(
			'template_id', 
			[
				'label'       => __( 'Select Template', TEXT_DOMAIN ),
				'type'        => Controls_Manager::SELECT,
				'default'     => '0',
				'options'     => rbt_template_options(),
				'label_block' => 'true',
				'condition'   => [ 'source' => "elementor" ],
			]
		);

		$repeater->add_control(
			'pre_title', 
			[
				'label'       => esc_html__( 'Pre Title', TEXT_DOMAIN ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [ 'active' => true ],
				'default'     => esc_html__( 'Slide Pre Title' , TEXT_DOMAIN ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'title', 
			[
				'label'       => esc_html__( 'Title', TEXT_DOMAIN ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [ 'active' => true ],
				'default'     => esc_html__( 'Slide Title' , TEXT_DOMAIN ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'background', 
			[
				'label'   => esc_html__( 'Background', TEXT_DOMAIN ),
				'type'    => Controls_Manager::CHOOSE,
				'default' => 'color',
				'options' => [
					'color' => [
						'title' => esc_html__( 'Color', TEXT_DOMAIN ),
						'icon'  => 'eicon-global-colors',
					],
					'image' => [
						'title' => esc_html__( 'Image', TEXT_DOMAIN ),
						'icon'  => 'eicon-image',
					],
					'video' => [
						'title' => esc_html__( 'Video', TEXT_DOMAIN ),
						'icon'  => 'eicon-video-camera',
					],
					'youtube' => [
						'title' => esc_html__( 'Youtube', TEXT_DOMAIN ),
						'icon'  => 'eicon-youtube',
					],
				],
			]
		);	

		$repeater->add_control(
			'color', 
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#14ABF4',
				'condition' => [
					'background' => 'color'
				],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}' => 'background-color: {{VALUE}}',
				],
			]
		);

		$repeater->add_control(
			'image', 
			[
				'label'   => esc_html__( 'Image', TEXT_DOMAIN ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'background' => 'image'
				],
			]
		);

		$repeater->add_control(
			'video_link', 
			[
				'label'     => esc_html__( 'Video Link', TEXT_DOMAIN ),
				'type'      => Controls_Manager::TEXT,
				'condition' => [
					'background' => 'video'
				],
				'default' => '//clips.vorwaerts-gmbh.de/big_buck_bunny.mp4',
			]
		);

		$repeater->add_control(
			'youtube_link', 
			[
				'label'     => esc_html__( 'Youtube Link', TEXT_DOMAIN ),
				'type'      => Controls_Manager::TEXT,
				'condition' => [
					'background' => 'youtube'
				],
				//'default' => 'https://youtu.be/YE7VzlLtp-4',
			]
		);	

		$repeater->add_control(
			'button_link', 
			[
				'label'       => esc_html__( 'Button Link', TEXT_DOMAIN ),
				'type'        => Controls_Manager::URL,
				'dynamic'     => [ 'active' => true ],
				'separator'   => 'before',
				//'placeholder' => 'https://rbthemes.com',
			]
		);

		$repeater->add_control(
			'text', 
			[
				'label'      => esc_html__( 'Text', TEXT_DOMAIN ),
				'type'       => Controls_Manager::TEXTAREA,
				'dynamic'    => [ 'active' => true ],
				'default'    => esc_html__( 'I am slideshow description text, you can edit this text from slider items of slideshow content.', TEXT_DOMAIN ),
				'show_label' => false,
			]
		);

		$repeater->add_control(
			'tab_link', 
			[
				'label'       => esc_html__( 'Link', TEXT_DOMAIN ),
				'type'        => Controls_Manager::URL,
				'dynamic'     => [ 'active' => true ],
				'placeholder' => 'http://your-link.com',
				'default'     => [
					'url' => '#',
				],
				'condition' => [ 'source' => 'custom' ],
			]
		);

		$this->add_control(
			'slides',
			[
				'label' => esc_html__( 'Slider Items', TEXT_DOMAIN ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'title'       => esc_html__( 'Slide Item 1', TEXT_DOMAIN ),
						'button_link' => ['url' => '#'],
					],
					[
						'title'       => esc_html__( 'Slide Item 2', TEXT_DOMAIN ),
						'button_link' => ['url' => '#'],
					],
					[
						'title'       => esc_html__( 'Slide Item 3', TEXT_DOMAIN ),
						'button_link' => ['url' => '#'],
					],
					[
						'title'       => esc_html__( 'Slide Item 4', TEXT_DOMAIN ),
						'button_link' => ['url' => '#'],
					],
				],
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_content_layout() {

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', TEXT_DOMAIN ),
			]
		);

		$this->add_responsive_control(
			'height',
			[
				'label'   => esc_html__( 'Height', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 600,
				],
				'range' => [
					'px' => [
						'min' => 50,
						'max' => 1024,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .rbt-slide-item' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'content_margin',
			[
				'label'      => esc_html__( 'Margin', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-slideshow-content-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'content_position',
			[
				'label'   => esc_html__( 'Content Position', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'center',
				'options' => [
					'top-left'      => esc_html__('Top Left', TEXT_DOMAIN),
					'top-center'    => esc_html__('Top Center', TEXT_DOMAIN),
					'top-right'     => esc_html__('Top Right', TEXT_DOMAIN),
					'center'        => esc_html__('Center', TEXT_DOMAIN),
					'center-left'   => esc_html__('Center Left', TEXT_DOMAIN),
					'center-right'  => esc_html__('Center Right', TEXT_DOMAIN),
					'bottom-left'   => esc_html__('Bottom Left', TEXT_DOMAIN),
					'bottom-center' => esc_html__('Bottom Center', TEXT_DOMAIN),
					'bottom-right'  => esc_html__('Bottom Right', TEXT_DOMAIN),
				]
			]
		);

		$this->add_responsive_control(
			'content_align',
			[
				'label'   => esc_html__( 'Content Alignment', TEXT_DOMAIN ),
				'type'    => Controls_Manager::CHOOSE,
				'default' => 'center',
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', TEXT_DOMAIN ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', TEXT_DOMAIN ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', TEXT_DOMAIN ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', TEXT_DOMAIN ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
			]
		);

		$this->add_control(
			'show_pre_title',
			[
				'label'   => esc_html__( 'Show Pre Title', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_title',
			[
				'label'   => esc_html__( 'Show Title', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_button',
			[
				'label'   => esc_html__( 'Show Button', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_text',
			[
				'label'   => esc_html__( 'Show Text', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title HTML Tag', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SELECT,
				'options'   => rbt_title_tags(),
				'default'   => 'h1',
				'condition' => [
					'show_title' => 'yes',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_content_navigation() {

		$this->start_controls_section(
			'section_content_navigation',
			[
				'label' => __( 'Navigation', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'navigation',
			[
				'label'   => __( 'Navigation', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'arrows',
				'options' => [
					'both'            => esc_html__( 'Arrows and Dots', TEXT_DOMAIN ),
					'arrows-fraction' => esc_html__( 'Arrows and Fraction', TEXT_DOMAIN ),
					'arrows'          => esc_html__( 'Arrows', TEXT_DOMAIN ),
					'dots'            => esc_html__( 'Dots', TEXT_DOMAIN ),
					'progressbar'     => esc_html__( 'Progress', TEXT_DOMAIN ),
					'none'            => esc_html__( 'None', TEXT_DOMAIN ),
				],
				'prefix_class' => 'rbt-navigation-type-',
				'render_type' => 'template',				
			]
		);

		$this->add_control(
			'dynamic_bullets',
			[
				'label'     => __( 'Dynamic Bullets?', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
				'condition' => [
					'navigation' => [ 'dots', 'both' ],
				],
			]
		);

		$this->add_control(
			'show_scrollbar',
			[
				'label'     => __( 'Show Scrollbar?', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
			]
		);
		
		$this->add_control(
			'both_position',
			[
				'label'     => __( 'Arrows and Dots Position', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'center',
				'options'   => rbt_navigation_position(),
				'condition' => [
					'navigation' => 'both',
				],
				
			]
		);

		$this->add_control(
			'arrows_fraction_position',
			[
				'label'     => __( 'Arrows and Fraction Position', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'center',
				'options'   => rbt_navigation_position(),
				'condition' => [
					'navigation' => 'arrows-fraction',
				],
				
			]
		);

		$this->add_control(
			'arrows_position',
			[
				'label'     => __( 'Arrows Position', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'center',
				'options'   => rbt_navigation_position(),
				'condition' => [
					'navigation' => 'arrows',
				],
				
			]
		);

		$this->add_control(
			'dots_position',
			[
				'label'     => __( 'Dots Position', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'bottom-center',
				'options'   => rbt_pagination_position(),
				'condition' => [
					'navigation' => 'dots',
				],
				
			]
		);

		$this->add_control(
			'progress_position',
			[
				'label'   => __( 'Progress Position', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'bottom',
				'options' => [
					'bottom' => esc_html__('Bottom', TEXT_DOMAIN),
					'top'    => esc_html__('Top', TEXT_DOMAIN),
				],
				'condition' => [
					'navigation' => 'progressbar',
				],
				
			]
		);

		$this->add_control(
			'nav_arrows_icon',
			[
				'label'   => esc_html__( 'Arrows Icon', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => '5',
				'options' => [
					'1' => esc_html__('Style 1', TEXT_DOMAIN),
					'2' => esc_html__('Style 2', TEXT_DOMAIN),
					'3' => esc_html__('Style 3', TEXT_DOMAIN),
					'4' => esc_html__('Style 4', TEXT_DOMAIN),
					'5' => esc_html__('Style 5', TEXT_DOMAIN),
					'6' => esc_html__('Style 6', TEXT_DOMAIN),
					'7' => esc_html__('Style 7', TEXT_DOMAIN),
					'8' => esc_html__('Style 8', TEXT_DOMAIN),
					'9' => esc_html__('Style 9', TEXT_DOMAIN),
					'10' => esc_html__('Style 10', TEXT_DOMAIN),
					'11' => esc_html__('Style 11', TEXT_DOMAIN),
					'12' => esc_html__('Style 12', TEXT_DOMAIN),
					'13' => esc_html__('Style 13', TEXT_DOMAIN),
					'14' => esc_html__('Style 14', TEXT_DOMAIN),
					'15' => esc_html__('Style 15', TEXT_DOMAIN),
					'16' => esc_html__('Style 16', TEXT_DOMAIN),
					'17' => esc_html__('Style 17', TEXT_DOMAIN),
					'18' => esc_html__('Style 18', TEXT_DOMAIN),
					'circle-1' => esc_html__('Style 19', TEXT_DOMAIN),
					'circle-2' => esc_html__('Style 20', TEXT_DOMAIN),
					'circle-3' => esc_html__('Style 21', TEXT_DOMAIN),
					'circle-4' => esc_html__('Style 22', TEXT_DOMAIN),
					'square-1' => esc_html__('Style 23', TEXT_DOMAIN),
				],
				'condition' => [
					'navigation' => ['arrows-fraction', 'both', 'arrows'],
				],
			]
		);

		$this->add_control(
			'hide_arrow_on_mobile',
			[
				'label'     => __( 'Hide Arrow on Mobile ?', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'condition' => [
					'navigation' => [ 'arrows-fraction', 'arrows', 'both' ],
				],				
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_content_slider() {

		$this->start_controls_section(
			'section_content_slider_settings',
			[
				'label' => esc_html__( 'Slider Settings', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'transition',
			[
				'label'   => esc_html__( 'Transition', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'slide',
				'options' => [
					'slide'     => esc_html__( 'Slide', TEXT_DOMAIN ),
					'fade'      => esc_html__( 'Fade', TEXT_DOMAIN ),
					'cube'      => esc_html__( 'Cube', TEXT_DOMAIN ),
					'coverflow' => esc_html__( 'Coverflow', TEXT_DOMAIN ),
					'flip'      => esc_html__( 'Flip', TEXT_DOMAIN ),
				],
			]
		);

		$this->add_control(
			'animation_kenburns',
			[
				'label'        => esc_html__( 'Animation Kenburns', TEXT_DOMAIN ),
				'prefix_class' => 'rbt-animation-kenburns-',
				'type'         => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'effect',
			[
				'label'   => esc_html__( 'Text Effect', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'left',
				'options' => [
				'left'    => esc_html__( 'Slide Right to Left', TEXT_DOMAIN ),
				'bottom'  => esc_html__( 'Slider Bottom to Top', TEXT_DOMAIN ),
				],
			]
		);

		$this->add_control(
			'autoplay_slider',
			[
				'label'     => esc_html__( 'Autoplay', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'autoplay_speed',
			[
				'label'     => esc_html__( 'Autoplay Speed', TEXT_DOMAIN ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 5000,
				'condition' => [
					'autoplay' => 'yes',
				],
			]
		);

		$this->add_control(
			'pauseonhover',
			[
				'label' => esc_html__( 'Pause on Hover', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SWITCHER,
				'condition' => [
					'autoplay' => 'yes',
				],
			]
		);

		$this->add_control(
			'loop',
			[
				'label'   => __( 'Loop', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				
			]
		);

		$this->add_control(
			'speed',
			[
				'label'   => __( 'Animation Speed (ms)', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 500,
				],
				'range' => [
					'min'  => 100,
					'max'  => 5000,
					'step' => 50,
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_content_button() {

		$this->start_controls_section(
			'section_content_button',
			[
				'label'     => esc_html__( 'Button', TEXT_DOMAIN ),
				'condition' => [
					'show_button' => 'yes',
				],
			]
		);

		$this->add_control(
			'button_text',
			[
				'label'       => esc_html__( 'Button Text', TEXT_DOMAIN ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Read More', TEXT_DOMAIN ),
				'placeholder' => esc_html__( 'Read More', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'slideshow_icon',
			[
				'label' => esc_html__( 'Icon', TEXT_DOMAIN ),
				'type'        => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
			]
		);

		$this->add_control(
			'icon_align',
			[
				'label'   => esc_html__( 'Icon Position', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'right',
				'options' => [
					'left'  => esc_html__( 'Before', TEXT_DOMAIN ),
					'right' => esc_html__( 'After', TEXT_DOMAIN ),
				],
				'condition' => [
					'slideshow_icon[value]!' => '',
				],
			]
		);

		$this->add_control(
			'icon_indent',
			[
				'label'   => esc_html__( 'Icon Spacing', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 8,
				],
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'condition' => [
					'slideshow_icon[value]!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-slideshow-button-icon-right' => 'margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rbt-slideshow-button-icon-left'  => 'margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

	}

	// style //
	protected function register_controls_style_slider() {

		$this->start_controls_section(
			'section_style_slider',
			[
				'label' => esc_html__( 'Slider', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'overlay',
			[
				'label'   => esc_html__( 'Overlay', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					'none'       => esc_html__( 'None', TEXT_DOMAIN ),
					'background' => esc_html__( 'Background', TEXT_DOMAIN ),
					'blend'      => esc_html__( 'Blend', TEXT_DOMAIN ),
				],
			]
		);

		$this->add_control(
			'overlay_color',
			[
				'label'     => esc_html__( 'Overlay Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'condition' => [
					'overlay' => ['background', 'blend']
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-overlay-default' => 'background-color: {{VALUE}};'
				]
			]
		);

		$this->add_control(
			'blend_type',
			[
				'label'     => esc_html__( 'Blend Type', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'multiply',
				'options'   => rbt_blend_options(),
				'condition' => [
					'overlay' => 'blend',
				],
			]
		);

		$this->add_control(
			'slider_background_color',
			[
				'label'     => esc_html__( 'Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#14ABF4',
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .rbt-slide-item' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

	}
	
	protected function register_controls_style_pre_title() {

		$this->start_controls_section(
			'section_style_pre_title',
			[
				'label'     => esc_html__( 'Pre Title', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_pre_title' => [ 'yes' ],
				],
			]
		);

		$this->add_control(
			'pre_title_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-slideshow-pre-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pre_title_background',
			[
				'label'     => esc_html__( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-slideshow-pre-title' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'pre_title_padding',
			[
				'label'      => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-slideshow-pre-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'pre_title_radius',
			[
				'label'      => esc_html__( 'Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-slideshow-pre-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'pre_title_typography',
				'label'    => esc_html__( 'Typography', TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rbt-slideshow-pre-title',
			]
		);

		$this->end_controls_section();


	}

	protected function register_controls_style_title() {

		$this->start_controls_section(
			'section_style_title',
			[
				'label'     => esc_html__( 'Title', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_title' => [ 'yes' ],
				],
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-slideshow-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'title_background',
			[
				'label'     => esc_html__( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-slideshow-title' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'title_padding',
			[
				'label'      => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-slideshow-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'title_radius',
			[
				'label'      => esc_html__( 'Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-slideshow-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'    => esc_html__( 'Typography', TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rbt-slideshow-title',
			]
		);

		$this->add_responsive_control(
			'title_space',
			[
				'label' => esc_html__( 'Space', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-slideshow-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();


	}

	protected function register_controls_style_text() {

		$this->start_controls_section(
			'section_style_text',
			[
				'label' => esc_html__( 'Text', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'text_color',
			[
				'label'     => esc_html__( 'Text Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-slideshow-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'text_background',
			[
				'label'     => esc_html__( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-slideshow-text' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'text_padding',
			[
				'label'      => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-slideshow-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'text_typography',
				'label'    => esc_html__( 'Text Typography', TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rbt-slideshow-text',
			]
		);

		$this->add_responsive_control(
			'text_space',
			[
				'label' => esc_html__( 'Top Space', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-slideshow-text' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_style_button() {

		$this->start_controls_section(
			'section_style_button',
			[
				'label'     => esc_html__( 'Button', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_button' => 'yes',
				],
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'button_normal',
			[
				'label' => esc_html__( 'Normal', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label'     => esc_html__( 'Text Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-slideshow-button' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rbt-slideshow-button svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'background_color',
			[
				'label'     => esc_html__( 'Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-slideshow-button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'button_box_shadow',
				'selector' => '{{WRAPPER}} .rbt-slideshow-button',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'border',
				'label'       => esc_html__( 'Border', TEXT_DOMAIN ),
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .rbt-slideshow-button',
				'separator'   => 'before',
			]
		);

		$this->add_control(
			'border_radius',
			[
				'label'      => esc_html__( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-slideshow-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'button_padding',
			[
				'label'      => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-slideshow-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'typography',
				'label'    => esc_html__( 'Typography', TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rbt-slideshow-button',
			]
		);

		$this->add_responsive_control(
			'button_top_space',
			[
				'label' => esc_html__( 'Top Space', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-slideshow-button' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'button_hover',
			[
				'label' => esc_html__( 'Hover', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'hover_color',
			[
				'label'     => esc_html__( 'Text Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-slideshow-button:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rbt-slideshow-button:hover svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_background_hover_color',
			[
				'label'     => esc_html__( 'Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-slideshow-button:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_hover_border_color',
			[
				'label'     => esc_html__( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'condition' => [
					'border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-slideshow-button:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_hover_animation',
			[
				'label' => esc_html__( 'Animation', TEXT_DOMAIN ),
				'type'  => Controls_Manager::HOVER_ANIMATION,
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();


	}

	protected function register_controls_style_navigation() {

		$this->start_controls_section(
			'section_style_navigation',
			[
				'label'     => __( 'Navigation', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'conditions'   => [
					'relation' => 'or',
					'terms' => [
						[
							'name'  => 'navigation',
							'operator' => '!=',
							'value' => 'none',
						],
						[
							'name'     => 'show_scrollbar',
							'value'    => 'yes',
						],
					],
				],
			]
		);

		$this->add_control(
			'arrows_heading',
			[
				'label'     => __( 'Arrows', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
				'condition' => [
					'navigation!' => [ 'dots', 'progressbar', 'none' ],
				],
			]
		);

		$this->start_controls_tabs( 'tabs_navigation_arrows_style' );

		$this->start_controls_tab(
			'tabs_nav_arrows_normal',
			[
				'label' => __( 'Normal', TEXT_DOMAIN ),
				'condition' => [
					'navigation!' => [ 'dots', 'progressbar', 'none' ],
				],
			]
		);

		$this->add_control(
			'arrows_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .rbt-navigation-prev i, {{WRAPPER}} .rbt-slider .rbt-navigation-next i' => 'color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => [ 'dots', 'progressbar', 'none' ],
				],
			]
		);

		$this->add_control(
			'arrows_background',
			[
				'label'     => __( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .rbt-navigation-prev, {{WRAPPER}} .rbt-slider .rbt-navigation-next' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => [ 'dots', 'progressbar', 'none' ],
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'nav_arrows_border',
				'selector'    => '{{WRAPPER}} .rbt-slider .rbt-navigation-prev, {{WRAPPER}} .rbt-slider .rbt-navigation-next',
				'condition' => [
					'navigation!' => [ 'dots', 'progressbar', 'none' ],
				],
			]
		);

		$this->add_control(
			'nav_border_radius',
			[
				'label'      => __( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-slider .rbt-navigation-prev, {{WRAPPER}} .rbt-slider .rbt-navigation-next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => [ 'dots', 'progressbar', 'none' ],
				],
			]
		);

		$this->add_responsive_control(
			'arrows_padding',
			[
				'label' => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .rbt-navigation-prev, {{WRAPPER}} .rbt-slider .rbt-navigation-next' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => [ 'dots', 'progressbar', 'none' ],
				],
			]
		);

		$this->add_control(
			'arrows_size',
			[
				'label' => __( 'Size', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .rbt-navigation-prev i,
					{{WRAPPER}} .rbt-slider .rbt-navigation-next i' => 'font-size: {{SIZE || 36}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => [ 'dots', 'progressbar', 'none' ],
				],
			]
		);

		$this->add_control(
			'arrows_space',
			[
				'label' => __( 'Space', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .rbt-navigation-prev' => 'margin-right: {{SIZE}}px;',
					'{{WRAPPER}} .rbt-slider .rbt-navigation-next' => 'margin-left: {{SIZE}}px;',
				],
				'conditions'   => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'both',
						],
						[
							'name'     => 'both_position',
							'operator' => '!=',
							'value'    => 'center',
						],
					],
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tabs_nav_arrows_hover',
			[
				'label' => __( 'Hover', TEXT_DOMAIN ),
				'condition' => [
					'navigation!' => [ 'dots', 'progressbar', 'none' ],
				],
			]
		);

		$this->add_control(
			'arrows_hover_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .rbt-navigation-prev:hover i, {{WRAPPER}} .rbt-slider .rbt-navigation-next:hover i' => 'color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => [ 'dots', 'progressbar', 'none' ],
				],
			]
		);

		$this->add_control(
			'arrows_hover_background',
			[
				'label'     => __( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .rbt-navigation-prev:hover, {{WRAPPER}} .rbt-slider .rbt-navigation-next:hover' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => [ 'dots', 'progressbar', 'none' ],
				],
			]
		);

		$this->add_control(
			'nav_arrows_hover_border_color',
			[
				'label'     => __( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .rbt-navigation-prev:hover, {{WRAPPER}} .rbt-slider .rbt-navigation-next:hover'  => 'border-color: {{VALUE}};',
				],
				'condition' => [
					'nav_arrows_border_border!' => '',
					'navigation!' => [ 'dots', 'progressbar', 'none' ],
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'hr_1',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'navigation!' => [ 'arrows', 'arrows-fraction', 'progressbar', 'none' ],
				],
			]
		);

		$this->add_control(
			'dots_heading',
			[
				'label'     => __( 'Dots', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
				'condition' => [
					'navigation!' => [ 'arrows', 'arrows-fraction', 'progressbar', 'none' ],
				],
			]
		);

		$this->add_control(
			'hr_11',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'navigation!' => [ 'arrows', 'arrows-fraction', 'progressbar', 'none' ],
				],
			]
		);

		$this->add_control(
			'dots_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => [ 'arrows', 'arrows-fraction', 'progressbar', 'none' ],
				],
			]
		);

		$this->add_control(
			'active_dot_color',
			[
				'label'     => __( 'Active Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .swiper-pagination-bullet-active' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => [ 'arrows', 'arrows-fraction', 'progressbar', 'none' ],
				],
			]
		);

		$this->add_control(
			'dots_size',
			[
				'label' => __( 'Size', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 20,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .swiper-pagination-bullet' => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => [ 'arrows', 'arrows-fraction', 'progressbar', 'none' ],
				],
			]
		);

		$this->add_control(
			'hr_2',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'navigation' => 'arrows-fraction',
				],
			]
		);

		$this->add_control(
			'fraction_heading',
			[
				'label'     => __( 'Fraction', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
				'condition' => [
					'navigation' => 'arrows-fraction',
				],
			]
		);

		$this->add_control(
			'hr_12',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'navigation' => 'arrows-fraction',
				],
			]
		);

		$this->add_control(
			'fraction_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .swiper-pagination-fraction' => 'color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => [ 'arrows', 'dots', 'progressbar', 'none' ],
				],
			]
		);

		$this->add_control(
			'active_fraction_color',
			[
				'label'     => __( 'Active Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .swiper-pagination-current' => 'color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => [ 'arrows', 'dots', 'progressbar', 'none' ],
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'fraction_typography',
				'label'     => esc_html__( 'Typography', TEXT_DOMAIN ),
				//'scheme'    => Schemes\Typography::TYPOGRAPHY_4,
				'selector'  => '{{WRAPPER}} .rbt-slider .swiper-pagination-fraction',
				'condition' => [
					'navigation!' => [ 'arrows', 'dots', 'progressbar', 'none' ],
				],
			]
		);

		$this->add_control(
			'hr_3',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'navigation' => 'progressbar',
				],
			]
		);

		$this->add_control(
			'progresbar_heading',
			[
				'label'     => __( 'Progresbar', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
				'condition' => [
					'navigation' => 'progressbar',
				],
			]
		);

		$this->add_control(
			'hr_13',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition' => [
					'navigation' => 'progressbar',
				],
			]
		);

		$this->add_control(
			'progresbar_color',
			[
				'label'     => __( 'Bar Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .swiper-pagination-progressbar' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'navigation' => 'progressbar',
				],
			]
		);

		$this->add_control(
			'progres_color',
			[
				'label'     => __( 'Progress Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'separator' => 'after',
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .swiper-pagination-progressbar .swiper-pagination-progressbar-fill' => 'background: {{VALUE}}',
				],
				'condition' => [
					'navigation' => 'progressbar',
				],
			]
		);

		$this->add_control(
			'hr_4',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition'   => [
					'show_scrollbar' => 'yes'
				],
			]
		);

		$this->add_control(
			'scrollbar_heading',
			[
				'label'     => __( 'Scrollbar', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
				'condition'   => [
					'show_scrollbar' => 'yes'
				],
			]
		);

		$this->add_control(
			'hr_14',
			[
				'type' => Controls_Manager::DIVIDER,
				'condition'   => [
					'show_scrollbar' => 'yes'
				],
			]
		);

		$this->add_control(
			'scrollbar_color',
			[
				'label'     => __( 'Bar Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .swiper-scrollbar' => 'background: {{VALUE}}',
				],
				'condition'   => [
					'show_scrollbar' => 'yes'
				],
			]
		);

		$this->add_control(
			'scrollbar_drag_color',
			[
				'label'     => __( 'Drag Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .swiper-scrollbar .swiper-scrollbar-drag' => 'background: {{VALUE}}',
				],
				'condition'   => [
					'show_scrollbar' => 'yes'
				],
			]
		);

		$this->add_control(
			'scrollbar_height',
			[
				'label'   => __( 'Height', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 10,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .swiper-container-horizontal > .swiper-scrollbar' => 'height: {{SIZE}}px;',
				],
				'condition'   => [
					'show_scrollbar' => 'yes'
				],
			]
		);

		$this->add_control(
			'hr_5',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'navi_offset_heading',
			[
				'label'     => __( 'Offset', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
			]
		);

		$this->add_control(
			'hr_6',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_responsive_control(
			'arrows_ncx_position',
			[
				'label'   => __( 'Arrows Horizontal Offset', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
				],
				'tablet_default' => [
					'size' => 0,
				],
				'mobile_default' => [
					'size' => 0,
				],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'conditions'   => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows',
						],
						[
							'name'     => 'arrows_position',
							'operator' => '!=',
							'value'    => 'center',
						],
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => '--ep-slider-arrows-ncx: {{SIZE}}px;'
				],
			]
		);

		$this->add_responsive_control(
			'arrows_ncy_position',
			[
				'label'   => __( 'Arrows Vertical Offset', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 40,
				],
				'tablet_default' => [
					'size' => 40,
				],
				'mobile_default' => [
					'size' => 40,
				],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => '--ep-slider-arrows-ncy: {{SIZE}}px;'
				],
				'conditions'   => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows',
						],
						[
							'name'     => 'arrows_position',
							'operator' => '!=',
							'value'    => 'center',
						],
					],
				],
			]
		);

		$this->add_responsive_control(
			'arrows_acx_position',
			[
				'label'   => __( 'Arrows Horizontal Offset', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 35,
				],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .rbt-navigation-prev' => 'left: {{SIZE}}px;',
					'{{WRAPPER}} .rbt-slider .rbt-navigation-next' => 'right: {{SIZE}}px;',
				],
				'conditions' => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows',
						],
						[
							'name'  => 'arrows_position',
							'value' => 'center',
						],
					],
				],
			]
		);

		$this->add_responsive_control(
			'dots_nnx_position',
			[
				'label'   => __( 'Dots Horizontal Offset', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
				],
				'tablet_default' => [
					'size' => 0,
				],
				'mobile_default' => [
					'size' => 0,
				],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'conditions'   => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'dots',
						],
						[
							'name'     => 'dots_position',
							'operator' => '!=',
							'value'    => '',
						],
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => '--ep-slider-dots-nnx: {{SIZE}}px;'
				],
			]
		);

		$this->add_responsive_control(
			'dots_nny_position',
			[
				'label'   => __( 'Dots Vertical Offset', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => -30,
				],
				'tablet_default' => [
					'size' => -30,
				],
				'mobile_default' => [
					'size' => -30,
				],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => '--ep-slider-dots-nny: -{{SIZE}}px;'
				],
				'conditions'   => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'dots',
						],
						[
							'name'     => 'dots_position',
							'operator' => '!=',
							'value'    => '',
						],
					],
				],
			]
		);

		$this->add_responsive_control(
			'both_ncx_position',
			[
				'label'   => __( 'Arrows & Dots Horizontal Offset', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
				],
				'tablet_default' => [
					'size' => 0,
				],
				'mobile_default' => [
					'size' => 0,
				],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'conditions'   => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'both',
						],
						[
							'name'     => 'both_position',
							'operator' => '!=',
							'value'    => 'center',
						],
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => '--ep-slider-both-ncx: {{SIZE}}px;'
				],
			]
		);

		$this->add_responsive_control(
			'both_ncy_position',
			[
				'label'   => __( 'Arrows & Dots Vertical Offset', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 40,
				],
				'tablet_default' => [
					'size' => 40,
				],
				'mobile_default' => [
					'size' => 40,
				],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => '--ep-slider-both-ncy: {{SIZE}}px;'
				],
				'conditions'   => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'both',
						],
						[
							'name'     => 'both_position',
							'operator' => '!=',
							'value'    => 'center',
						],
					],
				],
			]
		);

		$this->add_responsive_control(
			'both_cx_position',
			[
				'label'   => __( 'Arrows Offset', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 35,
				],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .rbt-navigation-prev' => 'left: {{SIZE}}px;',
					'{{WRAPPER}} .rbt-slider .rbt-navigation-next' => 'right: {{SIZE}}px;',
				],
				'conditions' => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'both',
						],
						[
							'name'  => 'both_position',
							'value' => 'center',
						],
					],
				],
			]
		);

		$this->add_responsive_control(
			'both_cy_position',
			[
				'label'   => __( 'Dots Offset', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => -55,
				],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .rbt-dots-container' => 'transform: translateY({{SIZE}}px);',
				],
				'conditions' => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'both',
						],
						[
							'name'  => 'both_position',
							'value' => 'center',
						],
					],
				],
			]
		);

		$this->add_responsive_control(
			'arrows_fraction_ncx_position',
			[
				'label'   => __( 'Arrows & Fraction Horizontal Offset', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
				],
				'tablet_default' => [
					'size' => 0,
				],
				'mobile_default' => [
					'size' => 0,
				],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'conditions'   => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows-fraction',
						],
						[
							'name'     => 'arrows_fraction_position',
							'operator' => '!=',
							'value'    => 'center',
						],
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => '--ep-slider-arrows-fraction-ncx: {{SIZE}}px;'
				],
			]
		);

		$this->add_responsive_control(
			'arrows_fraction_ncy_position',
			[
				'label'   => __( 'Arrows & Fraction Vertical Offset', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 40,
				],
				'tablet_default' => [
					'size' => 40,
				],
				'mobile_default' => [
					'size' => 40,
				],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => '--ep-slider-arrows-fraction-ncy: {{SIZE}}px;'
				],
				'conditions'   => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows-fraction',
						],
						[
							'name'     => 'arrows_fraction_position',
							'operator' => '!=',
							'value'    => 'center',
						],
					],
				],
			]
		);

		$this->add_responsive_control(
			'arrows_fraction_cx_position',
			[
				'label'   => __( 'Arrows Offset', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 35,
				],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .rbt-navigation-prev' => 'left: {{SIZE}}px;',
					'{{WRAPPER}} .rbt-slider .rbt-navigation-next' => 'right: {{SIZE}}px;',
				],
				'conditions' => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows-fraction',
						],
						[
							'name'  => 'arrows_fraction_position',
							'value' => 'center',
						],
					],
				],
			]
		);

		$this->add_responsive_control(
			'arrows_fraction_cy_position',
			[
				'label'   => __( 'Fraction Offset', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => -55,
				],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .swiper-pagination-fraction' => 'transform: translateY({{SIZE}}px);',
				],
				'conditions' => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows-fraction',
						],
						[
							'name'  => 'arrows_fraction_position',
							'value' => 'center',
						],
					],
				],
			]
		);

		$this->add_responsive_control(
			'progress_y_position',
			[
				'label'   => __( 'Progress Offset', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 15,
				],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .swiper-pagination-progressbar' => 'transform: translateY({{SIZE}}px);',
				],
				'condition' => [
					'navigation' => 'progressbar',
				],
			]
		);

		$this->add_responsive_control(
			'scrollbar_vertical_offset',
			[
				'label'   => __( 'Scrollbar Offset', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .rbt-slider .swiper-container-horizontal > .swiper-scrollbar' => 'bottom: {{SIZE}}px;',
				],
				'condition'   => [
					'show_scrollbar' => 'yes'
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_style_animation() {

		$this->start_controls_section(
			'section_style_animation',
			[
				'label' => esc_html__( 'Animation', TEXT_DOMAIN ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'kenburns_animation',
			[
				'label'     => esc_html__( 'Kenburns Animation', TEXT_DOMAIN ),
				'separator' => 'before',
				'type'      => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'kenburns_reverse',
			[
				'label'     => esc_html__( 'Kenburn Reverse', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
				'condition' => [
					'kenburns_animation' => 'yes'
				]
			]
		);

		$this->add_control(
			'parallax_pre_title_x_start',
			[
				'label' => esc_html__( 'X Start Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 200,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_pre_title' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_pre_title_x_end',
			[
				'label' => esc_html__( 'X End Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => -200,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_pre_title' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_pre_title_y_start',
			[
				'label' => esc_html__( 'Y Start Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_pre_title' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_pre_title_y_end',
			[
				'label' => esc_html__( 'Y End Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_pre_title' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_title',
			[
				'label'     => esc_html__( 'Parallax Title', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
				'separator' => 'before',
				'condition' => [
					'show_title' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_title_x_start',
			[
				'label' => esc_html__( 'X Start Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 300,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_title' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_title_x_end',
			[
				'label' => esc_html__( 'X End Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => -300,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_title' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_title_y_start',
			[
				'label' => esc_html__( 'Y Start Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_title' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_title_y_end',
			[
				'label' => esc_html__( 'Y End Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_title' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_post_title',
			[
				'label'     => esc_html__( 'Parallax Post Title', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
				'separator' => 'before',
				'condition' => [
					'show_post_title' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_post_title_x_start',
			[
				'label' => esc_html__( 'X Start Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 350,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_post_title' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_post_title_x_end',
			[
				'label' => esc_html__( 'X End Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => -350,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_post_title' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_post_title_y_start',
			[
				'label' => esc_html__( 'Y Start Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_post_title' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_post_title_y_end',
			[
				'label' => esc_html__( 'Y End Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_post_title' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_text',
			[
				'label'     => esc_html__( 'Parallax Text', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
				'separator' => 'before',
				'condition' => [
					'show_text' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_text_x_start',
			[
				'label' => esc_html__( 'X Start Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 500,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_text' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_text_x_end',
			[
				'label' => esc_html__( 'X End Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => -500,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_text' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_text_y_start',
			[
				'label' => esc_html__( 'Y Start Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_text' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_text_y_end',
			[
				'label' => esc_html__( 'Y End Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_text' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_button',
			[
				'label'     => esc_html__( 'Parallax Button', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
				'separator' => 'before',
				'condition' => [
				'show_text' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_button_x_start',
			[
				'label' => esc_html__( 'X Start Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => -150,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_button' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_button_x_end',
			[
				'label' => esc_html__( 'X End Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 150,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_button' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_button_y_start',
			[
				'label' => esc_html__( 'Y Start Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_button' => 'yes',
				],
			]
		);

		$this->add_control(
			'parallax_button_y_end',
			[
				'label' => esc_html__( 'Y End Value', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
				],
				'range' => [
					'px' => [
						'min' => -500,
						'max' => 500,
					],
				],
				'condition' => [
					'parallax_button' => 'yes',
				],
			]
		);

		$this->end_controls_section();

		

	}

    // render 
	protected function render_loop_header() {
		$settings = $this->get_settings_for_display();
		$id       = 'rbt-slider-' . $this->get_id();

		$this->add_render_attribute( 'slider', 'id', $id );
		$this->add_render_attribute( 'slider', 'class', 'rbt-slider' );

		if ('arrows' == $settings['navigation']) {
			$this->add_render_attribute( 'slider', 'class', 'rbt-arrows-align-'. $settings['arrows_position'] );
		} elseif ('dots' == $settings['navigation']) {
			$this->add_render_attribute( 'slider', 'class', 'rbt-dots-align-'. $settings['dots_position'] );
		} elseif ('both' == $settings['navigation']) {
			$this->add_render_attribute( 'slider', 'class', 'rbt-arrows-dots-align-'. $settings['both_position'] );
		} elseif ('arrows-fraction' == $settings['navigation']) {
			$this->add_render_attribute( 'slider', 'class', 'rbt-arrows-dots-align-'. $settings['arrows_fraction_position'] );
		}

		if ('arrows-fraction' == $settings['navigation'] ) {
			$pagination_type = 'fraction';
		} elseif ('both' == $settings['navigation'] or 'dots' == $settings['navigation']) {
			$pagination_type = 'bullets';
		} elseif ('progressbar' == $settings['navigation'] ) {
			$pagination_type = 'progressbar';
		} else {
			$pagination_type = '';
		}

		$this->add_render_attribute(
			[
				'slider' => [
					'data-settings' => [
						wp_json_encode(array_filter([
							"autoplay" => ("yes" == $settings["autoplay"]) ? ["delay" => $settings["autoplay_speed"]] : false,
							"loop" => ($settings["loop"] == "yes") ? true : false,
                            "speed" => $settings["speed"]["size"],
							"pauseOnHover" => ("yes" == $settings["pauseonhover"]) ? true : false,
							"effect"       => $settings["transition"],
					        "navigation" => [
								"nextEl" => "#" . $id . " .rbt-navigation-next",
								"prevEl" => "#" . $id . " .rbt-navigation-prev",
							],
							"pagination" => [
								"el"             => "#" . $id . " .swiper-pagination",
								"type"           => $pagination_type,
								"clickable"      => "true",
								'dynamicBullets' => ("yes" == $settings["dynamic_bullets"]) ? true : false,

							],
			      			"scrollbar" => [
								"el"            => "#" . $id . " .swiper-scrollbar",
								"hide"          => "true",
							],
				        ]))
					]
				]
			]
		);

		if ( ! isset( $settings['scroll_to_section_icon'] ) && ! Icons_Manager::is_migration_allowed() ) {
			// add old default
			$settings['scroll_to_section_icon'] = 'fas fa-arrow-down';
		}

		$migrated  = isset( $settings['__fa4_migrated']['slider_scroll_to_section_icon'] );
		$is_new    = empty( $settings['scroll_to_section_icon'] ) && Icons_Manager::is_migration_allowed();

		?>
		<div <?php echo $this->get_render_attribute_string( 'slider' ); ?>>
			<div class="swiper-container">
					<div class="rbt-ep-scroll-to-section rbt-position-bottom-center">
						<a href="<?php echo esc_url($settings['section_id']); ?>" rbt-scroll>
							<span class="rbt-ep-scroll-to-section-icon">

								<?php if ( $is_new || $migrated ) :
									Icons_Manager::render_icon( $settings['slider_scroll_to_section_icon'], [ 'aria-hidden' => 'true', 'class' => 'fa-fw' ] );
								else : ?>
									<i class="<?php echo esc_attr( $settings['scroll_to_section_icon'] ); ?>" aria-hidden="true"></i>
								<?php endif; ?>

							</span>
						</a>
					</div>
				<?php
	}

	public function render_navigation() {
		$settings = $this->get_settings_for_display();
		$hide_arrow_on_mobile = $settings['hide_arrow_on_mobile'] ? ' rbt-visible@m' : '';
		
		if ( 'arrows' == $settings['navigation'] ) : ?>
			<div class="rbt-position-z-index rbt-position-<?php echo esc_attr( $settings['arrows_position'] . $hide_arrow_on_mobile ); ?>">
				<div class="rbt-arrows-container rbt-slidenav-container">
					<a href="" class="rbt-navigation-prev rbt-slidenav-previous rbt-icon rbt-slidenav">
						<i class="ep-arrow-left-<?php echo esc_attr($settings['nav_arrows_icon']); ?>" aria-hidden="true"></i>
					</a>
					<a href="" class="rbt-navigation-next rbt-slidenav-next rbt-icon rbt-slidenav">
						<i class="ep-arrow-right-<?php echo esc_attr($settings['nav_arrows_icon']); ?>" aria-hidden="true"></i>
					</a>
				</div>
			</div>
		<?php endif;
	}

	public function render_pagination() {
		$settings = $this->get_settings_for_display();
		
		if ( 'dots' == $settings['navigation'] or 'arrows-fraction' == $settings['navigation'] ) : ?>
			<div class="rbt-position-z-index rbt-position-<?php echo esc_attr($settings['dots_position']); ?>">
				<div class="rbt-dots-container">
					<div class="swiper-pagination"></div>
				</div>
			</div>

		<?php elseif ( 'progressbar' == $settings['navigation'] ) : ?>
			<div class="swiper-pagination rbt-position-z-index rbt-position-<?php echo esc_attr($settings['progress_position']); ?>"></div>
		<?php endif;
	}

	public function render_both_navigation() {
		$settings = $this->get_settings_for_display();
		$hide_arrow_on_mobile = $settings['hide_arrow_on_mobile'] ? 'rbt-visible@m' : '';
		
		?>
		<div class="rbt-position-z-index rbt-position-<?php echo esc_attr($settings['both_position']); ?>">
			<div class="rbt-arrows-dots-container rbt-slidenav-container ">
				
				<div class="rbt-flex rbt-flex-middle">
					<div class="<?php echo esc_attr( $hide_arrow_on_mobile ); ?>">
						<a href="" class="rbt-navigation-prev rbt-slidenav-previous rbt-icon rbt-slidenav">
							<i class="ep-arrow-left-<?php echo esc_attr($settings['nav_arrows_icon']); ?>" aria-hidden="true"></i>
						</a>
					</div>

					<?php if ('center' !== $settings['both_position']) : ?>
						<div class="swiper-pagination"></div>
					<?php endif; ?>
					
					<div class="<?php echo esc_attr( $hide_arrow_on_mobile ); ?>">
						<a href="" class="rbt-navigation-next rbt-slidenav-next rbt-icon rbt-slidenav">
							<i class="ep-arrow-right-<?php echo esc_attr($settings['nav_arrows_icon']); ?>" aria-hidden="true"></i>
						</a>
					</div>
					
				</div>
			</div>
		</div>		
		<?php
	}

	public function render_arrows_fraction() {
		$settings             = $this->get_settings_for_display();
		$hide_arrow_on_mobile = $settings['hide_arrow_on_mobile'] ? 'rbt-visible@m' : '';
		
		?>
		<div class="rbt-position-z-index rbt-position-<?php echo esc_attr($settings['arrows_fraction_position']); ?>">
			<div class="rbt-arrows-fraction-container rbt-slidenav-container ">
				
				<div class="rbt-flex rbt-flex-middle">
					<div class="<?php echo esc_attr( $hide_arrow_on_mobile ); ?>">
						<a href="" class="rbt-navigation-prev rbt-slidenav-previous rbt-icon rbt-slidenav">
							<i class="ep-arrow-left-<?php echo esc_attr($settings['nav_arrows_icon']); ?>" aria-hidden="true"></i>
						</a>
					</div>

					<?php if ('center' !== $settings['arrows_fraction_position']) : ?>
						<div class="swiper-pagination"></div>
					<?php endif; ?>
					
					<div class="<?php echo esc_attr( $hide_arrow_on_mobile ); ?>">
						<a href="" class="rbt-navigation-next rbt-slidenav-next rbt-icon rbt-slidenav">
							<i class="ep-arrow-right-<?php echo esc_attr($settings['nav_arrows_icon']); ?>" aria-hidden="true"></i>
						</a>
					</div>
					
				</div>
			</div>
		</div>		
		<?php
	}

	protected function render_loop_footer() {
		$settings    = $this->get_settings_for_display();

		?>
			<?php if ( 'yes' === $settings['show_scrollbar'] ) : ?>
			<div class="swiper-scrollbar"></div>
			<?php endif; ?>
		</div>
			<?php if ('both' == $settings['navigation']) : ?>
				<?php $this->render_both_navigation(); ?>
				<?php if ( 'center' === $settings['both_position'] ) : ?>
					<div class="rbt-position-z-index rbt-position-bottom">
						<div class="rbt-dots-container">
							<div class="swiper-pagination"></div>
						</div>
					</div>
				<?php endif; ?>
			<?php elseif ('arrows-fraction' == $settings['navigation']) : ?>
				<?php $this->render_arrows_fraction(); ?>
				<?php if ( 'center' === $settings['arrows_fraction_position'] ) : ?>
					<div class="rbt-dots-container">
						<div class="swiper-pagination"></div>
					</div>
				<?php endif; ?>
			<?php else : ?>			
				<?php $this->render_pagination(); ?>
				<?php $this->render_navigation(); ?>
			<?php endif; ?>
		</div>

		<?php
	}

	protected function render_item_image($image) {
		$image_src = wp_get_attachment_image_src( $image['image']['id'], 'full' );

		if ($image_src) :
			echo '<img src="' . esc_url($image_src[0]) . '" alt="' . get_the_title() . '" rbt-cover>';
		endif;

		return 0;
	}

	protected function render_item_video($link) {
		$video_src = $link['video_link'];

		?>
		<video autoplay loop muted playslinline rbt-cover>
			<source src="<?php echo  $video_src; ?>" type="video/mp4">
		</video>
		<?php
	}

	protected function render_item_youtube($link) {
		$match = [];
		$id = (preg_match( '%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i', $link['youtube_link'], $match ) ) ? $match[1] : false;
		 $url = '//www.youtube.com/embed/' . $id . '?autoplay=1&amp;controls=0&amp;showinfo=0&amp;rel=0&amp;loop=1&amp;modestbranding=1&amp;wmode=transparent&amp;playsinline=1';

		?>
		<iframe src="<?php echo  esc_url( $url); ?>" frameborder="0" allowfullscreen rbt-cover></iframe>
		<?php
	}

	protected function render_item_content($content) {
		$settings            = $this->get_settings_for_display();
		$animation           = ($settings['button_hover_animation']) ? ' elementor-animation-'.$settings['button_hover_animation'] : '';
	
		if ( ! isset( $settings['icon'] ) && ! Icons_Manager::is_migration_allowed() ) {
			// add old default
			$settings['icon'] = 'fas fa-arrow-right';
		}

		$migrated  = isset( $settings['__fa4_migrated']['slideshow_icon'] );
		$is_new    = empty( $settings['icon'] ) && Icons_Manager::is_migration_allowed();

		?>
        <div class="rbt-slideshow-content-wrapper rbt-position-z-index rbt-position-<?php echo esc_attr($settings['content_position']); ?> rbt-position-large rbt-text-<?php echo esc_attr($settings['content_align']); ?>">
		
        	<?php if ($content['pre_title'] && ( $settings['show_pre_title'] )) : ?>
				<div>
					<h4 class="rbt-slideshow-pre-title rbt-display-inline-block">
			            <?php echo esc_attr($content['pre_title']); ?>
			        </h4>
		        </div>
			<?php endif; ?>

			<?php if ($content['title'] && ( $settings['show_title'] )) : ?>
				<div>
					<<?php echo esc_attr($settings['title_tag']); ?> class="rbt-slideshow-title rbt-display-inline-block" >
				        <?php echo wp_kses_post($content['title']); ?>
					</<?php echo esc_attr($settings['title_tag']); ?>>
			    </div>
			<?php endif; ?>

			<?php if ($content['text'] && ( $settings['show_text'] )): ?>
				<div class="rbt-slideshow-text">
				    <?php echo wp_kses_post($content['text']); ?>
			    </div>
			<?php endif; ?>

			<?php if ((!empty( $content['button_link']['url'])) && ( $settings['show_button'] ) && ($settings['button_text'])): ?>
				<div>
					<a href="<?php echo esc_url($content['button_link']['url']); ?>" target="<?php echo ($content['button_link']['is_external']) ? '_blank' : '_self'; ?>" class="rbt-slideshow-button rbt-display-inline-block<?php echo esc_attr($animation); ?>" rel="<?php echo esc_url($content['button_link']['nofollow']) ? 'nofollow' : 'noreferrer'; ?>">

					    <?php echo esc_attr($settings['button_text']); ?>
					
						<?php if ($settings['slideshow_icon']['value']) : ?>
							<span class="rbt-button-icon-align-<?php echo esc_attr($settings['icon_align']); ?> rbt-slideshow-button-icon-<?php echo esc_attr($settings['icon_align']); ?>">

								<?php if ( $is_new || $migrated ) :
									Icons_Manager::render_icon( $settings['slideshow_icon'], [ 'aria-hidden' => 'true', 'class' => 'fa-fw' ] );
								else : ?>
									<i class="<?php echo esc_attr( $settings['icon'] ); ?>" aria-hidden="true"></i>
								<?php endif; ?>

							</span>
						<?php endif; ?>

				    </a>
			    </div>
			<?php endif; ?>
		</div>

		<?php
	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		$this->render_loop_header();
		$kenburns_reverse = $settings['kenburns_reverse'] ? ' rbt-animation-reverse' : '';
		?>
		<div class="swiper-wrapper">
			<?php $counter = 1; ?>
			<?php foreach ( $settings['slides'] as $slide ) : ?>

				<?php 
				$this->add_render_attribute(
					[
						'slide-item' => [
							'class' => [
								'rbt-slide-item',
								'swiper-slide',
								'rbt-slide-effect-' . $settings['effect']
							],
						]
					], '', '', true
				);

				?>				
				<div <?php echo $this->get_render_attribute_string( 'slide-item' ); ?>>

					<?php
					if ( 'custom' == $slide['source'] ) {
					?>

                        <?php if( $settings['kenburns_animation'] ) : ?>
					        <div class="rbt-position-cover rbt-animation-kenburns<?php echo esc_attr( $kenburns_reverse ); ?> rbt-transform-origin-center-left">
				        <?php endif; ?>

							<?php if (( $slide['background'] == 'image' ) && $slide['image']) : ?>
								<?php $this->render_item_image($slide); ?>
							<?php elseif (( $slide['background'] == 'video' ) && $slide['video_link']) : ?>
								<?php $this->render_item_video($slide); ?>
							<?php elseif (( $slide['background'] == 'youtube' ) && $slide['youtube_link']) : ?>
								<?php $this->render_item_youtube($slide); ?>
							<?php endif; ?>

						<?php if( $settings['kenburns_animation'] ) : ?>
		                    </div>
		                <?php endif; ?>

						<?php if( 'none' !== $settings['overlay'] ) :
		        	        $blend_type = ( 'blend' == $settings['overlay']) ? ' rbt-blend-'.$settings['blend_type'] : ''; ?>
		                    <div class="rbt-overlay-default rbt-position-cover<?php echo esc_attr($blend_type); ?>"></div>
		                <?php endif; ?>

						<?php $this->render_item_content($slide); ?>

                    <?php
					} elseif ( "elementor" == $item['source'] ) {
						echo RoboTheme_Loader::elementor()->frontend->get_builder_content_for_display( $item['template_id'] );
						echo rbt_template_edit_link( $item['template_id'] );
					}
					?>
				</div>
				<?php
				
			$counter++;
			endforeach;
			?>
		</div>
		<?php
		$this->render_loop_footer();
	}

}