<?php

namespace RoboTheme\inc\elementor\Modules\Posts\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Utils;
use Elementor\Icons_Manager;
use Elementor\Plugin;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Post_Grid extends Posts {

	public function get_name() {
		return 'rbt-post-grid';
	}

	public function get_title() {
		return __( 'Post Grid', TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-posts-grid';
	}

	public function get_categories() {
		return [ RBT_CAT ];
	}


	public function get_keywords() {
		return [ 'post', 'grid', 'archive', 'blog' ];
	}

	protected function register_controls() {
		parent::register_controls();
		$this->add_controls_content_layout();
		$this->add_controls_style_item();
		$this->register_controls_style_pagination();
	}

    // controlls //
	protected function add_controls_content_layout() {
		$this->start_injection( [
			'of' => 'posts_per_page',
		] );

		$this->add_responsive_control(
			'columns_grid',
			[
				'label' => __( 'Number of Columns', TEXT_DOMAIN ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					''       => __( 'None', TEXT_DOMAIN ),
					'100%'       => __( '1', TEXT_DOMAIN ),
					'50%'        => __( '2', TEXT_DOMAIN ),
					'33.333333%' => __( '3', TEXT_DOMAIN ),
					'25%'        => __( '4', TEXT_DOMAIN ),
					'20%'        => __( '5', TEXT_DOMAIN ),
					'16.666667%' => __( '6', TEXT_DOMAIN ),
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => '33.333333%',
				'tablet_default' => '50%',
				'mobile_default' => '100%',
				'selectors' => [
					'{{WRAPPER}} .post-grid > *' => '-ms-flex: 0 0 {{VALUE}};flex: 0 0 {{VALUE}};max-width: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'type_posts',
			[
				'label' => __( 'Type Post', TEXT_DOMAIN ),
				'type' => Controls_Manager::SELECT,
				'default' => 'grid',
				'options' => [
					'grid'       => __( 'Grid', TEXT_DOMAIN ),
					'loop'       => __( 'Loop', TEXT_DOMAIN ),
				],
			]
		);

		$this->add_control(
			'show_pagination',
			[
				'label' => esc_html__( 'Pagination', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_injection();

	}

	protected function add_controls_style_item() {
		$this->start_injection( [
			'of' => 'item_info_padding',
		] );

		$this->add_responsive_control(
			'item_gap',
			[
				'label'      => __( 'Item Gap', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
                    'top' => 20,
                    'right' => 20,
                    'bottom' => 20,
                    'left' => 20,
					'unit' => 'px'
				],
				'selectors' => [
					'{{WRAPPER}} .mz-posts' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'item_border_radius',
			[
				'label'      => __( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .mz-posts' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);

		$this->start_controls_tabs('tabs_item_style');
		$this->start_controls_tab(
			'tab_item_normal',
			[
				'label' => __( 'Normal', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'item_background',
			[
				'label'     => __( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .post-grid .mz-posts' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'item_shadow',
				'selector' => '{{WRAPPER}} .post-grid .mz-posts',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'item_border',
				'label'       => __( 'Border', TEXT_DOMAIN ),
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .post-grid .mz-posts',
			]
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_item_hover',
			[
				'label' => __( 'Hover', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'item_hover_background',
			[
				'label'     => __( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .post-grid .mz-posts:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_hover_border_color',
			[
				'label'     => __( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .post-grid .mz-posts:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'item_hover_shadow',
				'selector' => '{{WRAPPER}} .post-grid .mz-posts:hover',
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_injection();
	}

	protected function register_controls_style_pagination() {
		$this->start_controls_section(
			'section_style_pagination',
			[
				'label'     => esc_html__( 'Pagination', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);
	
		$this->start_controls_tabs( 'tabs_pagination_style' );
	
		$this->start_controls_tab(
			'tab_pagination_normal',
			[
				'label' => esc_html__( 'Normal', TEXT_DOMAIN ),
			]
		);
	
		$this->add_control(
			'pagination_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.rbt-pagination li a, {{WRAPPER}} ul.rbt-pagination li span' => 'color: {{VALUE}};',
				],
			]
		);
	
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'      => 'pagination_background',
				'selector'  => '{{WRAPPER}} ul.rbt-pagination li a',
				'separator' => 'after',
			]
		);
	
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'pagination_border',
				'label'    => esc_html__( 'Border', TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} ul.rbt-pagination li a',
			]
		);
	
		$this->add_responsive_control(
			'pagination_offset',
			[
				'label'     => esc_html__( 'Offset', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .rbt-pagination' => 'margin-top: {{SIZE}}px;',
				],
			]
		);
	
		$this->add_responsive_control(
			'pagination_space',
			[
				'label'     => esc_html__( 'Spacing', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .rbt-pagination'     => 'margin-left: {{SIZE}}px;',
					'{{WRAPPER}} .rbt-pagination > *' => 'padding-left: {{SIZE}}px;',
				],
			]
		);
	
		$this->add_responsive_control(
			'pagination_padding',
			[
				'label'     => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} ul.rbt-pagination li a' => 'padding: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				],
			]
		);
	
		$this->add_responsive_control(
			'pagination_radius',
			[
				'label'     => esc_html__( 'Radius', TEXT_DOMAIN ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} ul.rbt-pagination li a' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				],
			]
		);
	
		$this->add_responsive_control(
			'pagination_arrow_size',
			[
				'label'     => esc_html__( 'Arrow Size', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} ul.rbt-pagination li a svg' => 'height: {{SIZE}}px; width: auto;',
				],
			]
		);
	
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'pagination_typography',
				'label'    => esc_html__( 'Typography', TEXT_DOMAIN ),
				//'scheme'   => Schemes\Typography::TYPOGRAPHY_4,
				'selector' => '{{WRAPPER}} ul.rbt-pagination li a, {{WRAPPER}} ul.rbt-pagination li span',
			]
		);
	
		$this->end_controls_tab();
	
		$this->start_controls_tab(
			'tab_pagination_hover',
			[
				'label' => esc_html__( 'Hover', TEXT_DOMAIN ),
			]
		);
	
		$this->add_control(
			'pagination_hover_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.rbt-pagination li a:hover' => 'color: {{VALUE}};',
				],
			]
		);
	
		$this->add_control(
			'pagination_hover_border_color',
			[
				'label'     => esc_html__( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.rbt-pagination li a:hover' => 'border-color: {{VALUE}};',
				],
			]
		);
	
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'pagination_hover_background',
				'selector' => '{{WRAPPER}} ul.rbt-pagination li a:hover',
			]
		);
	
		$this->end_controls_tab();
	
		$this->start_controls_tab(
			'tab_pagination_active',
			[
				'label' => esc_html__( 'Active', TEXT_DOMAIN ),
			]
		);
	
		$this->add_control(
			'pagination_active_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.rbt-pagination li.rbt-active a' => 'color: {{VALUE}};',
				],
			]
		);
	
		$this->add_control(
			'pagination_active_border_color',
			[
				'label'     => esc_html__( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.rbt-pagination li.rbt-active a' => 'border-color: {{VALUE}};',
				],
			]
		);
	
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'pagination_active_background',
				'selector' => '{{WRAPPER}} ul.rbt-pagination li.rbt-active a',
			]
		);
	
		$this->end_controls_tab();
	
		$this->end_controls_tabs();		
	
		$this->end_controls_section();

	}

    public function not_found() {

		echo "<div class='page-header'>". "</div>";
			
		echo "<div class='page-content'>"
		        . "<h1 class='page-title'>" . __( 'Nothing Found', TEXT_DOMAIN ) . "</h1>";
			if ( is_home() && current_user_can( 'publish_posts' ) ) :
				printf('<p>' . wp_kses(__( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'karauos' ),	array('a' => array('href' => array(),),)) . '</p>',esc_url( admin_url( 'post-new.php' ) ));
			elseif ( is_search() ) :
				echo '<p>' . __('Sorry, but nothing matched your search terms. Please try again with some different keywords.', TEXT_DOMAIN) . '</p>';get_search_form();
			else :
				echo '<p>' . __('It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', TEXT_DOMAIN) . '</p>';get_search_form();
			endif;wp_reset_postdata();
		echo "</div>";

	}

	public function post_grid($wp_query){

		echo "<div class='post-grid flex flex-wrap'>";
			while ( $wp_query->have_posts() ) { $wp_query->the_post();
			echo "<div>";
				$this->render_post();
			echo "</div>";
		}
		echo "</div>";

		if ($settings['show_pagination']) { ?>
			<div class="rbt-num-pagination">
				<?php rbt_post_pagination($wp_query); ?>
			</div>
			<?php
		}
		wp_reset_postdata();

	}

	public function post_loop($wp_query) {

		echo "<div class='post-grid flex flex-wrap'>";
		
			if ( have_posts() ) :
				while ( have_posts() ) : 
					the_post();
						echo "<div>";
							$this->render_post();
						echo "</div>";
				endwhile;
			else :
				$this->not_found();
			endif;

	    echo "</div>";
		
	}

	public function post_editor($wp_query) {

		echo "<div class='post-grid flex flex-wrap'>";
			while ( $wp_query->have_posts() ) { $wp_query->the_post();
				echo "<div>";
					$this->render_post();
				echo "</div>";
			}
	    echo "</div>";

	}

    public function render(){
		$settings = $this->get_settings_for_display();
		$editor = Plugin::$instance->editor->is_edit_mode();

		$this->query_posts();
		$wp_query = $this->get_query();

		if ( ! $wp_query->found_posts ) {
			return;
		}

		switch ($settings['type_posts']) {

			case "grid":
				$this->post_grid($wp_query);
			break;

			case "loop":
				if($editor){
					$this->post_editor($wp_query);
				}
				else{
					$this->post_loop($wp_query);
				}
			break;

		}
	
	}

}