<?php
namespace RoboTheme\inc\elementor\Modules\PostList\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Background;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class RBT_Post_List extends Widget_Base {

	public function get_name() {
		return 'rbt-post-list';
	}

	public function get_title() {
		return esc_html__( 'Post List', TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-post-list';
	}

	public function get_categories() {
		return [ RBT_CAT ];
	}

	public function get_keywords() {
		return [ 'post', 'list', 'blog', 'recent', 'news' ];
	}

	public function get_style_depends() {
		return [ 'rbt-post-list' ];
	}

	protected function register_controls() {
		$this->register_content_controls_controls();
		$this->register_content_query_controls_controls();
		$this->register_style_image_controls_controls();
		$this->register_style_title_controls_controls();
		$this->register_style_data_controls_controls();
		$this->register_style_list_style_controls_controls();
	}

	protected function register_content_controls_controls() {

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'show_title',
			[
				'label'   => esc_html__( 'Title', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'title_tags',
			[
				'label'   => __( 'Title HTML Tag', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h4',
				'options' => [
					'h1'   => 'H1',
					'h2'   => 'H2',
					'h3'   => 'H3',
					'h4'   => 'H4',
					'h5'   => 'H5',
					'h6'   => 'H6',
					'div'  => 'div',
					'span' => 'span',
					'p'    => 'p',
				],
				'condition' => [
					'show_title' => 'yes'
				]
			]
		);

		$this->add_control(
			'show_horizontal',
			[
				'label' => esc_html__( 'Horizontal Layout', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'column',
			[
				'label'       => esc_html__( 'Column', TEXT_DOMAIN ),
				'type'        => Controls_Manager::SELECT,
				'default'     => '2',
				'description' => 'For good looking set it 1 for default skin and 2 for another skin',
				'options'     => [
					'2' => esc_html__( 'Two', TEXT_DOMAIN ),
					'3' => esc_html__( 'Three', TEXT_DOMAIN ),
					'4' => esc_html__( 'Four', TEXT_DOMAIN ),
				],
				'condition' => [
					'show_horizontal' => 'yes',
				],
			]
		);

		$this->add_control(
			'show_date',
			[
				'label'   => esc_html__( 'Date', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_category',
			[
				'label'   => esc_html__( 'Category', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_divider',
			[
				'label'   => esc_html__( 'Divider', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'space_between',
			[
				'label'      => esc_html__( 'Space Between', TEXT_DOMAIN ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'      => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'separator' => 'before',
				'selectors' => [
				'{{WRAPPER}} .rbt-post-list .rbt-list > li:nth-child(n+2)' => 'margin-top: {{SIZE}}{{UNIT}}; padding-top: {{SIZE}}{{UNIT}};',				
				'{{WRAPPER}} .rbt-post-list .rbt-child-width-1-3\@m li:nth-child(n+4)' => 'margin-top: {{SIZE}}{{UNIT}}; padding-top: 0;',		
				'{{WRAPPER}} .rbt-post-list .rbt-child-width-1-2\@m li:nth-child(n+3)' => 'margin-top: {{SIZE}}{{UNIT}}; padding-top: 0;',		
				'{{WRAPPER}} .rbt-post-list .rbt-child-width-1-4\@m li:nth-child(n+5)' => 'margin-top: {{SIZE}}{{UNIT}}; padding-top: 0;',
				'{{WRAPPER}} .rbt-post-list .rbt-child-width-1-2\@m li:nth-child(n+3) > div' => 'padding-top: {{SIZE}}{{UNIT}};',				
				'{{WRAPPER}} .rbt-post-list .rbt-child-width-1-3\@m li:nth-child(n+4) > div' => 'padding-top: {{SIZE}}{{UNIT}};',				
				'{{WRAPPER}} .rbt-post-list .rbt-child-width-1-4\@m li:nth-child(n+5) > div' => 'padding-top: {{SIZE}}{{UNIT}};',					
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_content_query_controls_controls() {

		$this->start_controls_section(
			'section_query',
			[
				'label' => esc_html__( 'Query', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'source',
			[
				'label'   => _x( 'Source', 'Posts Query Control', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					''        => esc_html__( 'Show All', TEXT_DOMAIN ),
					'by_name' => esc_html__( 'Manual Selection', TEXT_DOMAIN ),
				],
			]
		);

		$post_categories = get_terms( 'category' );

		$post_options = [];
		foreach ( $post_categories as $category ) {
			$post_options[ $category->slug ] = $category->name;
		}

		$this->add_control(
			'post_categories',
			[
				'label'       => esc_html__( 'Categories', TEXT_DOMAIN ),
				'type'        => Controls_Manager::SELECT2,
				'options'     => $post_options,
				'default'     => [],
				'label_block' => true,
				'multiple'    => true,
				'condition'   => [
					'source'    => 'by_name',
				],
			]
		);

		$this->add_control(
			'posts_limit',
			[
				'label'   => esc_html__( 'Posts Limit', TEXT_DOMAIN ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 6,
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'   => esc_html__( 'Order by', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => [
					'date'     => esc_html__( 'Date', TEXT_DOMAIN ),
					'title'    => esc_html__( 'Title', TEXT_DOMAIN ),
					'category' => esc_html__( 'Category', TEXT_DOMAIN ),
					'rand'     => esc_html__( 'Random', TEXT_DOMAIN ),
				],
			]
		);

		$this->add_control(
			'order',
			[
				'label'   => esc_html__( 'Order', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'DESC' => esc_html__( 'Descending', TEXT_DOMAIN ),
					'ASC'  => esc_html__( 'Ascending', TEXT_DOMAIN ),
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_style_image_controls_controls() {

		$this->start_controls_section(
			'section_style_image',
			[
				'label' => __( 'Image', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs( 'image_effects' );

		$this->start_controls_tab( 'normal',
			[
				'label' => __( 'Normal', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'list_layout_image_size',
			[
				'label' => esc_html__( 'Image Size', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min'  => 64,
						'max'  => 150,
						'step' => 10,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-thumbnail img' => 'width: {{SIZE}}{{UNIT}}; height: auto;',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'      => 'button_background',
				'separator' => 'before',
				'selector'  => '{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-thumbnail img'
			]
		);

		$this->add_responsive_control(
			'image_padding',
			[
				'label'      => __('Padding', TEXT_DOMAIN),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'separator'  => 'before',
				'selectors'  => [
					'{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-thumbnail img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'image_margin',
			[
				'label'      => __('Margin', TEXT_DOMAIN),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-thumbnail img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'image_border',
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-thumbnail img'
			]
		);

		$this->add_control(
			'image_radius',
			[
				'label'      => __('Radius', TEXT_DOMAIN),
				'type'       => Controls_Manager::DIMENSIONS,
				'separator'  => 'after',
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-thumbnail img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'      => 'image_shadow',
				'selector'  => '{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-thumbnail img'
			]
		);

		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			[
				'name' => 'css_filters',
				'selector' => '{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-thumbnail img',
			]
		);

		$this->add_control(
			'image_opacity',
			[
				'label' => __( 'Opacity', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 1,
						'min' => 0.10,
						'step' => 0.01,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-thumbnail img' => 'opacity: {{SIZE}};',
				],
			]
		);

		$this->add_control(
			'background_hover_transition',
			[
				'label' => __( 'Transition Duration', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0.3,
				],
				'range' => [
					'px' => [
						'max' => 3,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-thumbnail img' => 'transition-duration: {{SIZE}}s',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab( 'hover',
			[
				'label' => __( 'Hover', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'image_hover_background',
			[
				'label'     => __('Background', TEXT_DOMAIN),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-thumbnail:hover img' => 'background-color: {{VALUE}};'
				]
			]
		);

		$this->add_control(
			'image_hover_border_color',
			[
				'label'     => __('Border Color', TEXT_DOMAIN),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-thumbnail:hover img' => 'border-color: {{VALUE}};'
				],
				'condition' => [
					'image_border_border!' => ''
				]
			]
		);

		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			[
				'name' => 'css_filters_hover',
				'selector' => '{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-thumbnail:hover img',
			]
		);

		$this->add_control(
			'image_opacity_hover',
			[
				'label' => __( 'Opacity', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 1,
						'min' => 0.10,
						'step' => 0.01,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-thumbnail:hover img' => 'opacity: {{SIZE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

	}

	protected function register_style_title_controls_controls() {

		$this->start_controls_section(
			'section_style_title',
			[
				'label' => esc_html__( 'Title', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'margin_title',
			[
				'label' => esc_html__( 'Margin', TEXT_DOMAIN ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .rbt-post-list .rbt-post-list-item.list-part .rbt-post-list-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_style_data_controls_controls() {

		$this->start_controls_section(
			'section_style_data',
			[
				'label' => esc_html__( 'Data', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'margin_data',
			[
				'label' => esc_html__( 'Margin', TEXT_DOMAIN ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementor-widget-container .rbt-subnav' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);	

		$this->end_controls_section();

	}

	protected function register_style_list_style_controls_controls() {

		$this->start_controls_section(
			'section_style_list',
			[
				'label' => esc_html__( 'List Style', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);		

		$this->add_control(
			'list_layout_title_category',
			[
				'label' => esc_html__( 'Title', TEXT_DOMAIN ),
				'type'  => Controls_Manager::HEADING,
			]
		);

		$this->add_control(
			'list_layout_title_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-title .rbt-post-list-link' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'list_layout_title_hover_color',
			[
				'label'     => esc_html__( 'Hover Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-title .rbt-post-list-link:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'    => esc_html__( 'Typography', TEXT_DOMAIN ),
				//'scheme'   => Schemes\Typography::TYPOGRAPHY_4,
				'selector' => '{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-title .rbt-post-list-link',
			]
		);

		$this->add_control(
			'date_heading',
			[
				'label'     => esc_html__( 'Date', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
				'condition' => [
					'show_date' => 'yes',
				],
				'separator' => 'before',
			]
		);

		$this->add_control(
			'date_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-meta span' => 'color: {{VALUE}};',
				],
				'condition' => [
					'show_date' => 'yes',
				],
			]
		);

		$this->add_control(
			'date_hover_color',
			[
				'label'     => esc_html__( 'Hover Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-meta span:hover' => 'color: {{VALUE}};',
				],
				'condition' => [
					'show_date' => 'yes',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'date_typography',
				'label'     => esc_html__( 'Typography', TEXT_DOMAIN ),
				//'scheme'    => Schemes\Typography::TYPOGRAPHY_4,
				'selector'  => '{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-meta span',
				'condition' => [
					'show_date' => 'yes',
				],
				
			]
		);

		$this->add_control(
			'category_heading',
			[
				'label'     => esc_html__( 'Category', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
				'condition' => [
					'show_category' => 'yes',
				],
				'separator' => 'before',
			]
		);

		$this->add_control(
			'category_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-meta a' => 'color: {{VALUE}};',
				],
				'condition' => [
					'show_category' => 'yes',
				],
			]
		);

		$this->add_control(
			'category_hover_color',
			[
				'label'     => esc_html__( 'Hover Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-meta a:hover' => 'color: {{VALUE}};',
				],
				'condition' => [
					'show_category' => 'yes',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'category_typography',
				'label'     => esc_html__( 'Typography', TEXT_DOMAIN ),
				//'scheme'    => Schemes\Typography::TYPOGRAPHY_4,
				'selector'  => '{{WRAPPER}} .rbt-post-list .list-part .rbt-post-list-meta a',
				'condition' => [
					'show_category' => 'yes',
				],
			]
		);

		$this->add_control(
			'divider_color',
			[
				'label'     => esc_html__( 'Divider Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-post-list .rbt-has-divider li > div'             => 'border-top-color: {{VALUE}};',
					'{{WRAPPER}} .rbt-post-list .rbt-list-divider > li:nth-child(n+2)' => 'border-top-color: {{VALUE}};',
				],
				'condition' => [
					'show_divider' => 'yes',
				],
				'separator' => 'before',
			]
		);

		$this->end_controls_section();

	}
	
	public function render() {
		$settings = $this->get_settings_for_display();
		$id       = $this->get_id();
				
		if ( $settings['show_horizontal'] ) {
			$this->add_render_attribute('list-wrapper', 'rbt-grid', '' );
			$this->add_render_attribute('list-wrapper', 'class', ['rbt-grid', 'rbt-child-width-1-' . $settings['column'] . '@m'] );
		} else {
			$this->add_render_attribute('list-wrapper', 'class', ['rbt-list', 'rbt-list-large'] );
		}

		$this->add_render_attribute('list-wrapper', 'class', ['rbt-post-list-item', 'list-part'] );
		
		$this->add_render_attribute('rbt-post-list-title', 'class', 'rbt-post-list-title' );

		if ( $settings['show_divider'] ) {
			if ( $settings['show_horizontal'] ) {
				$this->add_render_attribute('list-wrapper', 'class', 'rbt-has-divider' );
			} else {
				$this->add_render_attribute('list-wrapper', 'class', 'rbt-list-divider' );
			}
		}

		$args = array(
			'posts_per_page' => $settings['posts_limit'],
			'orderby'        => $settings['orderby'],
			'order'          => $settings['order'],
			'post_status'    => 'publish'
		);
		
		if ( 'by_name' === $settings['source'] ) :
			$args['tax_query'][] = array(
				'taxonomy' => 'category',
				'field'    => 'slug',
				'terms'    => $settings['post_categories'],
			);
		endif;

		$wp_query = new \WP_Query($args);

		if( $wp_query->have_posts() ) :

			?> 
			<div id="rbt-post-list-<?php echo esc_attr($id); ?>" class="rbt-post-list rbt-post-list-skin-base">
		  		<div rbt-scrollspy="cls: rbt-animation-fade; target: > ul > .rbt-post-list-item; delay: 350;">
		  			<ul <?php echo $this->get_render_attribute_string('list-wrapper'); ?>>
						<?php while ( $wp_query->have_posts() ) : $wp_query->the_post();
							
							$placeholder_image_src = Utils::get_placeholder_image_src();
							$image_src             = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'thumbnail' );

							if ( ! $image_src ) {
								$image_src = $placeholder_image_src;
							} else {
								$image_src = $image_src[0];
							}

							?>
				  			<li <?php echo $this->get_render_attribute_string('list'); ?>>
					  			<div class="rbt-post-list-item-inner">
						  			<div class="rbt-grid rbt-grid-small" rbt-grid>
						  				<div class="rbt-post-list-thumbnail rbt-width-auto">
						  					<a href="<?php echo esc_url(get_permalink()); ?>" title="<?php echo esc_attr(get_the_title()); ?>">
							  					<img src="<?php echo esc_url($image_src); ?>" alt="<?php echo esc_attr(get_the_title()); ?>">
							  				</a>
						  				</div>
								  		<div class="rbt-post-list-desc rbt-width-expand">
											<?php if ($settings['show_title']) : ?>
												<<?php echo esc_html($settings['title_tags']); ?> <?php echo $this->get_render_attribute_string('rbt-post-list-title'); ?>>
													<a href="<?php echo esc_url(get_permalink()); ?>" class="rbt-post-list-link" title="<?php echo esc_attr(get_the_title()); ?>"><?php echo esc_html(get_the_title()) ; ?></a>
												</<?php echo esc_html($settings['title_tags']); ?>>
											<?php endif ?>

							            	<?php if ($settings['show_category'] or $settings['show_date']) : ?>

												<div class="rbt-post-list-meta rbt-subnav rbt-flex-middle">
													<?php if ($settings['show_date']) : ?>
														<?php echo '<span>'.get_the_date().'</span>'; ?>
													<?php endif ?>

													<?php if ($settings['show_category']) : ?>
														<?php echo '<span>'.get_the_category_list(', ').'</span>'; ?>
													<?php endif ?>
													
												</div>

											<?php endif ?>
								  		</div>
									</div>
								</div>
							</li>
						<?php endwhile; ?>
						<?php wp_reset_postdata(); ?>
					</ul>
				</div>
			</div>
		
		 	<?php
		endif;
	}

}