<?php
namespace RoboTheme\inc\elementor\Modules\AdvancedProgressBar\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
    exit;
}
// Exit if accessed directly

class RBT_Advanced_Progress_Bar extends Widget_Base
{

    public function get_name(){
        return 'rbt-advanced-progress-bar';
    }

    public function get_title(){
        return esc_html__('Advanced Progress Bar', TEXT_DOMAIN);
    }

    public function get_icon(){
        return 'eicon-skill-bar';
    }

    public function get_categories(){
        return [RBT_CAT];
    }

    public function get_keywords(){
        return ['advanced bar', 'progress', 'skills', 'bars'];
    }

    public function get_style_depends(){
        return ['rbt-advanced-progress-bar'];
    }

    public function get_script_depends(){
        return ['rbt-advanced-progress-bar'];
    }

    protected function register_controls(){
        $this->register_controls_content();
        $this->register_controls_style_progress();
        $this->register_controls_style_content();
        $this->register_controls_style_percentage();
    }

    protected function register_controls_content() { 
        $this->start_controls_section(
            'section_progress_bars',
            [
                'label' => __('Progress Bars', TEXT_DOMAIN),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'name',
            [
                'type'        => Controls_Manager::TEXT,
                'label'       => __('Name', TEXT_DOMAIN),
                'default'     => __('Design', TEXT_DOMAIN),
                'placeholder' => __('Type a skill name', TEXT_DOMAIN),
            ]
        );

        $repeater->add_control(
            'max_level',
            [
                'label'      => __('Max Value', TEXT_DOMAIN),
                'type'       => Controls_Manager::SLIDER,
                'default'    => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'size_units' => ['%'],
                'range'      => [
                    '%' => [
                        'min'  => 0,
                        'step' => 10,
                        'max'  => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-item{{CURRENT_ITEM}} ' => 'widthX: {{SIZE}}{{UNIT}};',
                ],
                'render_type' => 'template',
            ]
        );

        $repeater->add_control(
            'level',
            [
                'label'      => __('Level (Out Of Max Value)', TEXT_DOMAIN),
                'type'       => Controls_Manager::SLIDER,
                'default'    => [
                    'unit' => '%',
                    'size' => 95,
                ],
                'size_units' => ['%'],
                'range'      => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
            ]
        );

        $repeater->add_control(
            'color',
            [
                'label'     => __('Text Color', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .rbt-advanced-progress-bar .rbt-progress-item{{CURRENT_ITEM}} .rbt-progress-content' => 'color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_control(
            'base_color',
            [
                'label'          => __('Base Color', TEXT_DOMAIN),
                'type'           => Controls_Manager::COLOR,
                'selectors'      => [
                    '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-item{{CURRENT_ITEM}} .rbt-progress-level' => 'background-color: {{VALUE}};',
                ],
                'style_transfer' => true,
            ]
        );

        $repeater->add_control(
            'fill_color',
            [
                'label'          => __('Fill Color', TEXT_DOMAIN),
                'type'           => Controls_Manager::COLOR,
                'selectors'      => [
                    '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-item{{CURRENT_ITEM}} .rbt-progress-fill' => 'background-color: {{VALUE}};',
                ],
                'style_transfer' => true,
            ]
        );

        $this->add_control(
            'progress_bars',
            [
                'show_label'  => false,
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '<# print((name || level.size) ? (name || "Skill") + " - " + level.size + level.unit : "Skill - 0%") #>',
                'default'     => [
                    [
                        'name'  => 'Design',
                        'level' => ['size' => 97, 'unit' => '%'],
                    ],
                    [
                        'name'  => 'UX',
                        'level' => ['size' => 88, 'unit' => '%'],
                    ],
                    [
                        'name'  => 'Coding',
                        'level' => ['size' => 92, 'unit' => '%'],
                    ],
                    [
                        'name' => 'Speed',
                    ],
                    [
                        'name'  => 'Passion',
                        'level' => ['size' => 100, 'unit' => '%'],
                    ],
                ],
            ]
        );

        $this->add_control(
            'animation_speed',
            [
                'label'     => __('Animation Speed (s)', TEXT_DOMAIN),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => .1,
                        'max' => 10,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-fill' => '-webkit-transition: width {{SIZE}}s ease;  -o-transition: width {{SIZE}}s ease; transition: width {{SIZE}}s ease;',
                ],
            ]
        );

        $this->add_control(
            'skills_style',
            [
                'type'           => Controls_Manager::SELECT,
                'label'          => __('Progress Style', TEXT_DOMAIN),
                'separator'      => 'before',
                'default'        => 'default',
                'options'        => [
                    'default'                          => __('Default', TEXT_DOMAIN),
                    'rbt-progress-with-perc'           => __('Percentage With Progress', TEXT_DOMAIN),
                    'rbt-progress-inner-perc'          => __('Inner Content', TEXT_DOMAIN),
                    'rbt-progress-inner-perc-and-name' => __('Inner Content Between', TEXT_DOMAIN),

                ],
                'style_transfer' => true,
            ]
        );

        $this->add_control(
            'text_position',
            [
                'type'           => Controls_Manager::SELECT,
                'label'          => __('Text Position', TEXT_DOMAIN),
                'separator'      => 'before',
                'default'        => 'outside-top',
                'options'        => [
                    'outside-top'    => __('Text Outside Top', TEXT_DOMAIN),
                    'outside-bottom' => __('Text Outside Bottom', TEXT_DOMAIN),
                ],
                'style_transfer' => true,
                'condition'      => [
                    'skills_style' => ['default', 'rbt-progress-with-perc'],
                ],
            ]
        );

        $this->add_control(
            'skills_extra_style',
            [
                'type'           => Controls_Manager::SELECT,
                'label'          => __('Additional Style', TEXT_DOMAIN),
                'separator'      => 'before',
                'default'        => 'null',
                'options'        => [
                    'null'                                            => __('Default', TEXT_DOMAIN),
                    'rbt-progress-fill-striped'                       => __('Striped', TEXT_DOMAIN),
                    'rbt-progress-fill-striped rbt-progress-animated' => __('Striped With Animation', TEXT_DOMAIN),
                    'rbt-progress-rainbow-animate'                    => __('Rainbow Animation', TEXT_DOMAIN),

                ],
                'style_transfer' => true,
            ]
        );

        $this->add_control(
            'rainbow_animation_speed',
            [
                'label'     => __('Rainbow Animation Speed (s)', TEXT_DOMAIN),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 1,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rbt-advanced-progress-bar.rbt-progress-rainbow-animate .rbt-progress-fill' => ' -webkit-animation: animateRainbow {{SIZE}}s ease infinite;
                    animation: animateRainbow {{SIZE}}s ease infinite;',
                ],
                'condition' => [
                    'skills_extra_style' => ['rbt-progress-rainbow-animate'],
                ],
            ]
        );


        $this->add_control(
            'show_perc',
            [
                'label' => esc_html__( 'Show Percentage', TEXT_DOMAIN ),
                'type'  => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        ); 

        $this->add_control(
            'show_max_value',
            [
                'label' => esc_html__( 'Show Max Value', TEXT_DOMAIN ),
                'type'  => Controls_Manager::SWITCHER,
                'default' => 'no',
            ]
        );

        $this->end_controls_section();

    }

    protected function register_controls_style_progress() {
        $this->start_controls_section(
            'section_style_progress_bars',
            [
                'label' => __('Progress Bars', TEXT_DOMAIN),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'height',
            [
                'label'      => __('Height', TEXT_DOMAIN),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 1,
                        'max' => 250,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-level' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'spacing',
            [
                'label'      => __('Spacing Between', TEXT_DOMAIN),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 250,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'border_radius_level',
            [
                'label'      => __('Border Radius Level', TEXT_DOMAIN),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-item  .rbt-progress-level' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label'      => __('Border Radius Fill', TEXT_DOMAIN),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-item .rbt-progress-fill' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_shadow',
                'exclude'  => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-level',
            ]
        );

        $this->end_controls_section();

    }

    protected function register_controls_style_content() {
        $this->start_controls_section(
            'section_content_style',
            [
                'label' => __('Content', TEXT_DOMAIN),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label'     => __('Text Color', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-item .rbt-progress-content' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'progress_base_color',
            [
                'label'     => __('Base Color', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-level' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'show_progress_fill',
            [
                'label'   => __('Fill Color', TEXT_DOMAIN),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes'
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'progress_fill_color',
                'label'     => __('Background', TEXT_DOMAIN),
                'types'     => ['classic', 'gradient'],
                'selector'  => '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-fill',
                'condition' => [
                    'skills_extra_style!' => ['rbt-progress-rainbow-animate'],
                    'show_progress_fill' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'rainbow_first_color',
            [
                'label'       => __('Rainbow Color', TEXT_DOMAIN),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => 'Input your colors. example: red, #9400d3, indigo',
                'default'     => 'red, orange, yellow, blue, indigo, violet',
                'selectors'   => [
                    '{{WRAPPER}} .rbt-advanced-progress-bar.rbt-progress-rainbow-animate .rbt-progress-fill' => 'background: linear-gradient(270deg, {{VALUE}} ); background-size: 300% 300%;',
                ],
                'condition'   => [
                    'skills_extra_style' => ['rbt-progress-rainbow-animate'],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'info_typography',
                'selector' => '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-item .rbt-progress-content',
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name'     => 'info_text_shadow',
                'selector' => '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-item .rbt-progress-content',
            ]
        );

        $this->end_controls_section();

    }

    protected function register_controls_style_percentage() {
        $this->start_controls_section(
            'section_percentage _style',
            [
                'label'     => __('Percentage', TEXT_DOMAIN),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'skills_style' => ['rbt-progress-with-perc'],
                ],
            ]
        );

        $this->add_control(
            'percentage_color',
            [
                'label'     => __('Color', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-item .rbt-progress-parcentage' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'percentage_bg_color',
                'label'    => __('Background', TEXT_DOMAIN),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-item .rbt-progress-parcentage::before',

            ]
        );

        $this->add_control(
            'percentage_size',
            [
                'label'      => __('Size', TEXT_DOMAIN),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 20,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-item .rbt-progress-parcentage'         => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-item .rbt-progress-parcentage::before' => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'percentage_vertical_position',
            [
                'label'      => __('Vertical Position', TEXT_DOMAIN),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => -100,
                        'max' => 150,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-item .rbt-progress-parcentage' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'percentage_horizontal_position',
            [
                'label'      => __('Horizontal Position', TEXT_DOMAIN),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => -100,
                        'max' => 150,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-item .rbt-progress-parcentage' => 'right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'percentage_typography',
                'selector' => '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-item .rbt-progress-parcentage, {{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-item .rbt-progress-parcentage::before',
            ]
        );

        $this->add_control(
            'percentage_border_radius',
            [
                'label'      => __('Border Radius', TEXT_DOMAIN),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-advanced-progress-bar .rbt-progress-item .rbt-progress-parcentage::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    public function render(){
        // $settings = $this->get_active_settings();
        $settings = $this->get_settings_for_display();
        $settings['skills_style'];
        $settings['text_position'];

        $this->add_render_attribute('progress-bar', 'class', 'rbt-advanced-progress-bar ' . $settings['skills_style'] . ' ' . $settings['skills_extra_style'] . '  ');

        ?>
        <div <?php echo $this->get_render_attribute_string('progress-bar'); ?>>
            <?php
            foreach ($settings['progress_bars'] as $progress):
                ?>
                <!-- was here render-bak-code from below -->
                <?php if ($settings['skills_style'] == 'rbt-progress-with-perc') { ?>
                    <div class="rbt-progress-item elementor-repeater-item-<?php echo esc_attr($progress['_id']); ?>">
                        <?php if ($settings['text_position'] == 'outside-top') {?>
                            <div class="rbt-progress-content">
                                <span class="rbt-progress-name">  <?php echo esc_html($progress['name']); ?> </span>
                            </div>
                        <?php }?>
                        <div class="rbt-progress-level">
                            <div class="rbt-progress-fill" max-value= "<?php echo ($progress['max_level']['size'] > 0 ? $progress['max_level']['size'] : '100') ?>" data-width="<?php echo esc_attr($progress['level']['size']) ?>%">
                                <span class="rbt-progress-parcentage">
                                    <?php echo esc_html($progress['level']['size']); ?>
                                    <?php echo esc_html($settings['show_max_value'] == 'yes' ? ' / '.$progress['max_level']['size'] : ''); ?>
                                    <?php ($settings['show_perc'] == 'yes' ? '%' : '') ?> 
                                </span>
                            </div>
                        </div>
                        <?php if ($settings['text_position'] == 'outside-bottom') {?>
                            <div class="rbt-progress-content">
                                <span class="rbt-progress-name">  <?php echo esc_html($progress['name']); ?> </span>
                            </div>
                        <?php }?>
                    </div>
                <?php } elseif ($settings['skills_style'] == 'rbt-progress-inner-perc') {?>
                    <div class="rbt-progress-item elementor-repeater-item-<?php echo esc_attr($progress['_id']); ?>">
                        <div class="rbt-progress-level">
                            <div class="rbt-progress-fill" max-value= "<?php echo ($progress['max_level']['size'] > 0 ? $progress['max_level']['size'] : '100') ?>" data-width="<?php echo esc_attr($progress['level']['size']) ?>%">
                                <div class="rbt-progress-content">
                                    <span class="rbt-progress-name"> <?php echo esc_html($progress['name']); ?> </span>
                                    <span class="rbt-progress-parcentage"><?php echo esc_html($progress['level']['size']); ?>
                                        <?php echo esc_html($settings['show_max_value'] == 'yes' ? ' / '.$progress['max_level']['size'] : ''); ?>
                                        <?php echo ($settings['show_perc'] == 'yes' ? '%' : '') ?> 
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } elseif ($settings['skills_style'] == 'rbt-progress-inner-perc-and-name') {?>
                    <div class="rbt-progress-item elementor-repeater-item-<?php echo esc_attr($progress['_id']); ?>">
                        <div class="rbt-progress-level">
                            <div class="rbt-progress-fill" max-value= "<?php echo ($progress['max_level']['size'] > 0 ? $progress['max_level']['size'] : '100') ?>"  data-width="<?php echo esc_attr($progress['level']['size']) ?>%">
                                <div class="rbt-progress-content">
                                    <span class="rbt-progress-name"><?php echo esc_html($progress['name']); ?> </span>
                                    <span class="rbt-progress-parcentage"><?php echo esc_html($progress['level']['size']); ?>
                                        <?php echo esc_html($settings['show_max_value'] == 'yes' ? ' / '.$progress['max_level']['size'] : ''); ?>
                                        <?php echo ($settings['show_perc'] == 'yes' ? '%' : '') ?> 
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div> 
                <?php } else {?>
                    <div class="rbt-progress-item elementor-repeater-item-<?php echo esc_attr($progress['_id']); ?>">
                        <?php if ($settings['text_position'] == 'outside-top') {?>
                            <div class="rbt-progress-content">
                                <span class="rbt-progress-name">  <?php echo esc_html($progress['name']); ?> </span>
                                <span class="rbt-progress-parcentage"><?php echo esc_html($progress['level']['size']); ?>
                                    <?php echo esc_html($settings['show_max_value'] == 'yes' ? ' / '.$progress['max_level']['size'] : ''); ?>
                                    <?php echo ($settings['show_perc'] == 'yes' ? '%' : '') ?> 
                                </span>
                            </div>
                        <?php }?>
                            <div class="rbt-progress-level">
                                <div class="rbt-progress-fill " 
                                    max-value= "<?php echo ($progress['max_level']['size'] > 0 ? $progress['max_level']['size'] : '100') ?>"  
                                    data-width="<?php echo esc_attr($progress['level']['size']) ?>%">
                                </div>
                            </div>
                        <?php if ($settings['text_position'] == 'outside-bottom') {?>
                            <div class="rbt-progress-content">
                                <span class="rbt-progress-name"><?php echo esc_html($progress['name']); ?> </span>
                                <span class="rbt-progress-parcentage"><?php echo esc_html($progress['level']['size'])  ?> 
                                    <?php echo esc_html($settings['show_max_value'] == 'yes' ? ' / '.$progress['max_level']['size'] : ''); ?>
                                    <?php echo ($settings['show_perc'] == 'yes' ? '%' : '') ?> 
                                </span>
                            </div>
                        <?php }?>
                    </div>
                <?php }?>
            <?php endforeach;?>
        </div>

    <?php
    }
    
}