( function( $, elementor ) {

	'use strict';

	var widgetLogoCarousel = function( $scope, $ ) {

		var $logocarousel = $scope.find( '.rbt-panel-slider' );
				
        if ( ! $logocarousel.length ) {
            return;
        }

		var $sliderContainer = $logocarousel.find('.swiper-container'),
			$settings 		 = $logocarousel.data('settings');

		// Access swiper class
		const Swiper = elementorFrontend.utils.swiper;
		initSwiper();

		async function initSwiper() {

			var swiper = new Swiper($sliderContainer, $settings);

			if ($settings.pauseOnHover) {
				$($sliderContainer).hover(function() {
					(this).swiper.autoplay.stop();
				}, function() {
					(this).swiper.autoplay.start();
				});
			}

	    };

	};

	jQuery(window).on('elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/rbt-logo-carousel.default', widgetLogoCarousel );
	});

}( jQuery, window.elementorFrontend ) );