<?php
namespace RoboTheme\inc\elementor\Modules\Woocommerce\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class RBT_Product_Additional_Information extends Widget_Base {

	public function get_name() {
		return 'rbt-product-additional-information';
	}

	public function get_title() {
		return esc_html__( 'Additional Information', TEXT_DOMAIN );
	}

    public function get_categories() {
		return [ RBT_CAT ];
	}

	public function get_icon() {
		return 'eicon-product-info';
	}

	protected function register_controls() {

		$this->start_controls_section( 
			'section_additional_info_style', [
				'label' => esc_html__( 'General', TEXT_DOMAIN ),
				'tab' => Controls_Manager::TAB_STYLE,
		    ] 
	    );

		$this->add_control(
			'show_heading',
			[
				'label' => esc_html__( 'Heading', TEXT_DOMAIN ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', TEXT_DOMAIN ),
				'label_off' => esc_html__( 'Hide', TEXT_DOMAIN ),
				'render_type' => 'ui',
				'return_value' => 'yes',
				'default' => 'yes',
				'prefix_class' => 'elementor-show-heading-',
			]
		);

		$this->add_control(
			'heading_color',
			[
				'label' => esc_html__( 'Color', TEXT_DOMAIN ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} h2' => 'color: {{VALUE}}',
				],
				'condition' => [
					'show_heading!' => '',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'heading_typography',
				'label' => esc_html__( 'Typography', TEXT_DOMAIN ),
				'selector' => '.woocommerce {{WRAPPER}} h2',
				'condition' => [
					'show_heading!' => '',
				],
			]
		);

		$this->add_control(
			'content_color',
			[
				'label' => esc_html__( 'Color', TEXT_DOMAIN ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .shop_attributes' => 'color: {{VALUE}}',
				],
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => esc_html__( 'Typography', TEXT_DOMAIN ),
				'selector' => '.woocommerce {{WRAPPER}} .shop_attributes',
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		global $product;
		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		}

		wc_get_template( 'single-product/tabs/additional-information.php' );
	}

	public function render_plain_content() {}
}
