<?php

namespace RoboTheme\inc\elementor\Modules\Woocommerce;

use Elementor\Core\Documents_Manager;
use RoboTheme\inc\elementor\RoboTheme_Module_Base;
use RoboTheme\RoboTheme_Loader;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class Module extends RoboTheme_Module_Base {

	const TEMPLATE_MINI_CART = 'cart/mini-cart.php';

	public static function is_active() {
		return class_exists( 'woocommerce' );
	}

	public function get_name() {
		return 'rbt-woocommerce';
	}

	public function get_widgets() {
		$widgets = [
			'RBT_Products',
			'RBT_Product_Images',
			'RBT_Product_Price',
			'RBT_Product_Rating',
			'RBT_Product_Short_Description',
			'RBT_Product_Data_Tabs',
			'RBT_Product_Additional_Information',
			'RBT_Add_To_Cart',
			'RBT_Product_Title',
			'RBT_Elements',
			'RBT_Mini_Cart'
		];

		return $widgets;
	}
	
	public function __construct() {

		parent::__construct();

		add_filter( 'woocommerce_add_to_cart_fragments', [ $this, 'robotheme_mini_cart_fragment' ] );
		add_filter( 'woocommerce_locate_template', [ $this, 'woocommerce_locate_template' ], 12, 3 );

	}

	public function robotheme_mini_cart_fragment( $fragments ) {
		global $woocommerce;

		ob_start();

		?>
        <span class="rbt-mini-cart-inner">
			<span class="rbt-cart-button-text">
				<span class="rbt-mini-cart-price-amount">
					<?php echo WC()->cart->get_cart_subtotal(); ?>
				</span>
			</span>
			<span class="rbt-mini-cart-button-icon">
				<span class="rbt-cart-badge">
					<?php echo WC()->cart->get_cart_contents_count(); ?>
				</span>
				<span class="rbt-cart-icon">
					<i class="eicon" aria-hidden="true"></i>
				</span>
			</span>
		</span>

		<?php
		$fragments['a.rbt-mini-cart-button .rbt-mini-cart-inner'] = ob_get_clean();

		return $fragments;
	}

	public function woocommerce_locate_template( $template, $template_name, $template_path ) {

		if ( self::TEMPLATE_MINI_CART !== $template_name ) {
			return $template;
		}

		$plugin_path = RBT_MODULES . 'woocommerce/wc-templates/';

		if ( file_exists( $plugin_path . $template_name ) ) {
			$template = $plugin_path . $template_name;
		}

		return $template;
	}

	public function add_product_post_class( $classes ) {
		$classes[] = 'product';

		return $classes;
	}

	public function add_products_post_class_filter() {
		add_filter( 'post_class', [ $this, 'add_product_post_class' ] );
	}

	public function remove_products_post_class_filter() {
		remove_filter( 'post_class', [ $this, 'add_product_post_class' ] );
	}

}