<?php

namespace RoboTheme\inc\elementor\Modules\Testimonial\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Utils;
use Elementor\Icons_Manager;
use Elementor\Repeater;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class RBT_Testimonial extends Widget_Base {

	public function get_name() {
		return 'rbt-testimonial';
	}

	public function get_title() {
		return __( 'Testimonial', TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-testimonial-carousel';
	}

	public function get_categories() {
		return [ RBT_CAT ];
	}

	public function get_keywords() {
		return [ 'carousel', 'Testimonial' ];
	}

	public function get_style_depends(){
		return ['rbt-font-icon', 'rbt-testimonial'];
	}

	public function get_script_depends() {
		return [ 'rbt-testimonial' ];
	}

	protected function register_controls(){
		$this->register_controls_layout();
		$this->register_controls_slides();
		$this->register_controls_navigation();
		$this->register_controls_slider();
		$this->register_controls_additional();
		$this->register_general_slides_style_controls();
		$this->register_general_content_style_controls();
		$this->register_general_image_style_controls();
		$this->register_general_style_rating_controls();
		$this->register_controls_style_background();
		$this->register_navigation_style_controls('panel-slider');
	}

	// Content //
	protected function register_controls_layout() {

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__('Layout', TEXT_DOMAIN),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__('Alignment', TEXT_DOMAIN),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left'    => [
						'title' => esc_html__('Left', TEXT_DOMAIN),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', TEXT_DOMAIN),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__('Right', TEXT_DOMAIN),
						'icon' => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__('Justified', TEXT_DOMAIN),
						'icon' => 'eicon-text-align-justify',
					],
				],
				// 'prefix_class' => 'elementor%s-align-',
				'selectors' => [
					'{{WRAPPER}} .rbt-panel-slider' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'columns',
			[
				'label'          => esc_html__('Columns', TEXT_DOMAIN),
				'type'           => Controls_Manager::SELECT,
				'default'        => '3',
				'tablet_default' => '2',
				'mobile_default' => '1',
				'options'        => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
				'frontend_available' => true,
			]
		);

		$this->add_control(
            'image_position',
            [
                'label' => __( 'Image Position', TEXT_DOMAIN ),
                'type' => Controls_Manager::SELECT,
                'default' => 'top-title',
                'options' => [
                    'right-title'  => __( 'Right Title', TEXT_DOMAIN ),
                    'left-title' => __( 'Left Title', TEXT_DOMAIN ),
                    'top-title' => __( 'Top Title', TEXT_DOMAIN ),
                    'bottom-title' => __( 'Bottom Title', TEXT_DOMAIN ),
                    'right-box' => __( 'Right Box', TEXT_DOMAIN ),
                    'left-box' => __( 'Left Box', TEXT_DOMAIN ),
                ],
            ]
        );
        $this->add_control(
            'text_position',
            [
                'label' => __( 'Text Position', TEXT_DOMAIN ),
                'type' => Controls_Manager::SELECT,
                'default' => 'bottom',
                'options' => [
                    'top'  => __( 'Top', TEXT_DOMAIN ),
                    'bottom' => __( 'Bottom', TEXT_DOMAIN ),
                ],
            ]
        );

		$this->add_responsive_control(
			'column_space',
			[
				'label' => esc_html__('Column Space', TEXT_DOMAIN),
				'type'  => Controls_Manager::SLIDER,
			]
		);

		// $this->add_responsive_control(
		// 	'skin_columns',
		// 	[
		// 		'label'          => esc_html__('Columns', TEXT_DOMAIN),
		// 		'type'           => Controls_Manager::SELECT,
		// 		'default'        => '4',
		// 		'tablet_default' => '2',
		// 		'mobile_default' => '2',
		// 		'options'        => [
		// 			'1' => '1',
		// 			'2' => '2',
		// 			'3' => '3',
		// 			'4' => '4',
		// 			'5' => '5',
		// 			'6' => '6',
		// 			'7' => '7',
		// 			'8' => '8',
		// 			'9' => '9',
		// 			'10' => '10',
		// 		],
		// 	]
		// );

	
		// $this->add_responsive_control(
		// 	'slider_height',
		// 	[
		// 		'label'      => esc_html__('Slider Height', TEXT_DOMAIN),
		// 		'type'       => Controls_Manager::SLIDER,
		// 		'size_units' => ['px', 'vh'],
		// 		'range'      => [
		// 			'px' => [
		// 				'min'  => 100,
		// 				'step' => 20,
		// 				'max'  => 1600
		// 			],
		// 			'vh' => [
		// 				'min'  => 1,
		// 				'step' => 1,
		// 				'max'  => 100
		// 			]
		// 		],
		// 		'selectors' => [
		// 			'{{WRAPPER}} .swiper-wrapper' => 'height: {{SIZE}}{{UNIT}};'
		// 		]
		// 	]
		// );

		// $this->add_control(
		// 	'title_tags',
		// 	[
		// 		'label'   => __('Title HTML Tag', TEXT_DOMAIN),
		// 		'type'    => Controls_Manager::SELECT,
		// 		'default' => 'h3',
		// 		'options' => rbt_title_tags(),
		// 		// 'condition' => [
		// 		// 	'show_title' => 'yes'
		// 		// ]
		// 	]
		// );

		$this->end_controls_section();

	}

	protected function register_controls_slides() {

		$this->start_controls_section(
			'section_content_sliders',
			[
				'label' => esc_html__('Sliders', TEXT_DOMAIN),
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
            'text',
            [
                'label' => __( 'Description', TEXT_DOMAIN ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'I am slide content. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', TEXT_DOMAIN ),
                'show_label' => false,
            ]
        );
        $repeater->add_control(
            'photo',
            [
                'label'   => __( 'Choose Photo', TEXT_DOMAIN ),
                'type'    => Controls_Manager::MEDIA,
                'dynamic' => [ 'active' => true ],
                'default' => [
                    'url' => RBT_ASSETS_URL . 'images/member.svg',
                ],
            ]
        );

        $repeater->add_control(
            'name',
            [
                'label' => __( 'Name', TEXT_DOMAIN ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Mousa Zahairi', TEXT_DOMAIN ),
            ]
        );
        $repeater->add_control(
            'title',
            [
                'label' => __( 'Title', TEXT_DOMAIN ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'CEO', TEXT_DOMAIN ),
            ]
        );

		$repeater->add_control(
			'rating',
			[
				'label' => esc_html__( 'Rating', TEXT_DOMAIN ),
				'type' => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 5,
				'step' => 0.1,
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__('Slider Items', TEXT_DOMAIN),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'tab_title'   => esc_html__('Slide #1', TEXT_DOMAIN),
						'tab_content' => esc_html__('I am item content. Click edit button to change this text.', TEXT_DOMAIN),
					],
					[
						'tab_title'   => esc_html__('Slide #2', TEXT_DOMAIN),
						'tab_content' => esc_html__('I am item content. Click edit button to change this text.', TEXT_DOMAIN),
					],
					[
						'tab_title'   => esc_html__('Slide #3', TEXT_DOMAIN),
						'tab_content' => esc_html__('I am item content. Click edit button to change this text.', TEXT_DOMAIN),
					],
					[
						'tab_title'   => esc_html__('Slide #4', TEXT_DOMAIN),
						'tab_content' => esc_html__('I am item content. Click edit button to change this text.', TEXT_DOMAIN),
					],
				],
				'title_field' => '{{{ tab_title }}}',
			]
		);

		
		$this->end_controls_section();
		
	}

	protected function register_controls_navigation() {

		$this->start_controls_section(
			'section_content_navigation',
			[
				'label' => __('Navigation', TEXT_DOMAIN),
			]
		);
		
		$this->add_control(
			'navigation',
			[
				'label'        => __( 'Navigation', TEXT_DOMAIN ),
				'type'         => Controls_Manager::SELECT,
				'default'      => 'arrows',
				'options'      => [
					'both'            => esc_html__( 'Arrows and Dots', TEXT_DOMAIN ),
					'arrows-fraction' => esc_html__( 'Arrows and Fraction', TEXT_DOMAIN ),
					'arrows'          => esc_html__( 'Arrows', TEXT_DOMAIN ),
					'dots'            => esc_html__( 'Dots', TEXT_DOMAIN ),
					'progressbar'     => esc_html__( 'Progress', TEXT_DOMAIN ),
					'none'            => esc_html__( 'None', TEXT_DOMAIN ),
				],
				'prefix_class' => 'rbt-navigation-type-',
				'render_type'  => 'template',
			]
		);
		
		$this->add_control(
			'dynamic_bullets',
			[
				'label'     => __( 'Dynamic Bullets?', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
				'condition' => [
					'navigation' => ['dots', 'both'],
				],
			]
		);
		
		$this->add_control(
			'show_scrollbar',
			[
				'label' => __( 'Show Scrollbar?', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SWITCHER,
			]
		);
		
		$this->add_control(
			'both_position',
			[
				'label'     => __( 'Arrows and Dots Position', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'center',
				'options'   => rbt_navigation_position(),
				'condition' => [
					'navigation' => 'both',
				],
			
			]
		);
		
		$this->add_control(
			'arrows_fraction_position',
			[
				'label'     => __( 'Arrows and Fraction Position', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'center',
				'options'   => rbt_navigation_position(),
				'condition' => [
					'navigation' => 'arrows-fraction',
				],
			
			]
		);
		
		$this->add_control(
			'arrows_position',
			[
				'label'     => __( 'Arrows Position', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'center',
				'options'   => rbt_navigation_position(),
				'condition' => [
					'navigation' => 'arrows',
				],
			
			]
		);
		
		$this->add_control(
			'dots_position',
			[
				'label'     => __( 'Dots Position', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'bottom-center',
				'options'   => rbt_pagination_position(),
				'condition' => [
					'navigation' => 'dots',
				],
			
			]
		);
		
		$this->add_control(
			'progress_position',
			[
				'label'     => __( 'Progress Position', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'bottom',
				'options'   => [
					'bottom' => esc_html__( 'Bottom', TEXT_DOMAIN ),
					'top'    => esc_html__( 'Top', TEXT_DOMAIN ),
				],
				'condition' => [
					'navigation' => 'progressbar',
				],
			
			]
		);
		
		$this->add_control(
			'nav_arrows_icon',
			[
				'label'     => esc_html__( 'Arrows Icon', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SELECT,
				'default'   => '5',
				'options'   => [
					'1'        => esc_html__( 'Style 1', TEXT_DOMAIN ),
					'2'        => esc_html__( 'Style 2', TEXT_DOMAIN ),
					'3'        => esc_html__( 'Style 3', TEXT_DOMAIN ),
					'4'        => esc_html__( 'Style 4', TEXT_DOMAIN ),
					'5'        => esc_html__( 'Style 5', TEXT_DOMAIN ),
					'6'        => esc_html__( 'Style 6', TEXT_DOMAIN ),
					'7'        => esc_html__( 'Style 7', TEXT_DOMAIN ),
					'8'        => esc_html__( 'Style 8', TEXT_DOMAIN ),
					'9'        => esc_html__( 'Style 9', TEXT_DOMAIN ),
					'10'       => esc_html__( 'Style 10', TEXT_DOMAIN ),
					'11'       => esc_html__( 'Style 11', TEXT_DOMAIN ),
					'12'       => esc_html__( 'Style 12', TEXT_DOMAIN ),
					'13'       => esc_html__( 'Style 13', TEXT_DOMAIN ),
					'14'       => esc_html__( 'Style 14', TEXT_DOMAIN ),
					'15'       => esc_html__( 'Style 15', TEXT_DOMAIN ),
					'16'       => esc_html__( 'Style 16', TEXT_DOMAIN ),
					'17'       => esc_html__( 'Style 17', TEXT_DOMAIN ),
					'18'       => esc_html__( 'Style 18', TEXT_DOMAIN ),
					'circle-1' => esc_html__( 'Style 19', TEXT_DOMAIN ),
					'circle-2' => esc_html__( 'Style 20', TEXT_DOMAIN ),
					'circle-3' => esc_html__( 'Style 21', TEXT_DOMAIN ),
					'circle-4' => esc_html__( 'Style 22', TEXT_DOMAIN ),
					'square-1' => esc_html__( 'Style 23', TEXT_DOMAIN ),
				],
				'condition' => [
					'navigation' => ['arrows-fraction', 'both', 'arrows'],
				],
			]
		);
		
		$this->add_control(
			'hide_arrow_on_mobile',
			[
				'label'     => __( 'Hide Arrow on Mobile', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'condition' => [
					'navigation' => ['arrows-fraction', 'arrows', 'both'],
				],
			]
		);

		$this->end_controls_section();
		
	}
	
	protected function register_controls_slider() {
		$this->start_controls_section(
			'section_carousel_settings',
			[
				'label' => __( 'Carousel Settings', TEXT_DOMAIN ),
			]
		);
		
		$this->add_control(
			'skin',
			[
				'label'        => esc_html__( 'Layout', TEXT_DOMAIN ),
				'type'         => Controls_Manager::SELECT,
				'default'      => 'carousel',
				'options'      => [
					'carousel'  => esc_html__( 'Carousel', TEXT_DOMAIN ),
					'coverflow' => esc_html__( 'Coverflow', TEXT_DOMAIN ),
				],
				'prefix_class' => 'rbt-carousel-style-',
				'render_type'  => 'template',
			]
		);
		
		$this->add_control(
			'coverflow_toggle',
			[
				'label'        => __( 'Coverflow Effect', TEXT_DOMAIN ),
				'type'         => Controls_Manager::POPOVER_TOGGLE,
				'return_value' => 'yes',
				'condition'    => [
					'skin' => 'coverflow'
				]
			]
		);
		
		$this->start_popover();
		
		$this->add_control(
			'coverflow_rotate',
			[
				'label'       => esc_html__( 'Rotate', TEXT_DOMAIN ),
				'type'        => Controls_Manager::SLIDER,
				'default'     => [
					'size' => 50,
				],
				'range'       => [
					'px' => [
						'min'  => -360,
						'max'  => 360,
						'step' => 5,
					],
				],
				'condition'   => [
					'coverflow_toggle' => 'yes'
				],
				'render_type' => 'template',
			]
		);
		
		$this->add_control(
			'coverflow_stretch',
			[
				'label'       => __( 'Stretch', TEXT_DOMAIN ),
				'type'        => Controls_Manager::SLIDER,
				'default'     => [
					'size' => 0,
				],
				'range'       => [
					'px' => [
						'min'  => 0,
						'step' => 10,
						'max'  => 100,
					],
				],
				'condition'   => [
					'coverflow_toggle' => 'yes'
				],
				'render_type' => 'template',
			]
		);
		
		$this->add_control(
			'coverflow_modifier',
			[
				'label'       => __( 'Modifier', TEXT_DOMAIN ),
				'type'        => Controls_Manager::SLIDER,
				'default'     => [
					'size' => 1,
				],
				'range'       => [
					'px' => [
						'min'  => 1,
						'step' => 1,
						'max'  => 10,
					],
				],
				'condition'   => [
					'coverflow_toggle' => 'yes'
				],
				'render_type' => 'template',
			]
		);
		
		$this->add_control(
			'coverflow_depth',
			[
				'label'       => __( 'Depth', TEXT_DOMAIN ),
				'type'        => Controls_Manager::SLIDER,
				'default'     => [
					'size' => 100,
				],
				'range'       => [
					'px' => [
						'min'  => 0,
						'step' => 10,
						'max'  => 1000,
					],
				],
				'condition'   => [
					'coverflow_toggle' => 'yes'
				],
				'render_type' => 'template',
			]
		);
		
		$this->end_popover();

		$this->add_control(
			'hr_005',
			[
				'type'      => Controls_Manager::DIVIDER,
				'condition' => [
					'skin' => 'coverflow'
				]
			]
		);
		






























		$this->add_control(
			'autoplay',
			[
				'label'   => __( 'Autoplay', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		
		$this->add_control(
			'autoplay_speed',
			[
				'label'     => esc_html__( 'Autoplay Speed', TEXT_DOMAIN ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 5000,
				'condition' => [
					'autoplay' => 'yes',
				],
			]
		);
		
		$this->add_control(
			'pauseonhover',
			[
				'label' => esc_html__( 'Pause on Hover', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SWITCHER,
			]
		);
		
		$this->add_responsive_control(
			'slides_to_scroll',
			[
				'type'           => Controls_Manager::SELECT,
				'label'          => esc_html__( 'Slides to Scroll', TEXT_DOMAIN ),
				'default'        => 1,
				'tablet_default' => 1,
				'mobile_default' => 1,
				'options'        => [
					1 => '1',
					2 => '2',
					3 => '3',
					4 => '4',
					5 => '5',
					6 => '6',
				],
			]
		);
		
		$this->add_control(
			'centered_slides',
			[
				'label'       => __( 'Center Slide', TEXT_DOMAIN ),
				'description' => __( 'Use even items from Layout > Columns settings for better preview.', TEXT_DOMAIN ),
				'type'        => Controls_Manager::SWITCHER,
			]
		);
		
		$this->add_control(
			'grab_cursor',
			[
				'label' => __( 'Grab Cursor', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SWITCHER,
			]
		);
		
		$this->add_control(
			'free_mode',
			[
				'label' => __( 'Drag Free Mode', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SWITCHER,
			]
		);
		
		$this->add_control(
			'loop',
			[
				'label'   => __( 'Loop', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			
			]
		);
		
		$this->add_control(
			'speed',
			[
				'label'   => __( 'Animation Speed (ms)', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 500,
				],
				'range' => [
					'px' => [
						'min'  => 100,
						'max'  => 5000,
						'step' => 50,
					],
				],
			]
		);
		
		$this->add_control(
			'observer',
			[
				'label'       => __( 'Observer', TEXT_DOMAIN ),
				'description' => __( 'When you use carousel in any hidden place (in tabs, accordion etc) keep it yes.', TEXT_DOMAIN ),
				'type'        => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'show_hidden_item',
			[
				'label' => __( 'Show Hidden Item', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SWITCHER,
				'prefix_class' => 'rbt-show-hidden-item--',
				'render_type' => 'template'
			]
		);

		$this->add_control(
			'hidden_item_opacity',
			[
				'label' => __( 'Hidden Item Opacity', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0.1,
						'max' => 1,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-slide:not(.swiper-slide-visible)' => 'opacity: {{SIZE}};',
				],
				'condition' => [
					'show_hidden_item' => 'yes',
				],
			]
		);
		
		$this->end_controls_section();
	}

	protected function register_controls_additional(){

		$this->start_controls_section(
			'section_additional',
			[
				'label' => __( 'Additional', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'bg_position',
			[
				'label'   => __( 'Show Background Position', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'prefix_class' => 'rbt-bg-position-'
			]
		);

		$this->end_controls_section();

	}

    // Style //
	protected function register_general_slides_style_controls() {
        $this->start_controls_section(
            'section_slides_style',
            [
                'label' => __( 'Slide', TEXT_DOMAIN ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'slide_width',
            [
                'label' => __( 'Width', TEXT_DOMAIN ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1200,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'slide_margin',
            [
                'label' => __( 'Margin', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_control(
            'slide_padding',
            [
                'label' => __( 'Padding', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'slide_radius',
            [
                'label' => __( 'Radius', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'slide_bg_color',
            [
                'label' => __( 'Background Color', TEXT_DOMAIN ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'slide_box_shadow',
                'label' => __( 'Box Shadow', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} .testimonial-slide',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'slide_border',
                'label' => __( 'Border', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} .testimonial-slide',
            ]
        );

        $this->end_controls_section();
    }

	protected function register_general_content_style_controls() {
        $this->start_controls_section(
            'section_style_content',
            [
                'label' => __( 'Content', TEXT_DOMAIN ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'text_heading',
            [
                'label' => __( 'Text', TEXT_DOMAIN ),
                'type' => Controls_Manager::HEADING,
            ]
        );
        $this->add_control(
            'text_margin',
            [
                'label' => __( 'Margin', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 10,
                    'right' => 10,
                    'bottom' => 10,
                    'left' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_control(
            'text_padding',
            [
                'label' => __( 'Padding', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => __( 'Color', TEXT_DOMAIN ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .content p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'text_typography',
                'label' => __( 'Typography', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} .content p',
            ]
        );
        $this->add_control(
            'text_align',
            [
                'label' => __( 'Alignment', TEXT_DOMAIN ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', TEXT_DOMAIN ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', TEXT_DOMAIN ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', TEXT_DOMAIN ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .content p' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'name_heading',
            [
                'label' => __( 'Name', TEXT_DOMAIN ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'name_color',
            [
                'label' => __( 'Color', TEXT_DOMAIN ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .name' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'name_margin',
            [
                'label' => __( 'Margin', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 5,
                    'right' => 5,
                    'bottom' => 5,
                    'left' => 5,
                ],
                'selectors' => [
                    '{{WRAPPER}} .name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'label' => __( 'Typography', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} .name',
            ]
        );
        $this->add_control(
            'name_align',
            [
                'label' => __( 'Alignment', TEXT_DOMAIN ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', TEXT_DOMAIN ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', TEXT_DOMAIN ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', TEXT_DOMAIN ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .name' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_heading',
            [
                'label' => __( 'Name', TEXT_DOMAIN ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', TEXT_DOMAIN ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_align',
            [
                'label' => __( 'Alignment', TEXT_DOMAIN ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', TEXT_DOMAIN ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', TEXT_DOMAIN ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', TEXT_DOMAIN ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .title' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __( 'Typography', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} .title',
            ]
        );

        $this->end_controls_section();
    }

	protected function register_general_image_style_controls() {
        $this->start_controls_section(
            'section_image_content',
            [
                'label' => __( 'Image', TEXT_DOMAIN ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'image_alignment',
            [
                'label'   => __( 'Image Alignment', TEXT_DOMAIN ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'right'   => [
                        'title' => __( 'Top', TEXT_DOMAIN ),
                        'icon'  => 'eicon-v-align-top',
                    ],
                    'center' => [
                        'title' => __( 'Center', TEXT_DOMAIN ),
                        'icon'  => 'eicon-v-align-middle',
                    ],
                    'left' => [
                        'title' => __( 'Bottom', TEXT_DOMAIN ),
                        'icon'  => 'eicon-v-align-bottom',
                    ],
                ],
                'default'      => 'center',
                'toggle'       => false,
                'condition'    => [
                    'image_position' => ['right-box', 'left-box']
                ],
            ]
        );
        $this->add_control(
            'image_h_alignment',
            [
                'label' => __( 'Alignment', TEXT_DOMAIN ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', TEXT_DOMAIN ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', TEXT_DOMAIN ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', TEXT_DOMAIN ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .content p' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'image_width',
            [
                'label' => __( 'Width', TEXT_DOMAIN ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 70,
                ],
                'selectors' => [
                    '{{WRAPPER}} img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
		$this->add_control(
            'image_height',
            [
                'label' => __( 'Height', TEXT_DOMAIN ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'image_margin',
            [
                'label' => __( 'Margin', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_control(
            'image_padding',
            [
                'label' => __( 'Padding', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'image_radius',
            [
                'label' => __( 'Radius', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 100,
                    'right' => 100,
                    'bottom' => 100,
                    'left' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

	protected function register_general_style_rating_controls() {

		$this->start_controls_section(
			'section_rating_style',
			[
				'label' => esc_html__( 'Rating', TEXT_DOMAIN ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
	
		// $this->add_control(
		// 	'star_style',
		// 	[
		// 		'label' => esc_html__( 'Icon', TEXT_DOMAIN ),
		// 		'type' => Controls_Manager::SELECT,
		// 		'star_unicode' => 'Unicode',
		// 		//'render_type' => 'template',
		// 		'prefix_class' => 'elementor--star-style-',
		// 		//'separator' => 'before',
		// 	]
		// );
	
		$this->add_control(
			'star_size',
			[
				'label' => esc_html__( 'Size', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .elementor-star-rating' => 'font-size: {{SIZE}}{{UNIT}}',
				],
				'separator' => 'before',
			]
		);
	
		$this->add_control(
			'star_space',
			[
				'label' => esc_html__( 'Spacing', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'body:not(.rtl) {{WRAPPER}} .elementor-star-rating i:not(:last-of-type)' => 'margin-right: {{SIZE}}{{UNIT}}',
					'body.rtl {{WRAPPER}} .elementor-star-rating i:not(:last-of-type)' => 'margin-left: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_control(
			'star_space_top',
			[
				'label' => esc_html__( 'Spacing Top', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .elementor-star-rating' => 'margin-top: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_control(
			'star_space_bottom',
			[
				'label' => esc_html__( 'Spacing Bottom', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .elementor-star-rating' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);
	
		$this->add_control(
			'stars_color',
			[
				'label' => esc_html__( 'Color', TEXT_DOMAIN ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elementor-star-rating i:before' => 'color: {{VALUE}}',
				],
				'separator' => 'before',
			]
		);
	
		$this->add_control(
			'stars_unmarked_color',
			[
				'label' => esc_html__( 'Unmarked Color', TEXT_DOMAIN ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elementor-star-rating i' => 'color: {{VALUE}}',
				],
			]
		);
	
		$this->end_controls_section();
	

	}

	protected function register_controls_style_background() {
        $this->start_controls_section(
            'section_background_style',
            [
                'label' => __( 'Background', TEXT_DOMAIN ),
                'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'bg_position' => 'yes'
				]
            ]
        );

		$this->add_control(
            'bg_background',
            [
                'label' => __( 'Background Color', TEXT_DOMAIN ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide:after' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'position_bg_top',
            [
                'label' => __( 'Position Top', TEXT_DOMAIN ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide:after' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

		$this->add_responsive_control(
            'position_bg_right',
            [
                'label' => __( 'Position Right', TEXT_DOMAIN ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide:after' => 'right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

		$this->add_responsive_control(
            'width_bg',
            [
                'label' => __( 'Width', TEXT_DOMAIN ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide:after' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

		$this->add_responsive_control(
            'height_bg',
            [
                'label' => __( 'Height', TEXT_DOMAIN ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide:after' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bg_border_radius',
            [
                'label' => __( 'Border Radius', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slide:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'bg_box_shadow',
                'label' => __( 'Box Shadow', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} .testimonial-slide:after',
            ]
        );

        $this->end_controls_section();
    }

	protected function register_navigation_style_controls($name) {

		//Navigation Style
		$this->start_controls_section(
			'section_style_navigation',
			[
				'label'      => __('Navigation', TEXT_DOMAIN),
				'tab'        => Controls_Manager::TAB_STYLE,
				'conditions' => [
					'relation' => 'or',
					'terms'    => [
						[
							'name'     => 'navigation',
							'operator' => '!=',
							'value'    => 'none',
						],
						[
							'name'  => 'show_scrollbar',
							'value' => 'yes',
						],
					],
				],
			]
		);
		
		$this->add_control(
			'arrows_heading',
			[
				'label'     => __( 'A R R O W S', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->start_controls_tabs( 'tabs_navigation_arrows_style' );
		
		$this->start_controls_tab(
			'tabs_nav_arrows_normal',
			[
				'label'     => __( 'Normal', TEXT_DOMAIN ),
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_control(
			'arrows_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev i, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next i' => 'color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_control(
			'arrows_background',
			[
				'label'     => __( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'nav_arrows_border',
				'selector'  => '{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next',
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_responsive_control(
			'border_radius',
			[
				'label'      => __( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_responsive_control(
			'arrows_padding',
			[
				'label'      => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_responsive_control(
			'arrows_size',
			[
				'label'     => __( 'Size', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev i,
		{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next i' => 'font-size: {{SIZE || 24}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_responsive_control(
			'arrows_space',
			[
				'label'     => __( 'Space Between Arrows', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev' => 'margin-right: {{SIZE}}px;',
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next' => 'margin-left: {{SIZE}}px;',
				],
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'arrows_box_shadow',
				'selector' => '{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next',
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->end_controls_tab();
		
		$this->start_controls_tab(
			'tabs_nav_arrows_hover',
			[
				'label'     => __( 'Hover', TEXT_DOMAIN ),
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_control(
			'arrows_hover_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev:hover i, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next:hover i' => 'color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_control(
			'arrows_hover_background',
			[
				'label'     => __( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev:hover, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next:hover' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_control(
			'nav_arrows_hover_border_color',
			[
				'label'     => __( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev:hover, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next:hover' => 'border-color: {{VALUE}};',
				],
				'condition' => [
					'nav_arrows_border_border!' => '',
					'navigation!'               => ['dots', 'progressbar', 'none'],
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'arrows_hover_box_shadow',
				'selector' => '{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev:hover, {{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next:hover',
				'condition' => [
					'navigation!' => ['dots', 'progressbar', 'none'],
				],
			]
		);
		
		$this->end_controls_tab();
		
		$this->end_controls_tabs();
		
		$this->add_control(
			'hr_1',
			[
				'type'      => Controls_Manager::DIVIDER,
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_control(
			'dots_heading',
			[
				'label'     => __( 'D O T S', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);

		$this->start_controls_tabs( 'tabs_navigation_dots_style' );
		
		$this->start_controls_tab(
			'tabs_nav_dots_normal',
			[
				'label'     => __( 'Normal', TEXT_DOMAIN ),
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_control(
			'dots_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);

		$this->add_responsive_control(
			'dots_space_between',
			[
				'label'     => __( 'Space Between', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}}' => '--ep-swiper-dots-space-between: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_responsive_control(
			'dots_size',
			[
				'label'     => __( 'Size', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 5,
						'max' => 20,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet' => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
					'advanced_dots_size' => ''
				],
			]
		);
		
		$this->add_control(
			'advanced_dots_size',
			[
				'label'     => __( 'Advanced Size', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);
		
		$this->add_responsive_control(
			'advanced_dots_width',
			[
				'label'     => __( 'Width(px)', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 1,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
					'advanced_dots_size' => 'yes'
				],
			]
		);
		
		$this->add_responsive_control(
			'advanced_dots_height',
			[
				'label'     => __( 'Height(px)', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 1,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
					'advanced_dots_size' => 'yes'
				],
			]
		);

		$this->add_responsive_control(
			'advanced_dots_radius',
			[
				'label'      => esc_html__('Border Radius', TEXT_DOMAIN),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
					'advanced_dots_size' => 'yes'
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'dots_box_shadow',
				'selector' => '{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet',
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tabs_nav_dots_active',
			[
				'label'     => __( 'Active', TEXT_DOMAIN ),
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);

		$this->add_control(
			'active_dot_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet-active' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);

		$this->add_responsive_control(
			'active_dots_size',
			[
				'label'     => __( 'Size', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 5,
						'max' => 20,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet-active' => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}}' => '--ep-swiper-dots-active-height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
					'advanced_dots_size' => ''
				],
			]
		);
		
		$this->add_responsive_control(
			'active_advanced_dots_width',
			[
				'label'     => __( 'Width(px)', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 1,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet-active' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
					'advanced_dots_size' => 'yes'
				],
			]
		);
		
		$this->add_responsive_control(
			'active_advanced_dots_height',
			[
				'label'     => __( 'Height(px)', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 1,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet-active' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}}' => '--ep-swiper-dots-active-height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
					'advanced_dots_size' => 'yes'
				],
			]
		);

		$this->add_responsive_control(
			'active_advanced_dots_radius',
			[
				'label'      => esc_html__('Border Radius', TEXT_DOMAIN),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet-active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
					'advanced_dots_size' => 'yes'
				],
			]
		);

		$this->add_responsive_control(
			'active_advanced_dots_align',
			[
				'label'   => __( 'Alignment', TEXT_DOMAIN ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'flex-start' => [
						'title' => __( 'Top', TEXT_DOMAIN ),
						'icon'  => 'eicon-v-align-top',
					],
					'center' => [
						'title' => __( 'Center', TEXT_DOMAIN ),
						'icon'  => 'eicon-v-align-middle',
					],
					'flex-end' => [
						'title' => __( 'Bottom', TEXT_DOMAIN ),
						'icon'  => 'eicon-v-align-bottom',
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => '--ep-swiper-dots-align: {{VALUE}};',
				],
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
					'advanced_dots_size' => 'yes'
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'dots_active_box_shadow',
				'selector' => '{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-bullet-active',
				'condition' => [
					'navigation!' => ['arrows', 'arrows-fraction', 'progressbar', 'none'],
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();
		
		$this->add_control(
			'hr_2',
			[
				'type'      => Controls_Manager::DIVIDER,
				'condition' => [
					'navigation' => 'arrows-fraction',
				],
			]
		);
		
		$this->add_control(
			'fraction_heading',
			[
				'label'     => __( 'F R A C T I O N', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
				'condition' => [
					'navigation' => 'arrows-fraction',
				],
			]
		);
		
		$this->add_control(
			'hr_12',
			[
				'type'      => Controls_Manager::DIVIDER,
				'condition' => [
					'navigation' => 'arrows-fraction',
				],
			]
		);
		
		$this->add_control(
			'fraction_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-fraction' => 'color: {{VALUE}}',
				],
				'condition' => [
					'navigation' => 'arrows-fraction',
				],
			]
		);
		
		$this->add_control(
			'active_fraction_color',
			[
				'label'     => __( 'Active Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-current' => 'color: {{VALUE}}',
				],
				'condition' => [
					'navigation' => 'arrows-fraction',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'fraction_typography',
				'label'     => esc_html__( 'Typography', TEXT_DOMAIN ),
				//'scheme'    => Schemes\Typography::TYPOGRAPHY_4,
				'selector'  => '{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-fraction',
				'condition' => [
					'navigation' => 'arrows-fraction',
				],
			]
		);
		
		$this->add_control(
			'hr_3',
			[
				'type'      => Controls_Manager::DIVIDER,
				'condition' => [
					'navigation' => 'progressbar',
				],
			]
		);
		
		$this->add_control(
			'progresbar_heading',
			[
				'label'     => __( 'P R O G R E S B A R', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
				'condition' => [
					'navigation' => 'progressbar',
				],
			]
		);
		
		$this->add_control(
			'hr_13',
			[
				'type'      => Controls_Manager::DIVIDER,
				'condition' => [
					'navigation' => 'progressbar',
				],
			]
		);
		
		$this->add_control(
			'progresbar_color',
			[
				'label'     => __( 'Bar Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-progressbar' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'navigation' => 'progressbar',
				],
			]
		);
		
		$this->add_control(
			'progres_color',
			[
				'label'     => __( 'Progress Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'separator' => 'after',
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-progressbar .swiper-pagination-progressbar-fill' => 'background: {{VALUE}}',
				],
				'condition' => [
					'navigation' => 'progressbar',
				],
			]
		);
		
		$this->add_control(
			'hr_4',
			[
				'type'      => Controls_Manager::DIVIDER,
				'condition' => [
					'show_scrollbar' => 'yes'
				],
			]
		);
		
		$this->add_control(
			'scrollbar_heading',
			[
				'label'     => __( 'S C R O L L B A R', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
				'condition' => [
					'show_scrollbar' => 'yes'
				],
			]
		);
		
		$this->add_control(
			'hr_14',
			[
				'type'      => Controls_Manager::DIVIDER,
				'condition' => [
					'show_scrollbar' => 'yes'
				],
			]
		);
		
		$this->add_control(
			'scrollbar_color',
			[
				'label'     => __( 'Bar Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-scrollbar' => 'background: {{VALUE}}',
				],
				'condition' => [
					'show_scrollbar' => 'yes'
				],
			]
		);
		
		$this->add_control(
			'scrollbar_drag_color',
			[
				'label'     => __( 'Drag Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-scrollbar .swiper-scrollbar-drag' => 'background: {{VALUE}}',
				],
				'condition' => [
					'show_scrollbar' => 'yes'
				],
			]
		);
		
		$this->add_control(
			'scrollbar_height',
			[
				'label'     => __( 'Height', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 1,
						'max' => 10,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-container-horizontal > .swiper-scrollbar' => 'height: {{SIZE}}px;',
				],
				'condition' => [
					'show_scrollbar' => 'yes'
				],
			]
		);
		
		$this->add_control(
			'hr_05',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_control(
			'navi_offset_heading',
			[
				'label' => __( 'O F F S E T', TEXT_DOMAIN ),
				'type'  => Controls_Manager::HEADING,
			]
		);
		
		$this->add_control(
			'hr_6',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		
		$this->add_responsive_control(
			'arrows_ncx_position',
			[
				'label'          => __( 'Arrows Horizontal Offset', TEXT_DOMAIN ),
				'type'           => Controls_Manager::SLIDER,
				'default'        => [
					'size' => 0,
				],
				'tablet_default' => [
					'size' => 0,
				],
				'mobile_default' => [
					'size' => 0,
				],
				'range'          => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'conditions'     => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows',
						],
						[
							'name'     => 'arrows_position',
							'operator' => '!=',
							'value'    => 'center',
						],
					],
				],
				'selectors'      => [
					'{{WRAPPER}}' => '--ep-'. $name .'-arrows-ncx: {{SIZE}}px;'
				],
			]
		);
		
		$this->add_responsive_control(
			'arrows_ncy_position',
			[
				'label'          => __( 'Arrows Vertical Offset', TEXT_DOMAIN ),
				'type'           => Controls_Manager::SLIDER,
				'default'        => [
					'size' => 40,
				],
				'tablet_default' => [
					'size' => 40,
				],
				'mobile_default' => [
					'size' => 40,
				],
				'range'          => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors'      => [
					'{{WRAPPER}}' => '--ep-'. $name .'-arrows-ncy: {{SIZE}}px;'
				],
				'conditions'     => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows',
						],
						[
							'name'     => 'arrows_position',
							'operator' => '!=',
							'value'    => 'center',
						],
					],
				],
			]
		);
		
		$this->add_responsive_control(
			'arrows_acx_position',
			[
				'label'      => __( 'Arrows Horizontal Offset', TEXT_DOMAIN ),
				'type'       => Controls_Manager::SLIDER,
				'default'    => [
					'size' => -60,
				],
				'range'      => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev' => 'left: {{SIZE}}px;',
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next' => 'right: {{SIZE}}px;',
				],
				'conditions' => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows',
						],
						[
							'name'  => 'arrows_position',
							'value' => 'center',
						],
					],
				],
			]
		);

		$this->add_responsive_control(
			'arrows_vertical_position',
			[
				'label'      => __( 'Arrows Vertical Offset', TEXT_DOMAIN ),
				'type'       => Controls_Manager::SLIDER,
				'default'    => [
					'size' => -60,
				],
				'range'      => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev,{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next' => 'top: {{SIZE}}px;',
				],
				'conditions' => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows',
						],
						[
							'name'  => 'arrows_position',
							'value' => 'center',
						],
					],
				],
			]
		);
		
		$this->add_responsive_control(
			'dots_nnx_position',
			[
				'label'          => __( 'Dots Horizontal Offset', TEXT_DOMAIN ),
				'type'           => Controls_Manager::SLIDER,
				'default'        => [
					'size' => 0,
				],
				'tablet_default' => [
					'size' => 0,
				],
				'mobile_default' => [
					'size' => 0,
				],
				'range'          => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'conditions'     => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'dots',
						],
						[
							'name'     => 'dots_position',
							'operator' => '!=',
							'value'    => '',
						],
					],
				],
				'selectors'      => [
					'{{WRAPPER}}' => '--ep-'. $name .'-dots-nnx: {{SIZE}}px;'
				],
			]
		);
		
		$this->add_responsive_control(
			'dots_nny_position',
			[
				'label'          => __( 'Dots Vertical Offset', TEXT_DOMAIN ),
				'type'           => Controls_Manager::SLIDER,
				'default'        => [
					'size' => 30,
				],
				'tablet_default' => [
					'size' => 30,
				],
				'mobile_default' => [
					'size' => 30,
				],
				'range'          => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'conditions'     => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'dots',
						],
						[
							'name'     => 'dots_position',
							'operator' => '!=',
							'value'    => '',
						],
					],
				],
				'selectors'      => [
					'{{WRAPPER}}' => '--ep-'. $name .'-dots-nny: {{SIZE}}px;'
				],
			]
		);
		
		$this->add_responsive_control(
			'both_ncx_position',
			[
				'label'          => __( 'Arrows & Dots Horizontal Offset', TEXT_DOMAIN ),
				'type'           => Controls_Manager::SLIDER,
				'default'        => [
					'size' => 0,
				],
				'tablet_default' => [
					'size' => 0,
				],
				'mobile_default' => [
					'size' => 0,
				],
				'range'          => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'conditions'     => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'both',
						],
						[
							'name'     => 'both_position',
							'operator' => '!=',
							'value'    => 'center',
						],
					],
				],
				'selectors'      => [
					'{{WRAPPER}}' => '--ep-'. $name .'-both-ncx: {{SIZE}}px;'
				],
			]
		);
		
		$this->add_responsive_control(
			'both_ncy_position',
			[
				'label'          => __( 'Arrows & Dots Vertical Offset', TEXT_DOMAIN ),
				'type'           => Controls_Manager::SLIDER,
				'default'        => [
					'size' => 40,
				],
				'tablet_default' => [
					'size' => 40,
				],
				'mobile_default' => [
					'size' => 40,
				],
				'range'          => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'conditions'     => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'both',
						],
						[
							'name'     => 'both_position',
							'operator' => '!=',
							'value'    => 'center',
						],
					],
				],
				'selectors'      => [
					'{{WRAPPER}}' => '--ep-'. $name .'-both-ncy: {{SIZE}}px;'
				],
			]
		);
		
		$this->add_responsive_control(
			'both_cx_position',
			[
				'label'      => __( 'Arrows Offset', TEXT_DOMAIN ),
				'type'       => Controls_Manager::SLIDER,
				'default'    => [
					'size' => -60,
				],
				'range'      => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev' => 'left: {{SIZE}}px;',
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next' => 'right: {{SIZE}}px;',
				],
				'conditions' => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'both',
						],
						[
							'name'  => 'both_position',
							'value' => 'center',
						],
					],
				],
			]
		);
		
		$this->add_responsive_control(
			'both_cy_position',
			[
				'label'      => __( 'Dots Offset', TEXT_DOMAIN ),
				'type'       => Controls_Manager::SLIDER,
				'default'    => [
					'size' => 30,
				],
				'range'      => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-dots-container' => 'transform: translateY({{SIZE}}px);',
				],
				'conditions' => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'both',
						],
						[
							'name'  => 'both_position',
							'value' => 'center',
						],
					],
				],
			]
		);
		
		$this->add_responsive_control(
			'arrows_fraction_ncx_position',
			[
				'label'          => __( 'Arrows & Fraction Horizontal Offset', TEXT_DOMAIN ),
				'type'           => Controls_Manager::SLIDER,
				'default'        => [
					'size' => 0,
				],
				'tablet_default' => [
					'size' => 0,
				],
				'mobile_default' => [
					'size' => 0,
				],
				'range'          => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'conditions'     => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows-fraction',
						],
						[
							'name'     => 'arrows_fraction_position',
							'operator' => '!=',
							'value'    => 'center',
						],
					],
				],
				'selectors'      => [
					'{{WRAPPER}}' => '--ep-'. $name .'-arrows-fraction-ncx: {{SIZE}}px;'
				],
			]
		);
		
		$this->add_responsive_control(
			'arrows_fraction_ncy_position',
			[
				'label'          => __( 'Arrows & Fraction Vertical Offset', TEXT_DOMAIN ),
				'type'           => Controls_Manager::SLIDER,
				'default'        => [
					'size' => 40,
				],
				'tablet_default' => [
					'size' => 40,
				],
				'mobile_default' => [
					'size' => 40,
				],
				'range'          => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'conditions'     => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows-fraction',
						],
						[
							'name'     => 'arrows_fraction_position',
							'operator' => '!=',
							'value'    => 'center',
						],
					],
				],
				'selectors'      => [
					'{{WRAPPER}}' => '--ep-'. $name .'-arrows-fraction-ncy: {{SIZE}}px;'
				],
			]
		);
		
		$this->add_responsive_control(
			'arrows_fraction_cx_position',
			[
				'label'      => __( 'Arrows Offset', TEXT_DOMAIN ),
				'type'       => Controls_Manager::SLIDER,
				'default'    => [
					'size' => -60,
				],
				'range'      => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-prev' => 'left: {{SIZE}}px;',
					'{{WRAPPER}} .rbt-'. $name .' .rbt-navigation-next' => 'right: {{SIZE}}px;',
				],
				'conditions' => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows-fraction',
						],
						[
							'name'  => 'arrows_fraction_position',
							'value' => 'center',
						],
					],
				],
			]
		);
		
		$this->add_responsive_control(
			'arrows_fraction_cy_position',
			[
				'label'      => __( 'Fraction Offset', TEXT_DOMAIN ),
				'type'       => Controls_Manager::SLIDER,
				'default'    => [
					'size' => 30,
				],
				'range'      => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-fraction' => 'transform: translateY({{SIZE}}px);',
				],
				'conditions' => [
					'terms' => [
						[
							'name'  => 'navigation',
							'value' => 'arrows-fraction',
						],
						[
							'name'  => 'arrows_fraction_position',
							'value' => 'center',
						],
					],
				],
			]
		);
		
		$this->add_responsive_control(
			'progress_y_position',
			[
				'label'     => __( 'Progress Offset', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'default'   => [
					'size' => 15,
				],
				'range'     => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-pagination-progressbar' => 'transform: translateY({{SIZE}}px);',
				],
				'condition' => [
					'navigation' => 'progressbar',
				],
			]
		);
		
		$this->add_responsive_control(
			'scrollbar_vertical_offset',
			[
				'label'     => __( 'Scrollbar Offset', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .rbt-'. $name .' .swiper-container-horizontal > .swiper-scrollbar' => 'bottom: {{SIZE}}px;',
				],
				'condition' => [
					'show_scrollbar' => 'yes'
				],
			]
		);

		$this->update_responsive_control(
			'arrows_acx_position',
			[
				'default'        => [
					'size' => 20,
				],
				'tablet_default' => [
					'size' => 20,
				],
				'mobile_default' => [
					'size' => 20,
				],
			]
		);

		$this->end_controls_section();
		
	}

	// render //
	protected function render_header(){
		$settings        = $this->get_settings_for_display();
		$id              = 'rbt-panel-slider-' . $this->get_id();
	
		$elementor_vp_lg = get_option('elementor_viewport_lg');
		$elementor_vp_md = get_option('elementor_viewport_md');
		$viewport_lg = !empty($elementor_vp_lg) ? $elementor_vp_lg - 1 : 1023;
		$viewport_md = !empty($elementor_vp_md) ? $elementor_vp_md - 1 : 767;

		if ('arrows' == $settings['navigation']) {
			$this->add_render_attribute('panel-slider', 'class', 'rbt-arrows-align-' . $settings['arrows_position']);
		} elseif ('dots' == $settings['navigation']) {
			$this->add_render_attribute('panel-slider', 'class', 'rbt-dots-align-' . $settings['dots_position']);
		} elseif ('both' == $settings['navigation']) {
			$this->add_render_attribute('panel-slider', 'class', 'rbt-arrows-dots-align-' . $settings['both_position']);
		} elseif ('arrows-fraction' == $settings['navigation']) {
			$this->add_render_attribute('panel-slider', 'class', 'rbt-arrows-dots-align-' . $settings['arrows_fraction_position']);
		}

		if ('arrows-fraction' == $settings['navigation']) {
			$pagination_type = 'fraction';
		} elseif ('both' == $settings['navigation'] or 'dots' == $settings['navigation']) {
			$pagination_type = 'bullets';
		} elseif ('progressbar' == $settings['navigation']) {
			$pagination_type = 'progressbar';
		} else {
			$pagination_type = '';
		}

		$columns         = $settings['columns'];
		$columns_tablet  = $settings['columns_tablet'];
		$columns_mobile  = $settings['columns_mobile'];

		$this->add_render_attribute(
			[
				'panel-slider' => [

					'data-settings' => [
						wp_json_encode(array_filter([
							"autoplay"        => ("yes" == $settings["autoplay"]) ? ["delay" => $settings["autoplay_speed"]] : false,
							"loop"            => ($settings["loop"] == "yes") ? true : false,
							"speed"           => $settings["speed"]["size"],
							"pauseOnHover"    => ("yes" == $settings["pauseonhover"]) ? true : false,
							"slidesPerView"  => (int) $columns_mobile,
							"slidesPerGroup"  => isset($settings["slides_to_scroll_mobile"]) ? (int)$settings["slides_to_scroll_mobile"] : 1,
							"spaceBetween"    => $settings['column_space']['size'] ?: 0,
							"centeredSlides"  => ($settings["centered_slides"] === "yes") ? true : false,
							"grabCursor"      => ($settings["grab_cursor"] === "yes") ? true : false,
							"freeMode"        => ($settings["free_mode"] === "yes") ? true : false,
							"effect"          => $settings["skin"],
							"observer"        => ($settings["observer"]) ? true : false,
							"observeParents"  => ($settings["observer"]) ? true : false,
							"breakpoints"     => [
								(int)$viewport_md => [
									"slidesPerView"  => (int) $columns_tablet,
									"spaceBetween"   => $settings['column_space']['size'] ?: 0,
									"slidesPerGroup" => isset($settings["slides_to_scroll_tablet"]) ? (int)$settings["slides_to_scroll_tablet"] : 1,
								],
								(int)$viewport_lg => [
									"slidesPerView"  => (int) $columns,
									"spaceBetween"   => $settings['column_space']['size'] ?: 0,
									"slidesPerGroup" => isset($settings["slides_to_scroll"]) ? (int)$settings["slides_to_scroll"] : 1,
								]
							],
							"navigation"      => [
								"nextEl" => "#" . $id . " .rbt-navigation-next",
								"prevEl" => "#" . $id . " .rbt-navigation-prev",
							],
							"pagination"      => [
								"el"             => "#" . $id . " .swiper-pagination",
								"type"           => $pagination_type,
								"clickable"      => "true",
								'dynamicBullets' => ("yes" == $settings["dynamic_bullets"]) ? true : false,
							],
							"scrollbar"       => [
								"el"   => "#" . $id . " .swiper-scrollbar",
								"hide" => "true",
							],
							'coverflowEffect' => [
								'rotate'       => ("yes" == $settings["coverflow_toggle"]) ? $settings["coverflow_rotate"]["size"] : 50,
								'stretch'      => ("yes" == $settings["coverflow_toggle"]) ? $settings["coverflow_stretch"]["size"] : 0,
								'depth'        => ("yes" == $settings["coverflow_toggle"]) ? $settings["coverflow_depth"]["size"] : 100,
								'modifier'     => ("yes" == $settings["coverflow_toggle"]) ? $settings["coverflow_modifier"]["size"] : 1,
								'slideShadows' => true,
							],
						]))
					],

					'class' => [ 'rbt-panel-slider'],

					'id' => $id
				]
			]
		);

		$this->add_render_attribute(
			[
				'panel-slider' => [
					'data-widget-settings' => [
						wp_json_encode([
							'id' => '#' . $id,
						])
					]
				]
			]
		);

        ?>
		<div <?php echo $this->get_render_attribute_string('panel-slider'); ?>>
			<div class="swiper-container">
			    <div class="swiper-wrapper">
			    <?php
	}

	public function render_navigation() {
		$settings = $this->get_settings_for_display();
		$hide_arrow_on_mobile = $settings['hide_arrow_on_mobile'] ? ' rbt-visible@m' : '';
		
		if ( 'arrows' == $settings['navigation'] ) : ?>
			<div class="rbt-position-z-index rbt-position-<?php echo esc_attr( $settings['arrows_position'] . $hide_arrow_on_mobile ); ?>">
				<div class="rbt-arrows-container rbt-slidenav-container">
					<a href="" class="rbt-navigation-prev rbt-slidenav-previous rbt-icon rbt-slidenav">
						<i class="ep-arrow-left-<?php echo esc_attr($settings['nav_arrows_icon']); ?>" aria-hidden="true"></i>
					</a>
					<a href="" class="rbt-navigation-next rbt-slidenav-next rbt-icon rbt-slidenav">
						<i class="ep-arrow-right-<?php echo esc_attr($settings['nav_arrows_icon']); ?>" aria-hidden="true"></i>
					</a>
				</div>
			</div>
		<?php endif;
	}

	public function render_pagination() {
		$settings = $this->get_settings_for_display();
		
		if ( 'dots' == $settings['navigation'] or 'arrows-fraction' == $settings['navigation'] ) : ?>
			<div class="rbt-position-z-index rbt-position-<?php echo esc_attr( $settings['dots_position'] ); ?>">
				<div class="rbt-dots-container">
					<div class="swiper-pagination"></div>
				</div>
			</div>
		<?php
		elseif ( 'progressbar' == $settings['navigation'] ) : ?>
			<div class="swiper-pagination rbt-position-z-index rbt-position-<?php
				echo esc_attr( $settings['progress_position'] ); ?>">
			</div>
		<?php
		endif;
	}

	public function render_both_navigation() {
		$settings = $this->get_settings_for_display();
		$hide_arrow_on_mobile = $settings['hide_arrow_on_mobile'] ? 'rbt-visible@m' : '';
		
		?>
		<div class="rbt-position-z-index rbt-position-<?php echo esc_attr($settings['both_position']); ?>">
			<div class="rbt-arrows-dots-container rbt-slidenav-container ">
				
				<div class="rbt-flex rbt-flex-middle">

					<div class="<?php echo esc_attr( $hide_arrow_on_mobile ); ?>">
						<a href="" class="rbt-navigation-prev rbt-slidenav-previous rbt-icon rbt-slidenav">
							<i class="ep-arrow-left-<?php echo esc_attr($settings['nav_arrows_icon']); ?>" aria-hidden="true"></i>
						</a>
					</div>

					<?php if ('center' !== $settings['both_position']) : ?>
						<div class="swiper-pagination"></div>
					<?php endif; ?>
					
					<div class="<?php echo esc_attr( $hide_arrow_on_mobile ); ?>">
						<a href="" class="rbt-navigation-next rbt-slidenav-next rbt-icon rbt-slidenav">
							<i class="ep-arrow-right-<?php echo esc_attr($settings['nav_arrows_icon']); ?>" aria-hidden="true"></i>
						</a>
					</div>
					
				</div>
				
			</div>
		</div>		
		<?php
	}

	public function render_arrows_fraction() {
		$settings = $this->get_settings_for_display();
		$hide_arrow_on_mobile = $settings['hide_arrow_on_mobile'] ? 'rbt-visible@m' : '';
		
		?>
		<div class="rbt-position-z-index rbt-position-<?php echo esc_attr( $settings['arrows_fraction_position'] ); ?>">
			<div class="rbt-arrows-fraction-container rbt-slidenav-container ">
				
				<div class="rbt-flex rbt-flex-middle">

					<div class="<?php echo esc_attr( $hide_arrow_on_mobile ); ?>">
						<a href="" class="rbt-navigation-prev rbt-slidenav-previous rbt-icon rbt-slidenav">
							<i class="ep-arrow-left-<?php echo esc_attr( $settings['nav_arrows_icon'] ); ?>" aria-hidden="true"></i>
						</a>
					</div>
					
					<?php if ( 'center' !== $settings['arrows_fraction_position'] ) : ?>
						<div class="swiper-pagination"></div>
					<?php endif; ?>
					
					<div class="<?php echo esc_attr( $hide_arrow_on_mobile ); ?>">
						<a href="" class="rbt-navigation-next rbt-slidenav-next rbt-icon rbt-slidenav">
							<i class="ep-arrow-right-<?php echo esc_attr( $settings['nav_arrows_icon'] ); ?>" aria-hidden="true"></i>
						</a>
					</div>
				
				</div>

			</div>
		</div>
		<?php
	}

	public function render_footer() {
		$settings = $this->get_settings_for_display();
		?>
		</div>

		<?php if ( 'yes' === $settings['show_scrollbar'] ) : ?>
			<div class="swiper-scrollbar"></div>
		<?php endif; ?>

		</div>
		
		<?php if ( 'both' == $settings['navigation'] ) : ?>

			<?php $this->render_both_navigation(); ?>

			<?php if ( 'center' === $settings['both_position'] ) : ?>
				<div class="rbt-position-z-index rbt-position-bottom">
					<div class="rbt-dots-container">
						<div class="swiper-pagination"></div>
					</div>
				</div>
		    <?php endif;

		elseif ( 'arrows-fraction' == $settings['navigation'] ) : ?>

			<?php $this->render_arrows_fraction(); ?>

			<?php if ( 'center' === $settings['arrows_fraction_position'] ) : ?>
				<div class="rbt-dots-container">
					<div class="swiper-pagination"></div>
				</div>
			<?php endif;

		else : ?>
			<?php $this->render_pagination(); ?>
			<?php $this->render_navigation(); ?>
		<?php endif; ?>
		
		</div> <?php
	}

	private function print_cite( $item, $settings ) {
	
		$html = '<cite class="elementor-testimonial__cite">';

		if ( ! empty( $item['rating'] ) ) {
			$html .= $this->render_stars( $item, $settings );
		}

		$html .= '</cite>';

		echo wp_kses_post( $html );
	}

	protected function render_stars( $item, $settings ) {
		$icon = '&#xE934;';
		$rating = (float) $item['rating'] > 5 ? 5 : $item['rating'];
		$floored_rating = (int) $rating;
		$stars_html = '';

		for ( $stars = 1; $stars <= 5; $stars++ ) {
			if ( $stars <= $floored_rating ) {
				$stars_html .= '<i class="elementor-star-full">' . $icon . '</i>';
			} elseif ( $floored_rating + 1 === $stars && $rating !== $floored_rating ) {
				$stars_html .= '<i class=" elementor-star-' . ( $rating - $floored_rating ) * 10 . '">' . $icon . '</i>';
			} else {
				$stars_html .= '<i class="elementor-star-empty">' . $icon . '</i>';
			}
		}

		return '<div class=" elementor-star-rating">' . $stars_html . '</div>';
	}

    private function loop_items(){
		$settings = $this->get_settings_for_display();
		$counter   = 1;		

		foreach ($settings['tabs'] as $item) :

			$this->add_render_attribute('panel-slide-item', 'class', ['rbt-panel-slide-item', 'swiper-slide', 'rbt-transition-toggle'], true);
			$this->add_render_attribute('panel-slide-item-title', 'class', ['rbt-panel-slide-title'], true);

			?>
			<div <?php echo $this->get_render_attribute_string('panel-slide-item'); ?>>

				<div class="rbt-panel-slide-desc rbt-position-z-index">
					<?php
					$img_position = '';
					$image_position = $settings['image_position'];
					if ($image_position == 'left-title'){$img_position = 'rbt-flex-row-reverse';}
					elseif ($image_position == 'top-title') {$img_position = 'rbt-flex-column';}
					elseif ($image_position == 'bottom-title') {$img_position = 'rbt-flex-column-reverse';}

					$image_alignment = $settings['image_alignment'];
					$image_h_alignment = $settings['image_h_alignment'];

					$img_box = in_array( $image_position, [ 'right-box', 'left-box' ] );
					$box_img = '';
					if ($image_position == 'left-box') {$box_img = 'rbt-flex-row-reverse';}

					$content_position = '';
					if ($settings['text_position'] == 'bottom') {$content_position = 'rbt-flex-column-reverse';}

					$id = $item['_id'];
					$img_url = $item['photo']['url'];
					$text = $item['text'];
					$name = $item['name'];
					$title = $item['title'];
					$image = "<img src='$img_url' alt='$name' title='$name'>";
					echo "<div class='elementor-repeater-item-$id'>"
						. "<div class='rbt-flex align-items-$image_alignment rbt-flex-center $box_img'>";
							if ($img_box) {echo $image;}

							echo "<div class='testimonial-slide rbt-flex rbt-flex-column $content_position'>"
								. "<div class='content'>"
								    . "<p>$text</p>";
									$this->print_cite( $item, $settings );
								echo "</div>";
								echo "<div class='rbt-flex rbt-flex-middle rbt-flex-$image_h_alignment $img_position'>";
									if (in_array( $image_position, [ 'right-title', 'left-title', 'top-title', 'bottom-title' ] )) {echo $image;}
									echo "<div class='info rbt-flex rbt-flex-column'>"
										. "<h3 class='name'>$name</h3>"
										. "<div class='title'>$title</div>";
									echo "</div>";
								echo "</div>";
								
							echo "</div>"
						. "</div>"
					. "</div>";
					?>
			    </div>

			</div>
			<?php

		$counter++;
		endforeach;
		
	}

	public function render(){
		$this->render_header();
        $this-> loop_items();
	    $this->render_footer();
	}

}