<?php

namespace RoboTheme\inc\elementor\Modules\Posts\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Utils;
use Elementor\Icons_Manager;
use Elementor\Plugin;
use Elementor\Group_Control_Background;

use RoboTheme\inc\elementor\Modules\QueryControl\Controls\Group_Control_Posts;
use RoboTheme\inc\elementor\Modules\QueryControl\Module;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Posts extends Widget_Base {

	private $_query = null;

	public function get_name() {
		return 'rbt_posts';
	}

	public function get_style_depends() {
		return [ 'rbt-font-icon', 'rbt-posts' ];
	}

	public function get_query() {
		return $this->_query;
	}

	public function query_posts() {

		$query_args = Module::get_query_args( 'posts', $this->get_settings() );

		$query_args['posts_per_page'] = $this->get_settings( 'posts_per_page' );

		$this->_query = new \WP_Query( $query_args );

	}

    // controll //
	protected function register_controls() {
		$this->register_controls_content_layout();
		$this->register_controls_content_query();
		$this->register_controls_content_image();
		$this->register_controls_content_meta();
		$this->register_controls_content_title();
		$this->register_controls_content_text();
		$this->register_controls_content_readmore();
		$this->register_controls_content_category();
		$this->register_controls_style_items();
		$this->register_controls_style_image();
		$this->register_controls_style_meta();
		$this->register_controls_style_catagory();
		$this->register_controls_style_title();
		$this->register_controls_style_text();
		$this->register_controls_style_redmore();
	}

	// content //
	protected function register_controls_content_layout(){

		$this->start_controls_section(
			'section_carousel_layout',
			[
				'label' => __( 'Layout', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'style_posts',
			[
				'label'       => __( 'Select Style', TEXT_DOMAIN ),
				'type'        => Controls_Manager::SELECT,
				'default'      => 'style-1',
				'options'     => [
					'none'   => __( 'None', TEXT_DOMAIN ),
					'style-1'   => __( 'Style One', TEXT_DOMAIN ),
					'style-2' => __( 'Style Two', TEXT_DOMAIN ),
				],
			]
		);


		$this->add_control(
			'posts_per_page',
			[
				'label' => __( 'Limit', TEXT_DOMAIN ),
				'type' => Controls_Manager::NUMBER,
				'default' => 6,
			]
		);

		$this->end_controls_section();
		
	}

	protected function register_controls_content_query(){

		$this->start_controls_section(
			'section_query',
			[
				'label' => __( 'Query', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_group_control(
			Group_Control_Posts::get_type(),
			[
				'name'  => 'posts',
				'label' => __( 'Posts', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'advanced',
			[
				'label' => __( 'Advanced', TEXT_DOMAIN ),
				'type'  => Controls_Manager::HEADING,
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'   => __( 'Order By', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'post_date',
				'options' => [
					'post_date'  => __( 'Date', TEXT_DOMAIN ),
					'post_title' => __( 'Title', TEXT_DOMAIN ),
					'menu_order' => __( 'Menu Order', TEXT_DOMAIN ),
					'rand'       => __( 'Random', TEXT_DOMAIN ),
				],
			]
		);

		$this->add_control(
			'order',
			[
				'label'   => __( 'Order', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'desc',
				'options' => [
					'asc'  => __( 'ASC', TEXT_DOMAIN ),
					'desc' => __( 'DESC', TEXT_DOMAIN ),
				],
			]
		);


		$this->add_control(
			'offset',
			[
				'label'     => esc_html__( 'Offset', TEXT_DOMAIN ),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 0,
				'condition' => [
					'posts_post_type!' => 'by_id',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_content_image(){

		$this->start_controls_section(
			'section_layout_image',
			[
				'label' => __( 'Image', TEXT_DOMAIN ),
			]
		);
	
		$this->add_control(
			'thumbnail_show',
			[
				'label'        => __( 'Thumbnail Show', TEXT_DOMAIN ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'yes',
			]
		);
	
		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name'         => 'thumbnail_size',
				'label'        => __( 'Thumbnail Size', TEXT_DOMAIN ),
				'exclude'      => [ 'custom' ],
				'default'      => 'medium',
				'prefix_class' => 'rbt-carousel-thumbnail-size-',
				'condition' => [
					'thumbnail_show' => 'yes',
				],
			]
		);
		
		$this->add_control(
			'show_link_option',
			[
				'label'        => __( 'Thumbnail Show Link?', TEXT_DOMAIN ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'yes',
				'condition' => [
					'thumbnail_show' => 'yes',
					'style_posts' => 'style-1'
				],
			]
		);

		$this->add_control(
			'show_zoom',
			[
				'label'        => __( 'Zoom', TEXT_DOMAIN ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'yes',
				'prefix_class' => 'mz-zoom-thumbnail-',
				'condition' => [
					'thumbnail_show' => 'yes',
					'style_posts' => 'style-1'
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_content_meta(){

		$this->start_controls_section(
			'section_layout_meta',
			[
				'label'     => __( 'Meta', TEXT_DOMAIN ),
				'condition' => [
                    'style_posts' => 'style-1'
				]
			]
		);

		$this->add_control(
			'disable_divider',
			[
				'label'     => __( 'Disable Divider', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'selectors' => [
					'{{WRAPPER}} .elementor-widget-container .rbt-subnav span:after' => 'content: none',
				],
			]
		);

		$this->add_control(
			'location_meta_data',
			[
				'label'       => __( 'Location', TEXT_DOMAIN ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'center',
				'options'     => [
					'top'   => __( 'Top', TEXT_DOMAIN ),
					'center' => __( 'Center', TEXT_DOMAIN ),
					'bottom'     => __( 'Bottom', TEXT_DOMAIN ),
				],
			]
		);

		$this->add_control(
			'meta_data',
			[
				'label'       => __( 'Meta Data', TEXT_DOMAIN ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT2,
				'default'     => [ 'date', 'comments' ],
				'multiple'    => true,
				'options'     => [
					'author'   => __( 'Author', TEXT_DOMAIN ),
					'category' => __( 'Category', TEXT_DOMAIN ),
					'date'     => __( 'Date', TEXT_DOMAIN ),
					'time'     => __( 'Time', TEXT_DOMAIN ),
					'comments' => __( 'Comments', TEXT_DOMAIN ),
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_content_title(){

		$this->start_controls_section(
			'section_layout_title',
			[
				'label' => __( 'Title', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'show_title',
			[
				'label'   => __( 'Show Title', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'     => __( 'Title HTML Tag', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SELECT,
				'options'   => rbt_title_tags(),
				'default'   => 'h2',
				'condition' => [
					'show_title' => 'yes',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_content_text(){

		$this->start_controls_section(
			'section_layout_excerpt',
			[
				'label'     => __( 'Text', TEXT_DOMAIN ),
				'condition' => [
                    'style_posts' => 'style-1'
				]
			]
		);

		$this->add_control(
			'show_excerpt',
			[
				'label'   => __( 'Show Text', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'excerpt_length',
			[
				'label'     => __( 'Text Limit', TEXT_DOMAIN ),
				'description' => esc_html__('It\'s just work for main content, but not working with excerpt. If you set 0 so you will get full main content.', TEXT_DOMAIN),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 15,
				'condition' => [
					'show_excerpt' => 'yes',
				],
			]
		);

		$this->add_control(
			'strip_shortcode',
			[
				'label'   => esc_html__('Strip Shortcode', TEXT_DOMAIN),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition'   => [
					'show_excerpt' => 'yes',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_content_readmore(){

		$this->start_controls_section(
			'section_layout_button',
			[
				'label'     => __( 'Readmore', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'show_read_more',
			[
				'label'   => __( 'Read More', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_position',
			[
				'label'   => __( 'Position', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'selectors' => [ 
					'{{WRAPPER}} .rbt-carousel-button' => 'position:absolute;z-index:1',
				],
				'condition'   => [
					'show_read_more' => 'yes',
				],
			]
		);

		$this->add_control(
			'read_more_text',
			[
				'label'       => __( 'Read More Text', TEXT_DOMAIN ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Read More', TEXT_DOMAIN ),
				'condition'   => [
					'show_read_more' => 'yes',
				],
			]
		);

		$this->add_control(
			'button_size',
			[
				'label'   => __( 'Button Size', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'sm',
				'options' => [
					'xs' => __( 'Extra Small', TEXT_DOMAIN ),
					'sm' => __( 'Small', TEXT_DOMAIN ),
					'md' => __( 'Medium', TEXT_DOMAIN ),
					'lg' => __( 'Large', TEXT_DOMAIN ),
					'xl' => __( 'Extra Large', TEXT_DOMAIN ),
				],
				'condition' => [
					'read_more_text!' => '',
					'show_read_more!' => '',
				],
			]
		);

		$this->add_control(
			'redmore_icon',
			[
				'label'       => esc_html__( 'Button Icon', TEXT_DOMAIN ),
				'type'        => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fa-fw fas fa-plus',
					'library' => 'fa-solid',
				],
				'fa4compatibility' => 'icon',
				'condition'   => [
					'show_read_more!' => '',
				],
			]
		);

		$this->add_control(
			'icon_align',
			[
				'label'   => esc_html__( 'Icon Position', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'right',
				'options' => [
					'left'  => esc_html__( 'Before', TEXT_DOMAIN ),
					'right' => esc_html__( 'After', TEXT_DOMAIN ),
				],
				'condition' => [
					'redmore_icon[value]!' => '',
					'read_more_text!' => '',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_content_category(){

		$this->start_controls_section(
			'section_category',
			[
				'label'     => __( 'Category', TEXT_DOMAIN ),
				'condition' => [
					'style_posts' => 'style-2'
				]
			]
		);

		$this->add_control(
			'show_category',
			[
				'label'     => __( 'Category', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
			]
		);

		$this->end_controls_section();

	}

	// style //
	protected function register_controls_style_items(){

		$this->start_controls_section(
			'section_style_layout',
			[
				'label'     => __( 'Items', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'overlay_info',
			[
				'label'     => __( 'Overlay Info', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sp-2.mz-posts .info-post' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'style_posts' => 'style-2'
				],
			]
		);

		$this->add_control(
			'content_alignment',
			[
				'label'   => esc_html__( 'Alignment', TEXT_DOMAIN ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', TEXT_DOMAIN ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', TEXT_DOMAIN ),
						'icon'  => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', TEXT_DOMAIN ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .mz-posts' => 'text-align: {{VALUE}}',
				],
				
			]
		);

		$this->add_responsive_control(
			'item_info_padding',
			[
				'label'      => __( 'Padding Info', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .info-post' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_style_image(){

		$this->start_controls_section(
			'section_style_image',
			[
				'label'     => __( 'Image', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'thumbnail_show' => 'yes',
				],
			]
		);

		$this->add_control(
			'image_background',
			[
				'label'     => __( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-thumbnail' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'style_posts' => 'style-1'
				],
			]
		);

		$this->add_control(
			'image_overflow',
			[
				'label'     => __( 'Overflow', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sp-1.mz-posts .rbt-carousel-thumbnail:after' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .sp-2.mz-posts .overlay' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'image_width',
			[
				'label' => __( 'Image Width', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 100,
					'unit' => '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'size_units' => [ '%' ],
				'range' => [
					'%' => [
						'min' => 5,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-thumbnail img' => 'width: {{SIZE}}{{UNIT}};margin-left: auto;margin-right: auto;',
				],
				'condition' => [
					'thumbnail_show' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'image_height',
			[
				'label' => __( 'Image Height', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 700,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-thumbnail img' => 'height:100%;height: {{SIZE}}px;',
				],
				'condition' => [
					'thumbnail_show' => 'yes',
				],
			]
		);
	

		$this->add_control(
			'image_opacity',
			[
				'label'   => __( 'Opacity (%)', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max'  => 1,
						'min'  => 0.10,
						'step' => 0.01,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-thumbnail img' => 'opacity: {{SIZE}};',
				],
				'condition' => [
					'style_posts' => 'style-1'
				],
			]
		);

		$this->add_control(
			'image_hover_opacity',
			[
				'label'   => __( 'Hover Opacity (%)', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max'  => 1,
						'min'  => 0.10,
						'step' => 0.01,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-thumbnail:hover img' => 'opacity: {{SIZE}};',
				],
				'condition' => [
					'style_posts' => 'style-1'
				],
			]
		);

		$this->add_responsive_control(
			'image_spacing',
			[
				'label' => __( 'Spacing', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-thumbnail' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'style_posts' => 'style-1'
				],
			]
		);




















		$this->add_responsive_control(
			'image_padding',
			[
				'label'      => __( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-carousel-thumbnail' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
				'condition' => [
					'style_posts' => 'style-1'
				]
			]
		);

		$this->add_responsive_control(
			'image_margin',
			[
				'label'      => __( 'Margin', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-carousel-thumbnail' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
				'condition' => [
					'style_posts' => 'style-1'
				]
			]
		);

		$this->add_control(
			'image_border_radius',
			[
				'label'      => __( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .sp-1.mz-posts .rbt-carousel-thumbnail' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
					'{{WRAPPER}} .sp-1.mz-posts .rbt-carousel-thumbnail img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
					'{{WRAPPER}} .sp-2.mz-posts ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_style_meta(){

		$this->start_controls_section(
			'section_style_meta',
			[
				'label'      => __( 'Meta', TEXT_DOMAIN ),
				'tab'        => Controls_Manager::TAB_STYLE,
				'condition' => [
                    'style_posts' => 'style-1'
				]
			]
		);

		$this->add_control(
			'meta_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-meta span *' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'meta_hover_color',
			[
				'label'     => __( 'Hover Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-meta span:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rbt-carousel-meta span:hover a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'meta_divider_color',
			[
				'label'     => __( 'Divider Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-meta span:after' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'meta_spacing',
			[
				'label' => __( 'Spacing', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-meta'   => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'meta_typography',
				'selector' => '{{WRAPPER}} .rbt-carousel-meta span',
			]
		);

		$this->add_control(
			'meta_alignment',
			[
				'label'   => esc_html__( 'Alignment', TEXT_DOMAIN ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'flex-start' => [
						'title' => esc_html__( 'Left', TEXT_DOMAIN ),
						'icon'  => 'fas fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', TEXT_DOMAIN ),
						'icon'  => 'fas fa-align-center',
					],
					'flex-end' => [
						'title' => esc_html__( 'Right', TEXT_DOMAIN ),
						'icon'  => 'fas fa-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-meta' => 'justify-content: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();
		
	}

	protected function register_controls_style_catagory(){

		$this->start_controls_section(
			'section_style_catagory',
			[
				'label'      => __( 'Catagory', TEXT_DOMAIN ),
				'tab'        => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_category' => 'yes',
				    'style_posts' => 'style-2'
				]
			]
		);

		$this->add_control(
			'category_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-categories a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'category_back_color',
			[
				'label'     => __( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-categories' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'category_border_radius',
			[
				'label'      => __( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-carousel-categories' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'category_typography',
				'selector' => '{{WRAPPER}} .rbt-carousel-categories',
			]
		);
		
		$this->end_controls_section();
		
	}

	protected function register_controls_style_title(){

		$this->start_controls_section(
			'section_style_title',
			[
				'label'     => __( 'Title', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_title' => 'yes',
				],
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-title a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'title_hover_color',
			[
				'label'     => __( 'Hover Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-title a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'title_spacing_top',
			[
				'label' => __( 'Spacing Top', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-title' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'title_spacing_bottom',
			[
				'label' => __( 'Spacing Bottom', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'selector' => '{{WRAPPER}} .rbt-carousel-title',
			]
		);

		$this->end_controls_section();
		
	}

	protected function register_controls_style_text(){

		$this->start_controls_section(
			'section_style_excerpt',
			[
				'label'     => __( 'Text', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_excerpt' => 'yes',
					'style_posts' => 'style-1'
				],
			]
		);

		$this->add_control(
			'excerpt_color',
			[
				'label'     => __( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-excerpt' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'excerpt_spacing',
			[
				'label' => __( 'Spacing', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-excerpt'   => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'excerpt_typography',
				'label'    => esc_html__( 'Typography', TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rbt-carousel-excerpt',
			]
		);

		$this->end_controls_section();

	}

	protected function register_controls_style_redmore(){

		$this->start_controls_section(
			'section_style_button',
			[
				'label'      => __( 'Redmore', TEXT_DOMAIN ),
				'tab'        => Controls_Manager::TAB_STYLE,
				'condition' => [
                    'show_read_more' => 'yes'
				]
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );
		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => esc_html__( 'Normal', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label'     => esc_html__( 'Text Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_background_color',
			[
				'label'     => esc_html__( 'Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'carousel_button_icon_color',
			[
				'label'     => esc_html__( 'Icon Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-button .rbt-carousel-button-icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rbt-carousel-button .rbt-carousel-button-icon svg' => 'fill: {{VALUE}};',
				],
				'condition' => [
					'redmore_icon[value]!' => '',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'button_shadow',
				'selector' => '{{WRAPPER}} .rbt-carousel-button',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(), [
				'name'        => 'button_border',
				'label'       => esc_html__( 'Border', TEXT_DOMAIN ),
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .rbt-carousel-button',
			]
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => esc_html__( 'Hover', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'button_hover_color',
			[
				'label'     => esc_html__( 'Text Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-button:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_background_hover_color',
			[
				'label'     => esc_html__( 'Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-button:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_hover_border_color',
			[
				'label'     => esc_html__( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel-button:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'carousel_button_hover_icon_color',
			[
				'label'     => esc_html__( 'Icon Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-carousel .rbt-carousel-button:hover .rbt-carousel-button-icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rbt-carousel .rbt-carousel-button:hover .rbt-carousel-button-icon svg' => 'fill: {{VALUE}};',
				],
				'condition' => [
					'redmore_icon[value]!' => '',
				],
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'button_hover_shadow',
				'selector' => '{{WRAPPER}} .rbt-carousel-button:hover',
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

































		$this->add_responsive_control(
			'redmore_icon_size',
			[
				'label' => __( 'Icon Size', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'separator' => 'before',
				'range' => [
					'px' => [
						'min'  => 10,
						'max'  => 100,
					],
				],				
				'selectors' => [ 
					'{{WRAPPER}} .rbt-carousel-button .rbt-carousel-button-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rbt-carousel-button .rbt-carousel-button-icon' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'redmore_icon[value]!' => '',
				],
			]
		);

		$this->add_responsive_control(
			'space_icon_vertical',
			[
				'label' => __( 'Space Vertical', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min'  => -100,
						'max'  => 500,
					],
					'%' => [
						'min'  => 0,
						'max'  => 100,
					],
				],				
				'selectors' => [ 
					'{{WRAPPER}} .rbt-carousel-button' => 'bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'show_position' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'space_icon_horizontal',
			[
				'label' => __( 'Position Horizontal', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min'  => 0,
						'max'  => 500,
					],
					'%' => [
						'min'  => 0,
						'max'  => 100,
					],
				],				
				'selectors' => [ 
					'{{WRAPPER}} .rbt-carousel-button' => 'right: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'show_position' => 'yes',
				],
			]
		);

		$this->add_control(
			'button_text_padding',
			[
				'label'      => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-carousel-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'button_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-carousel-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'button_typography',
				'label'    => esc_html__( 'Typography', TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rbt-carousel-button',
			]
		);

		$this->end_controls_section();
	}
	// style //
	
	// render meta //
	public function render_meta_data(){
		$settings = $this->get_settings( 'meta_data' );
		if ( empty( $settings ) ) {
			return;
		}

		?>
		<div class="rbt-carousel-meta rbt-subnav rbt-flex-middle rbt-margin-small-top" rbt-margin>
			<?php
			if ( in_array( 'author', $settings ) ) {
				$this->render_author();
			}

			if ( in_array( 'category', $settings ) ) {
				$this->render_category();
			}

			if ( in_array( 'date', $settings ) ) {
				$this->render_date();
			}

			if ( in_array( 'time', $settings ) ) {
				$this->render_time();
			}

			if ( in_array( 'comments', $settings ) ) {
				$this->render_comments();
			}
			?>
		</div>
		<?php
	}

	public function render_category_project(){
		global $post;
		if( $this->get_settings( 'show_category' ) && $this->get_settings( 'style_posts' ) == 'style-2'  ) {
			?>
            <span class="rbt-carousel-categories">
				<?php echo get_the_term_list( $post->ID, 'portfolio_cat', '', ', ' );  ?>
			</span>
		    <?php 
		}
	}

	public function render_author(){
		?>
		<span class="pc-author">
			<span class='eicon-person'></span>
			<?php the_author(); ?>
		</span>
		<?php
	}

	public function render_category(){
		?>
		<span class="pc-category">
			<span class='eicon-sitemap'>
			    <?php echo get_the_category_list(', ' ); ?>
			</span>
		</span>
		<?php 
	}

	public function render_date(){
		?>
		<span class="pc-date">
			<span class='eicon-calendar'></span>
			<?php echo apply_filters( 'the_date', get_the_date('M j, Y'), get_option( 'date_format' ), '', '' ); ?>
		</span>
		<?php
	}

	public function render_time(){
		?>
		<span class="pc-time">
			<span class='eicon-clock-o'>
				
			</span>
			<?php the_time(); ?>
		</span>
		<?php
	}

	public function render_comments(){
		?>
		<span class="pc-avatar">
			<span class='eicon-comments'>
				
			</span>
			<?php comments_number(); ?>
		</span>
		<?php
	}
	// render meta //

    // render content //
	public function render_thumbnail(){
		$settings = $this->get_settings_for_display();

		if ( 'yes' !== $settings['thumbnail_show'] ) {
			return;
		}

		$settings['thumbnail_size'] = [
			'id' => get_post_thumbnail_id(),
		];

		$thumbnail_html        = Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail_size' );
		$placeholder_image_src = Utils::get_placeholder_image_src();

		if ( ! $thumbnail_html ) {
			$thumbnail_html = '<img src="' . esc_url( $placeholder_image_src ) . '" alt="' . get_the_title() . '">';
		}

		?>
		<div class="rbt-carousel-thumbnail">

			<?php if ('yes' == $settings['show_link_option']) { ?>
				<a href="<?php echo get_permalink() ?>" title="<?php echo get_the_title(); ?>">
			<?php } ?>

				<?php echo wp_kses_post($thumbnail_html) ?>

			<?php if ('yes' == $settings['show_link_option']) { ?>
				</a>
			<?php } ?>

		</div>
		<?php
	}

	public function render_title(){
		if ( ! $this->get_settings( 'show_title' ) ) {
			return;
		}

		$tag = $this->get_settings( 'title_tag' );
		$classes = ['rbt-carousel-title rbt-margin-small-bottom', 'rbt-margin-remove-top']
		?>

		<<?php echo esc_html($tag) ?> class="<?php echo implode(" ", $classes); ?>">
		<a href="<?php echo get_permalink() ?>">
			<?php the_title() ?>
		</a>
		</<?php echo esc_html($tag) ?>>
		<?php
	}

	public function render_excerpt(){
		if ( ! $this->get_settings( 'show_excerpt' ) ) {
			return;
		}

		$strip_shortcode = $this->get_settings_for_display('strip_shortcode');

		?>
		<div class="rbt-carousel-excerpt">
			<?php 
				if ( has_excerpt() ) {
					the_excerpt();
				} else {
					echo rbt_custom_excerpt($this->get_settings_for_display('excerpt_length'), $strip_shortcode);
				}
			?>
		</div>
		<?php
	}

	public function render_readmore(){
		$settings    = $this->get_settings_for_display();

		if ( ! $this->get_settings( 'show_read_more' ) ) {
			return;
		}

		if ( 'left' == $settings['icon_align'] or 'right' == $settings['icon_align'] ) {
			$this->add_render_attribute( 'carousel-button', 'class', 'rbt-flex rbt-flex-middle', 'true' );
		}

		if ( ! isset( $settings['icon'] ) && ! Icons_Manager::is_migration_allowed() ) {
			// add old default
			$settings['icon'] = 'fas fa-arrow-right';
		}

		$migrated  = isset( $settings['__fa4_migrated']['redmore_icon'] );
		$is_new    = empty( $settings['icon'] ) && Icons_Manager::is_migration_allowed();

		?>
		<a class="rbt-carousel-button" href="<?php echo get_permalink(); ?>"> 
			<span <?php echo $this->get_render_attribute_string( 'carousel-button' ); ?>>
				<?php echo esc_html( $settings['read_more_text'] ); ?> 

				<?php if ($settings['redmore_icon']['value']) : ?>
					<span class="rbt-carousel-button-icon rbt-flex-align-<?php echo esc_attr($settings['icon_align']); ?>">

						<?php if ( $is_new || $migrated ) :
							Icons_Manager::render_icon( $settings['redmore_icon'], [ 'aria-hidden' => 'true', 'class' => 'fa-fw' ] );
						else : ?>
							<i class="<?php echo esc_attr( $settings['icon'] ); ?>" aria-hidden="true"></i>
						<?php endif; ?>

					</span>
				<?php endif; ?>
			</span>

		</a>
		<?php
	}
	// render content //

	public function render_post() {

		$lmd = $this->get_settings('location_meta_data');
		$style_posts = $this->get_settings('style_posts');

		switch ($style_posts) {

			case "style-1":

				echo "<div class='mz-posts sp-1'>";
					$this->render_thumbnail();
					echo "<div class='info-post'>";
						if( $lmd == 'top'){$this->render_meta_data();}
						$this->render_title();
						if($lmd == 'center'){$this->render_meta_data();}
						$this->render_excerpt();
						if($lmd == 'bottom'){$this->render_meta_data();}
						$this->render_readmore();
					echo "</div>"
			    ."</div>";

			break;

			case "style-2":

				echo "<div class='mz-posts sp-2'>";
				    $this->render_thumbnail();
				    echo "<div class='overlay'>";
					    $this->render_readmore();
					echo "</div>";
					echo "<div class='info-post'>";
						$this->render_title();
						$this->render_category_project();
					echo "</div>";
			    echo "</div>";
	
			break;

		}

	}

}