<?php
namespace RoboTheme\inc\elementor\Modules\Member\Skins;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Background;
use Elementor\Icons_Manager;

use Elementor\Skin_Base as Elementor_Skin_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Skin_Ekip extends Elementor_Skin_Base {
	protected function register_controls_actions() {
		parent::register_controls_actions();

		add_action( 'elementor/element/rbt-member/section_style/before_section_start', [ $this, 'register_ekip_style_controls' ] );

	}

	public function get_id() {
		return 'rbt-ekip';
	}

	public function get_title() {
		return __( 'Ekip', TEXT_DOMAIN );
	}

	public function register_ekip_style_controls() {
		$this->start_controls_section(
			'section_style_phaedra',
			[
				'label' => __( 'Ekip', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'ekip_overlay_background_color',
				'label' => __( 'Background', TEXT_DOMAIN ),
				'types' => [ 'gradient' ],
				'selector' => '{{WRAPPER}} .rbt-member.rbt-member-skin-ekip .rbt-member-skin-ekip-overlay',
			]
		);

		$this->add_control(
			'ekip_overlay_line_color',
			[
				'label'     => __( 'Overlay Line Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-member.rbt-member-skin-ekip .rbt-member-skin-ekip-overlay' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	public function render() {
		$ekip_id = 'ekip' . $this->parent->get_id();
		$settings   = $this->parent->get_settings_for_display();

		$this->parent->add_render_attribute( 'skin-ekip', 'class', ['rbt-member', 'rbt-member-skin-ekip', 'rbt-transition-toggle', 'rbt-image-mask'] );

		if(($settings['member_alternative_photo']) and ( ! empty( $settings['alternative_photo']['url']))) {
			$this->parent->add_render_attribute( 'skin-ekip', 'class', ['rbt-position-relative', 'rbt-overflow-hidden', 'rbt-transition-toggle'] );
			$this->parent->add_render_attribute( 'skin-ekip', 'rbt-toggle', 'target: > div > .rbt-member-photo-flip; mode: hover; animation: rbt-animation-fade; queued: true; duration: 300;' );
		}

		if ( ! isset( $settings['social_icon'] ) && ! Icons_Manager::is_migration_allowed() ) {
			// add old default
			$settings['social_icon'] = 'fab fa-facebook-f';
		}

		?>
		<div <?php echo $this->parent->get_render_attribute_string( 'skin-ekip' ); ?>>
		
				<?php if ( ! empty( $settings['photo']['url'] ) ) :
					$photo_hover_animation = ( '' != $settings['photo_hover_animation'] ) ? ' rbt-transition-scale-'.$settings['photo_hover_animation'] : ''; ?>

					<div class="rbt-member-photo-wrapper">

						<?php if(($settings['member_alternative_photo']) and ( ! empty( $settings['alternative_photo']['url']))) : ?>
							<div class="rbt-member-photo-flip rbt-position-absolute rbt-position-z-index">
								<?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'alternative_photo' ); ?>
							</div>
						<?php endif; ?>

						<div class="rbt-member-photo">
							<div class="<?php echo ($photo_hover_animation); ?>">
								<?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'photo' ); ?>
							</div>
						</div>

					</div>
					
				<?php endif; ?>

				<div class="rbt-member-skin-ekip-overlay">
					<div class="rbt-member-desc">

						<div class="rbt-member-description">
							<?php if ( ! empty( $settings['role'] ) ) : ?>
								<span class="rbt-member-role"><?php echo wp_kses( $settings['role'], rbt_allow_tags('title') ); ?></span>
							<?php endif; ?>
							<?php if ( ! empty( $settings['name'] ) ) : ?>
								<span class="rbt-member-name"><?php echo wp_kses( $settings['name'], rbt_allow_tags('title') ); ?></span>
							<?php endif; ?>
						</div>
						
						<?php if ( 'yes' == $settings['member_social_icon'] ) : ?>
						<div class="rbt-member-icons">
							<?php 
							foreach ( $settings['social_link_list'] as $link ) :
								$tooltip = ( 'yes' == $settings['social_icon_tooltip'] ) ? ' title="' . $link['social_link_title'] . '" rbt-tooltip' : ''; ?>

								<?php 
								$migrated  = isset( $link['__fa4_migrated']['social_share_icon'] );
								$is_new    = empty( $link['social_icon'] ) && Icons_Manager::is_migration_allowed();
								?>
								
								<a href="<?php echo esc_url( $link['social_link'] ); ?>" class="rbt-member-icon elementor-repeater-item-<?php echo esc_attr($link['_id']); ?>" target="_blank"<?php echo wp_kses_post($tooltip); ?>>

									<?php if ( $is_new || $migrated ) :
										Icons_Manager::render_icon( $link['social_share_icon'], [ 'aria-hidden' => 'true', 'class' => 'fa-fw' ] );
									else : ?>
										<i class="<?php echo esc_attr( $link['social_icon'] ); ?>" aria-hidden="true"></i>
									<?php endif; ?>

								</a>

							<?php endforeach; ?>
						</div>
						<?php endif; ?>
					</div>
				</div>
				
		</div>
		<?php
	}
}

