<?php

namespace RoboTheme;

use Elementor\Plugin;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class RoboTheme_Loader {

    private static $_instance;

    private $_modules_manager;

    public static function elementor(){
        return Plugin::$instance;
    }

    public static function instance(){
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    // Executor //
    private function __construct(){

        $is_elementor_callable = ( defined( 'ELEMENTOR_VERSION' ) && is_callable( 'Elementor\Plugin::instance' ) ) ? true : false;

        if ( ! $is_elementor_callable ) {
            $this->elementor_not_available( $is_elementor_callable );
        }

        if ( $is_elementor_callable ) {
            $this->_includes();
            $this->setup_hooks();
        }
    
    }
    
    // includes //
    private function _includes(){
        include "autoload.php";
        include "managar-modules.php";
        include "robotheme-module-base.php";
    }

    //#### style Sayron ###//
    private function setup_hooks(){
        add_action('elementor/init', [$this, 'robotheme_init']);
        // css //
        add_action('elementor/frontend/before_register_styles', [$this, 'register_site_styles']);
        add_action('elementor/frontend/after_register_styles', [$this, 'enqueue_site_styles']);
    }

    // add category //
    public function robotheme_init(){

        $this->_modules_manager = new Manager_Modules;

        $elementor = Plugin::$instance;

        // Add element category in panel
        $elementor->elements_manager->add_category(
            RBT_CAT, 
            [
                'title' => __( 'Sayron', TEXT_DOMAIN ),
                'icon' => 'font'
            ]
        );

    }

    // css //
    public function register_site_styles(){
        wp_register_style('rbt-font-icon', RBT_ASSETS_URL . 'css/rbt-font-icon.css', []);
    }

    public function enqueue_site_styles(){
        wp_enqueue_style('public', RBT_ASSETS_URL . 'css/public.css', [], true );
    }

    /**
	 * Prints the admin notics when Elementor is not installed or activated or version outdated.
	 *
	 * @since 1.5.9
	 * @param  boolean $is_elementor_callable specifies if elementor is available.
	 * @param  boolean $is_elementor_outdated specifies if elementor version is old.
	 */
	public function elementor_not_available( $is_elementor_callable ) {

		if ( ( ! did_action( 'elementor/loaded' ) ) || ( ! $is_elementor_callable ) ) {
			add_action( 'admin_notices', [ $this, 'elementor_not_installed_activated' ] );
			add_action( 'network_admin_notices', [ $this, 'elementor_not_installed_activated' ] );
			return;
		}

	}

    /**
	 * Prints the admin notics when Elementor is not installed or activated.
	 */
	public function elementor_not_installed_activated() {

		$screen = get_current_screen();
		if ( isset( $screen->parent_file ) && 'plugins.php' === $screen->parent_file && 'update' === $screen->id ) {
			return;
		}

		if ( ! did_action( 'elementor/loaded' ) ) {
			// Check user capability.
			if ( ! ( current_user_can( 'activate_plugins' ) && current_user_can( 'install_plugins' ) ) ) {
				return;
			}

			/* TO DO */
			$class = 'notice notice-error';
			/* translators: %s: html tags */
			$message = sprintf( __( 'The %1$sFatak%2$s Template requires %1$sElementor%2$s plugin installed & activated.', 'header-footer-elementor' ), '<strong>', '</strong>' );

			$plugin = 'elementor/elementor.php';

			if ( _is_elementor_installed() ) {

				$action_url   = wp_nonce_url( 'plugins.php?action=activate&amp;plugin=' . $plugin . '&amp;plugin_status=all&amp;paged=1&amp;s', 'activate-plugin_' . $plugin );
				$button_label = __( 'Activate Elementor', 'header-footer-elementor' );

			} else {

				$action_url   = wp_nonce_url( self_admin_url( 'update.php?action=install-plugin&plugin=elementor' ), 'install-plugin_elementor' );
				$button_label = __( 'Install Elementor', 'header-footer-elementor' );
			}

			$button = '<p><a href="' . esc_url( $action_url ) . '" class="button-primary">' . esc_html( $button_label ) . '</a></p><p></p>';

			printf( '<div class="%1$s"><p>%2$s</p>%3$s</div>', esc_attr( $class ), wp_kses_post( $message ), wp_kses_post( $button ) );
		}
	}

}
RoboTheme_Loader::instance();

if ( ! function_exists( '_is_elementor_installed' ) ) {

	/**
	 * Check if Elementor is installed
	 *
	 * @since 1.6.0
	 *
	 * @access public
	 */
	function _is_elementor_installed() {
		return ( file_exists( WP_PLUGIN_DIR . '/elementor/elementor.php' ) ) ? true : false;
	}
}