( function( $, elementor ) {

    'use strict';

    var widgetWoocommerce = function( $scope, $ ) {

        /* gallery  */
        var galleryTop = new Swiper(".gallery", {
            spaceBetween: 10,
            grabCursor: true,
            navigation: {
                nextEl: ".swiper-button-next",
                prevEl: ".swiper-button-prev"
            },
            loop: true,
            loopedSlides: 4,
            autoplay: {
                delay: 5000
            },
            // other parameters
            on: {
                click: function() {
                /* do something */
                }
            },
            keyboard: {
                enabled: true,
                onlyInViewport: false
            }
        });

        /* thumbs */
        var galleryThumbs = new Swiper(".gallery-thumbs", {
            spaceBetween: 10,
            centeredSlides: true,
            slidesPerView: "auto",
            touchRatio: 0.4,
            slideToClickedSlide: true,
            loop: true,
            loopedSlides: 4,
            keyboard: {
                enabled: true,
                onlyInViewport: false
            }
        });
        
        /* set conteoller  */
        galleryTop.controller.control = galleryThumbs;
        galleryThumbs.controller.control = galleryTop;
        
    };

    var WidgeMiniCart = function( $scope, $ ) {

        $scope.find(".rbt-offcanvas-button").click(function(){
            $('.rbt-offcanvas').addClass('open-offcanvas');
        });
        
        $scope.find(".rbt-offcanvas-close").click(function(e){
            if($('.rbt-offcanvas').hasClass('open-offcanvas')) {
                $('.rbt-offcanvas').removeClass('open-offcanvas');
            }
        });
    };

jQuery(window).on('elementor/frontend/init', function() {
    elementorFrontend.hooks.addAction( 'frontend/element_ready/rbt-product-images.default', widgetWoocommerce );
    elementorFrontend.hooks.addAction( 'frontend/element_ready/rbt-mini-cart.default', WidgeMiniCart );
});

}( jQuery, window.elementorFrontend ) );