<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.5.1
 */

defined( 'ABSPATH' ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

global $product;
$gallery_ids = $product->get_gallery_image_ids();

if( has_post_thumbnail() ) :
	$image_id = get_post_thumbnail_id();
	array_unshift( $gallery_ids, $image_id );
endif;

?>
<!-- top gallery -->
<main class="swiper gallery">
    <div class="swiper-wrapper">
		<?php foreach( $gallery_ids as $gallery_id ) { ?>
			<?php $image_src = wp_get_attachment_url($gallery_id); ?>
			<div class="swiper-slide">
				<div class="swiper-zoom-container">
					<img src="<?php echo $image_src; ?>">
				</div>
			</div>
		<?php } ?>
	</div>
	<!-- Add Arrows -->
	<div title="next" class="swiper-button-next swiper-button-white"></div>
	<div title="prev" class="swiper-button-prev swiper-button-white"></div>
</main>
<?php

do_action( 'woocommerce_product_thumbnails' );