<?php

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class RBT_Base_App {

    private static $_instance;

    public static function instance(){
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    private function __construct(){
        add_action('after_setup_theme', [ $this, 'setup_theme' ] );
        $this->_includes();
        $this->setup_hooks(); 
    }

    public function setup_theme(){

        load_theme_textdomain( TEXT_DOMAIN , RBT_PATH . '/languages');
        
        // Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );
    
        /*
        * Let WordPress manage the document title.
        * By adding theme support, we declare that this theme does not use a
        * hard-coded <title> tag in the document head, and expect WordPress to
        * provide it for us.
        */
        add_theme_support( 'title-tag' );
    
        /*
        * Enable support for Post Thumbnails on posts and pages.
        *
        * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
        */
        add_theme_support( 'post-thumbnails' );
        set_post_thumbnail_size( 1200, 9999 );
        add_image_size( 'size-robotheme', 1980, 9999 );
    
        // register Nav Menu //
        $locations = array(
            'primary'  => __( 'Desktop Horizontal Menu', TEXT_DOMAIN ),
            'expanded' => __( 'Desktop Expanded Menu', TEXT_DOMAIN ),
            'mobile'   => __( 'Mobile Menu', TEXT_DOMAIN ),
            'footer'   => __( 'Footer Menu', TEXT_DOMAIN ),
            'social'   => __( 'Social Menu', TEXT_DOMAIN ),
        );
    
        register_nav_menus( $locations );
    
        add_theme_support(
            'html5',
            array(
                'search-form',
                'comment-form',
                'comment-list',
                'gallery',
                'caption',
            )
        );
    
        // Add theme support for selective refresh for widgets.
        add_theme_support( 'customize-selective-refresh-widgets' );
    
        // Add support Shop Woocommerce.
        add_theme_support( 'woocommerce');
    
        // Add support for Block Styles.
        add_theme_support( 'wp-block-styles' );
    
        // // Add support for full and wide align images.
        add_theme_support( 'align-wide' );
    
        // // Add support for editor styles.
        add_theme_support( 'editor-styles' );
    
        // // Enqueue editor styles.
        add_editor_style( 'style-editor.css' );
    
        // Add support for responsive embedded content.
        add_theme_support( 'responsive-embeds' );
    
    }

    private function _includes(){
        include RBT_PATH .'inc/admin/base-admin.php';
        include "elementor/base-elementor.php";
        include "helper.php";
        include "post-type.php";
        include "taxonomy.php";
        include "classes.php";
    }

    private function setup_hooks(){
        add_action( 'wp_head', [$this, 'rbt_font' ] );
        add_action( 'admin_head', [$this, 'rbt_font' ] );
        add_action( 'customize_controls_print_styles', [$this, 'rbt_font' ]);
        add_action( 'elementor/editor/before_enqueue_scripts', [$this, 'rbt_font' ] );
    }

    public function rbt_font(){

        ?>
        <style type="text/css">
            @font-face {
                font-family: IRANSans;
                src: url('<?php echo RBT_ASSETS_URL; ?>fonts/IRANSansWeb.eot');
                src: url('<?php echo RBT_ASSETS_URL; ?>fonts/IRANSansWeb.eot?#iefix') format('embedded-opentype'),
                    url('<?php echo RBT_ASSETS_URL; ?>fonts/IRANSansWeb.woff') format('woff'),
                    url('<?php echo RBT_ASSETS_URL; ?>fonts/IRANSansWeb.woff2') format('woff2'),
                    url('<?php echo RBT_ASSETS_URL; ?>fonts/IRANSansWeb.ttf') format('truetype');
                font-weight: normal;
            }   
                
            @font-face {
                font-family: IRANSans;
                src: url('<?php echo RBT_ASSETS_URL; ?>fonts/IRANSansWeb_Bold.eot');
                src: url('<?php echo RBT_ASSETS_URL; ?>fonts/IRANSansWeb_Bold.eot?#iefix') format('embedded-opentype'),
                    url('<?php echo RBT_ASSETS_URL; ?>fonts/IRANSansWeb_Bold.woff') format('woff'),
                    url('<?php echo RBT_ASSETS_URL; ?>fonts/IRANSansWeb_Bold.wof2f') format('woff2'),
                    url('<?php echo RBT_ASSETS_URL; ?>fonts/IRANSansWeb_Bold.ttf') format('truetype');
                font-weight: bold;
            }

            div, button, select, input, textarea, .rtl h1, .rtl h2, .rtl h3, .rtl h4, .rtl h5, .rtl h6 {
                font-family: IRANSans;
            }

        </style>
        <?php
        
    }

}
RBT_Base_App::instance();
