<?php

namespace RoboTheme\inc\elementor\Modules\Thumbnail\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Icons_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RBT_Thumbnail extends Widget_Base {

    public function get_name() {
        return 'rbt-thumbnail';
    }

    public function get_title() {
        return __( 'Thumbnail', TEXT_DOMAIN );
    }

    public function get_icon() {
        return 'eicon-image';
    }

    public function get_categories() {
        return [ RBT_CAT ];
    }

    public function get_keywords() {
        return [ 'views', 'post', 'thumbnail' ];
    }

    protected function register_controls() {
        $this->register_image_controls();
        $this->register_image_style_controls();
    }

    protected function register_image_controls() {
        $this->start_controls_section(
            'image_setting',
            [
                'label' => __( 'Setting', TEXT_DOMAIN ),
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'image',
                'default' => 'large',
            ]
        );
        $this->add_responsive_control(
            'object_fit',
            [
                'label' => __( 'Object Fit', TEXT_DOMAIN ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'inherit' => __( 'None', TEXT_DOMAIN ),
                    'cover' => __( 'Cover', TEXT_DOMAIN ),
                    'contain' => __( 'Contain', TEXT_DOMAIN ),
                    'fill' => __( 'Fill', TEXT_DOMAIN ),
                    'scale-down' => __( 'Scale Down', TEXT_DOMAIN ),
                ],
                'default' => 'inherit',
                'selectors' => [
                    '{{WRAPPER}} img' => 'object-fit: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'alignment',
            [
                'label' => __( 'Position', TEXT_DOMAIN ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [
                        'title' => __( 'Right', TEXT_DOMAIN ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => __( 'Center', TEXT_DOMAIN ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'left' => [
                        'title' => __( 'Left', TEXT_DOMAIN ),
                        'icon' => 'eicon-text-align-left',
                    ]
                ],
                'default' => 'center',
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => __( 'Default Image', TEXT_DOMAIN ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => RBT_ASSETS_URL . 'images/no-image.jpg',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function register_image_style_controls() {
        $this->start_controls_section(
            'image_style',
            [
                'label' => __( 'Style', TEXT_DOMAIN ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'width',
            [
                'label' => __( 'Width', TEXT_DOMAIN ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 80,
                ],
                'selectors' => [
                    '{{WRAPPER}} figure' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} img' => 'width: 100%;',
                ],
            ]
        );
        $this->add_responsive_control(
            'height',
            [
                'label' => __( 'Height', TEXT_DOMAIN ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => __( 'Padding', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'margin',
            [
                'label' => __( 'Margin', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'image_effects' );

        $this->start_controls_tab( 'normal', ['label' => __( 'Normal', TEXT_DOMAIN ),]);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => __( 'Background', TEXT_DOMAIN ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} figure',
            ]
        );
        $this->add_responsive_control(
            'border_radius',
            [
                'label' => __( 'Border Radius', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'default'   => [
                    'top' => 15,
                    'right' => 15,
                    'bottom' => 15,
                    'left' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} img,{{WRAPPER}} figure' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'label' => __( 'Box Shadow', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} img',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => __( 'Border', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} img',
            ]
        );
        $this->add_control(
            'opacity',
            [
                'label' => __( 'Opacity', TEXT_DOMAIN ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} img' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'css_filters',
                'selector' => '{{WRAPPER}} img',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab( 'hover', ['label' => __( 'Hover', TEXT_DOMAIN ),]);
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'background_hover',
                'label' => __( 'Background', TEXT_DOMAIN ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} figure:hover',
            ]
        );

        $this->add_responsive_control(
            'border_radius_hover',
            [
                'label' => __( 'Border Radius', TEXT_DOMAIN ),
                'type' => Controls_Manager::DIMENSIONS,
                'default'   => [
                    'top' => 15,
                    'right' => 15,
                    'bottom' => 15,
                    'left' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} figure:hover img,{{WRAPPER}} figure:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow_hover',
                'label' => __( 'Box Shadow', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} figure:hover img',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border_hover',
                'label' => __( 'Border', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} figure:hover img',
            ]
        );
        $this->add_control(
            'opacity_hover',
            [
                'label' => __( 'Opacity', TEXT_DOMAIN ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} figure:hover img' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'css_filters_hover',
                'selector' => '{{WRAPPER}} figure:hover img',
            ]
        );

        $this->add_control(
            'background_hover_transition',
            [
                'label' => __( 'Transition Duration', TEXT_DOMAIN ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 3,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} img,{{WRAPPER}} figure' => 'transition-duration: {{SIZE}}s',
                ],
            ]
        );

        $this->add_control(
            'hover_animation',
            [
                'label' => __( 'Hover Animation', TEXT_DOMAIN ),
                'type' => Controls_Manager::HOVER_ANIMATION,
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();
        
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();
        $alignment = $settings['alignment'];
        $image_size = $settings['image_size'];
        $image = $settings['image']['url'];
        $hover_animation = $settings['hover_animation'];

        echo "<div class='thumbnail rbt-flex rbt-flex-$alignment'>
            <figure class='figure $hover_animation'>";
                if (has_post_thumbnail()) :
                    the_post_thumbnail($image_size, array('alt' => '' . get_the_title() . '', 'title' => '' . get_the_title() . ''));
                else :
                    echo '<img src="' . $image . '" alt="' . get_the_title() . '" />';
                endif;
            echo "</figure>
        </div>";
    }
}