<?php

namespace RoboTheme\inc\elementor\Modules\StartLoop\Widgets;

use Elementor\Widget_Base;
use Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RBT_Start_Loop extends Widget_Base {

    public function get_name() {
        return 'rbt-start-loop';
    }

    public function get_title() {
        return __( 'Start Loop', TEXT_DOMAIN );
    }

    public function get_icon() {
        return 'eicon-editor-code';
    }

    public function get_categories() {
        return [ RBT_CAT ];
    }

    public function get_keywords() {
        return [ 'start', 'loop' ];
    }

    protected function render() {
        $editor = Plugin::$instance->editor->is_edit_mode();
        if($editor) {
            echo '<div class="text-center" style="color: white;background-color: darkgray;padding: 10px 0;border-radius: 4px;">' . __('Start Loop', TEXT_DOMAIN) . ' ' . __('(Do not delete this element)', TEXT_DOMAIN) . '</div>';
        } else {
            if ( have_posts() ) {
                the_post();
            }
        }
    }
}