<?php
namespace RoboTheme\inc\elementor\Modules\Member\Skins;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Core\Files\Assets\Svg\Svg_Handler;

use Elementor\Skin_Base as Elementor_Skin_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Skin_Phaedra extends Elementor_Skin_Base {
	protected function register_controls_actions() {
		parent::register_controls_actions();

		add_action( 'elementor/element/rbt-member/section_style/before_section_start', [ $this, 'register_phaedra_style_controls' ] );

	}

	public function get_id() {
		return 'rbt-phaedra';
	}

	public function get_title() {
		return __( 'Phaedra', TEXT_DOMAIN );
	}

	public function register_phaedra_style_controls() {
		$this->start_controls_section(
			'section_style_phaedra',
			[
				'label' => __( 'Phaedra', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'phaedra_overlay_color',
			[
				'label'     => __( 'Overlay Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-member .rbt-member-overlay' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	public function render() {
		$phaedra_id = 'phaedra' . $this->parent->get_id();
		$settings   = $this->parent->get_settings();

		$this->parent->add_render_attribute( 'skin-phaedra', 'class', ['rbt-member', 'rbt-member-skin-phaedra', 'rbt-transition-toggle', 'rbt-image-mask'] );

		if(($settings['member_alternative_photo']) and ( ! empty( $settings['alternative_photo']['url']))) {
			$this->parent->add_render_attribute( 'skin-phaedra', 'class', ['rbt-position-relative', 'rbt-overflow-hidden', 'rbt-transition-toggle'] );
			$this->parent->add_render_attribute( 'skin-phaedra', 'rbt-toggle', 'target: > div > .rbt-member-photo-flip; mode: hover; animation: rbt-animation-fade; queued: true; duration: 300;' );
		}

		if ( ! isset( $settings['social_icon'] ) && ! Icons_Manager::is_migration_allowed() ) {
			// add old default
			$settings['social_icon'] = 'fab fa-facebook-f';
		}

		?>
		<div <?php echo $this->parent->get_render_attribute_string( 'skin-phaedra' ); ?>>
		<?php

			if ( ! empty( $settings['photo']['url'] ) ) :
				$photo_hover_animation = ( '' != $settings['photo_hover_animation'] ) ? ' rbt-transition-scale-'.$settings['photo_hover_animation'] : ''; ?>

				<div class="rbt-member-photo-wrapper">

					<?php if(($settings['member_alternative_photo']) and ( ! empty( $settings['alternative_photo']['url']))) : ?>
						<div class="rbt-member-photo-flip rbt-position-absolute rbt-position-z-index">
							<?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'alternative_photo' ); ?>
						</div>
					<?php endif; ?>

					<div class="rbt-member-photo">
						<div class="<?php echo ($photo_hover_animation); ?>">
							<?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'photo' ); ?>
						</div>
					</div>

				</div>
				
			<?php endif; ?>

			<div class="rbt-member-overlay rbt-overlay-default rbt-position-cover rbt-transition-fade">
				<div class="rbt-member-desc rbt-position-center rbt-text-center">
					<div class="rbt-member-description rbt-transition-slide-top-small">
						<?php if ( ! empty( $settings['name'] ) ) : ?>
							<span class="rbt-member-name"><?php echo wp_kses( $settings['name'], rbt_allow_tags('title') ); ?></span>
						<?php endif; ?>
						<?php if ( ! empty( $settings['role'] ) ) : ?>
							<span class="rbt-member-role"><?php echo wp_kses( $settings['role'], rbt_allow_tags('title') ); ?></span>
						<?php endif; ?>
					</div>
					
					<?php if ( 'yes' == $settings['member_social_icon'] ) : ?>
					<div class="rbt-member-icons rbt-transition-slide-bottom-small">
						<?php 
						foreach ( $settings['social_link_list'] as $link ) :
							$tooltip = ( 'yes' == $settings['social_icon_tooltip'] ) ? ' rbt-tooltip="'.esc_attr( $link['social_link_title'] ).'"' : ''; ?>

							<?php 
							$migrated  = isset( $link['__fa4_migrated']['social_share_icon'] );
							$is_new    = empty( $link['social_icon'] ) && Icons_Manager::is_migration_allowed();
							?>

							<a href="<?php echo esc_url( $link['social_link'] ); ?>" class="rbt-member-icon elementor-repeater-item-<?php echo esc_attr($link['_id']); ?>" target="_blank"<?php echo wp_kses_post($tooltip); ?>>

								<?php if ( $is_new || $migrated ) :
									Icons_Manager::render_icon( $link['social_share_icon'], [ 'aria-hidden' => 'true', 'class' => 'fa-fw' ] );
								else : ?>
									<i class="<?php echo esc_attr( $link['social_icon'] ); ?>" aria-hidden="true"></i>
								<?php endif; ?>

							</a>
						<?php endforeach; ?>
					</div>
					<?php endif; ?>

				</div>
			</div>			
		</div>
		<?php
	}
}