<?php

namespace RoboTheme\inc\elementor\Modules\Breadcrumbs\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Icons_Manager;
use RoboTheme\inc\elementor\Modules\breadcrumbs\Module;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class RBT_Breadcrumbs extends Widget_Base {

	public function get_name() {
		return 'rbt-breadcrumb';
	}

	public function get_title() {
		return __( 'Breadcrumbs', TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-product-breadcrumbs';
	}

	public function get_categories() {
        return [ RBT_CAT ];
	}

	public function get_keywords() {
		return [ 'breadcrumbs', 'internal links' ];
	}

    public function get_style_depends() {
		return [ 'rbt-breadcrumbs' ];
	}

	protected function register_controls() {
        $this->start_controls_section(
            'section_breadcrumbs_content',
            [
                'label' => __( 'Breadcrumbs', TEXT_DOMAIN ),
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __( 'Alignment', TEXT_DOMAIN ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', TEXT_DOMAIN ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', TEXT_DOMAIN ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', TEXT_DOMAIN ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .breadcrumb' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_breadcrumbs_style',
            [
                'label' => __( 'Breadcrumbs', TEXT_DOMAIN ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typography',
                'selector' => '{{WRAPPER}} .breadcrumb li,{{WRAPPER}} .breadcrumb li a',
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __( 'Icon Color', TEXT_DOMAIN ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .breadcrumb li:after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'link_color',
            [
                'label' => __( 'Link Color', TEXT_DOMAIN ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .breadcrumb li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'link_hover_color',
            [
                'label' => __( 'Color', TEXT_DOMAIN ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .breadcrumb li a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'color_breadcrumb_active',
            [
                'label' => __( 'Active Breadcrumbs Color', TEXT_DOMAIN ),
                'type' => Controls_Manager::COLOR,
                'default' => '#eead16',
                'separator'    => 'before',
                'selectors' => [
                    '{{WRAPPER}} .breadcrumb li.active' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->end_controls_section();
	}

	public function render() {
        $settings = $this->get_settings();
        $align = $settings['align'];

        return  Module::instance()->mj_wp_breadcrumb("ol","breadcrumb","breadcrumb rbt-flex","active","false");
	}
}