<?php

namespace RoboTheme;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

if ( !function_exists('is_plugin_active') ) {
    include_once(ABSPATH . 'wp-admin/includes/plugin.php');
}

class Manager_Modules {

    private $_modules = [];

    private function get_module_data($module_id) {
        return isset($this->_modules[$module_id]) ? $this->_modules[$module_id] : false;
    }

    private function has_module_style($module_id) {

        $module_data = $this->get_module_data($module_id);

        if ( isset($module_data['has_style']) ) {
            return $module_data['has_style'];
        } else {
            return false;
        }

    }

    private function has_module_script($module_id) {

        $module_data = $this->get_module_data($module_id);

        if ( isset($module_data['has_script']) ) {
            return $module_data['has_script'];
        } else {
            return false;
        }

    }

    public function __construct() {

        $modules = [
            'query-control',
            // All widgets //
            'accordion',
            'advanced-button',
            'advanced-heading',
            'advanced-icon-box',
            'advanced-progress-bar',
            'dual-button',
            'member',
            'navbar',
            'post-list',
            'slider',
            'text-list',
            'posts',
            'testimonial',
            'logo-carousel',
            'search',
            'advanced-counter',
            'contact-form-seven',
            'before-after',
            'breadcrumbs',
            'comments',
            'content',
            'end-loop',
            'post-info',
            'short-link',
            'start-loop',
            'thumbnail',
            'title',
            'auther-box',
            'category-list',
            'scroll-but',
			'aparat',
        ];

        if ( is_plugin_active('woocommerce/woocommerce.php') ) {
            $modules[] = 'woocommerce';
        }

        if ( is_plugin_active('contact-form-7/wp-contact-form-7.php') ) {
            $modules[] = 'contact-form-seven';
        }

        foreach ( $modules as $module ) {
            $this->_modules[$module] = require RBT_MODULES . $module . '/module.info.php';
        }

        foreach ( $this->_modules as $module_id => $module_data ) {

            $class_name = str_replace('-', ' ', $module_id);
            $class_name = str_replace(' ', '', ucwords($class_name));
            $class_name = __NAMESPACE__ . '\\inc\elementor\Modules\\' . $class_name . '\Module';
            
            if ( !is_admin() ) {

                // register widget css
                if ( $this->has_module_style($module_id) ) {
                    wp_enqueue_style('rbt-' . $module_id, RBT_URL . 'assets/css/elementor/rbt-' . $module_id . '.css', [], true);
                }

                // register widget javascript
                if ( $this->has_module_script($module_id) ) {
                    wp_register_script('rbt-' . $module_id, RBT_URL . 'assets/js/elementor/rbt-' . $module_id . '.js', ['jquery',], true);
                }

            }

            $class_name::instance();
            
        }

    }

}