<?php
namespace RoboTheme\inc\elementor\Modules\Woocommerce\Widgets;

use elementor\Plugin;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Background;
use WP_Query;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class RBT_Products extends Widget_Base {

	public function get_name() {
		return 'rbt-products';
	}

	public function get_title() {
		return esc_html__( 'Products', TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-products';
	}

	public function get_categories() {
		return [ RBT_CAT ];
	}

	public function get_keywords() {
		return [ 'product', 'woocommerce', 'wc', 'shop' ];
	}

	public function get_script_depends() {
		return [ 'rbt-woocommerce' ];
	}

	public function get_style_depends() {
		return [ 'rbt-woocommerce','rbt-font-icon' ];
	}

	protected function register_controls() {
        $this->register_general_layout_controls();
		$this->register_general_query_controls();
		$this->register_general_additional_controls();
		$this->register_general_style_item_controls();
		$this->register_general_select_field_style_controls();
		$this->register_general_style_image_controls();
		$this->register_general_style_title_controls();
		$this->register_general_style_rating_controls();
		$this->register_general_style_price_controls();
		$this->register_general_style_button_controls();
		$this->register_general_style_quick_view_controls();
		$this->register_general_style_badge_controls();
		$this->register_general_style_pagination_controls();
		
    }

	// content //
	protected function register_general_layout_controls() {
        $this->start_controls_section(
			'section_woocommerce_layout',
			[
				'label' => esc_html__( 'Layout', TEXT_DOMAIN ),
			]
		);

		$this->add_responsive_control(
			'columns',
			[
				'label'          => esc_html__( 'Columns', TEXT_DOMAIN ),
				'type'           => Controls_Manager::SELECT,
				'default'        => '4',
				'tablet_default' => '2',
				'mobile_default' => '1',
				'options'        => [
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				],
			]
		);

		$this->add_responsive_control(
			'item_gap',
			[
				'label'   => esc_html__( 'Column Gap', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 30,
				],
				'range' => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 5,
					],
				],
				// 'selectors' => [
				// 	'{{WRAPPER}} .rbt-wc-products .rbt-wc-products-wrapper.rbt-grid'     => 'margin-left: -{{SIZE}}px',
				// 	'{{WRAPPER}} .rbt-wc-products .rbt-wc-products-wrapper.rbt-grid > *' => 'padding-left: {{SIZE}}px',
				// ],

				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-products-wrapper'     => 'margin-left: -{{SIZE}}px',
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-products-wrapper > *' => 'padding-left: {{SIZE}}px',
				],
			]
		);

		$this->add_responsive_control(
			'row_gap',
			[
				'label'   => esc_html__( 'Row Gap', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SLIDER,
				'default' => [
					'size' => 30,
				],
				'range' => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 5,
					],
				],
				// 'selectors' => [
				// 	'{{WRAPPER}} .rbt-wc-products .rbt-wc-products-wrapper.rbt-grid'     => 'margin-top: -{{SIZE}}px',
				// 	'{{WRAPPER}} .rbt-wc-products .rbt-wc-products-wrapper.rbt-grid > *' => 'margin-top: {{SIZE}}px',
				// ],

				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-products-wrapper'     => 'margin-top: -{{SIZE}}px',
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-products-wrapper > *' => 'margin-top: {{SIZE}}px',
				],
			]
		);

		$this->add_control(
			'alignment',
			[
				'label'   => esc_html__( 'Alignment', TEXT_DOMAIN ),
				'type'    => Controls_Manager::CHOOSE,
				'default' => 'center',
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', TEXT_DOMAIN ),
						'icon'  => 'eicon-h-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', TEXT_DOMAIN ),
						'icon'  => 'eicon-h-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', TEXT_DOMAIN ),
						'icon'  => 'eicon-h-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product .rbt-wc-product-inner' => 'text-align: {{VALUE}}',
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product .star-rating' => 'text-align: {{VALUE}}; display: inline-block !important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name'      => 'image',
				'label'     => esc_html__( 'Image Size', TEXT_DOMAIN ),
				'exclude'   => [ 'custom' ],
				'default'   => 'medium',
			]
		);

		$this->end_controls_section();
    }

	protected function register_general_query_controls() {

		$this->start_controls_section(
			'section_content_query',
			[
				'label' => esc_html__( 'Query', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'source',
			[
				'label'   => _x( 'Source', 'Posts Query Control', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					''        => esc_html__( 'Show All', TEXT_DOMAIN ),
					'by_name' => esc_html__( 'Manual Selection', TEXT_DOMAIN ),
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'product_categories',
			[
				'label'       => esc_html__( 'Categories', TEXT_DOMAIN ),
				'type'        => Controls_Manager::SELECT2,
				'options'     => robotheme_get_category( 'product_cat' ),
				'default'     => [],
				'label_block' => true,
				'multiple'    => true,
				'condition'   => [
					'source'    => 'by_name',
				],
			]
		);

		$this->add_control(
			'exclude_products',
			[
				'label'       => esc_html__( 'Exclude Product(s)', TEXT_DOMAIN ),
				'type'        => Controls_Manager::TEXT,
				'placeholder'     => 'product_id',
				'label_block' => true,
				'description' => __( 'Write product id here, if you want to exclude multiple products so use comma as separator. Such as 1 , 2', '' ),
			]
		);

		$this->add_control(
			'posts_per_page',
			[
				'label'   => esc_html__( 'Product Limit', TEXT_DOMAIN ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 8,
			]
		);

		$this->add_control(
			'show_pagination',
			[
				'label' => esc_html__( 'Pagination', TEXT_DOMAIN ),
				'type'  => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'show_per_page',
			[
				'label'       => esc_html__( 'Show Per Page', TEXT_DOMAIN ),
				'type'        => Controls_Manager::SELECT,
				'default' => '10',
				'options' => [
					'10'      => esc_html__( '10', TEXT_DOMAIN ),
					'25'   => esc_html__( '25', TEXT_DOMAIN ),
					'50' => esc_html__( '50', TEXT_DOMAIN ),
					'100' => esc_html__( '100', TEXT_DOMAIN ),
				],
				'condition' => [
					'show_pagination' => 'yes'
				]
			]
		);

		$this->add_control(
			'show_product_type',
			[
				'label'   => esc_html__( 'Show Product', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'all',
				'options' => [
					'all'      => esc_html__( 'All Products', TEXT_DOMAIN ),
					'onsale'   => esc_html__( 'On Sale', TEXT_DOMAIN ),
					'featured' => esc_html__( 'Featured', TEXT_DOMAIN ),
				],
			]
		);


		$this->add_control(
			'hide_free',
			[
				'label'   => esc_html__( 'Hide Free', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
			]
		);


		$this->add_control(
			'hide_out_stock',
			[
				'label'   => esc_html__( 'Hide Out of Stock', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'   => esc_html__( 'Order by', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => [
					'date'  => esc_html__( 'Date', TEXT_DOMAIN ),
					'price' => esc_html__( 'Price', TEXT_DOMAIN ),
					'sales' => esc_html__( 'Sales', TEXT_DOMAIN ),
					'rand'  => esc_html__( 'Random', TEXT_DOMAIN ),
				],
			]
		);

		$this->add_control(
			'order',
			[
				'label'   => esc_html__( 'Order', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'DESC' => esc_html__( 'Descending', TEXT_DOMAIN ),
					'ASC'  => esc_html__( 'Ascending', TEXT_DOMAIN ),
				],
			
			]
		);


		$this->add_control(
			'orderColumn',
			[
				'label'   => esc_html__( 'Order by', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'separator' => 'before',
				'default' => 'default',
				'options' => [
					'default'  => esc_html__( 'Default', TEXT_DOMAIN ),
					'title'  => esc_html__( 'Title', TEXT_DOMAIN ),
					'excerpt' => esc_html__( 'Description', TEXT_DOMAIN ),
					'categories' => esc_html__( 'Categories', TEXT_DOMAIN ), 
					'price' => esc_html__( 'Price', TEXT_DOMAIN ), 
				],
			]
		);	 

		$this->add_control(
			'orderColumnQry',
			[
				'label'   => esc_html__( 'Order', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'desc',
				'options' => [
					'desc' => esc_html__( 'Descending', TEXT_DOMAIN ),
					'asc'  => esc_html__( 'Ascending', TEXT_DOMAIN ),
				],
				'condition' => [
					'orderColumn!' => 'default',
				]
			]
		);	


		$this->end_controls_section();

    }

	protected function register_general_additional_controls() {

		$this->start_controls_section(
			'section_woocommerce_additional',
			[
				'label' => esc_html__( 'Additional', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'show_badge',
			[
				'label'     => esc_html__( 'Show Badge', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
			]
		);

		$this->add_control(
			'show_title',
			[
				'label'   => esc_html__( 'Title', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'title_tags',
			[
				'label'   => __( 'Title HTML Tag', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h2',
				'options' => [
					'h1'   => 'H1',
					'h2'   => 'H2',
					'h3'   => 'H3',
					'h4'   => 'H4',
					'h5'   => 'H5',
					'h6'   => 'H6',
					'div'  => 'div',
					'span' => 'span',
					'p'    => 'p',
				],
				'condition' => [
					'show_title' => 'yes'
				]
			]
		);

		$this->add_control(
			'show_rating',
			[
				'label'   => esc_html__( 'Rating', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);
		
		$this->add_control(
			'show_price',
			[
				'label'   => esc_html__( 'Price', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_tags',
			[
				'label'     => esc_html__( 'Tags', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'show_cart',
			[
				'label'   => esc_html__( 'Add to Cart', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_quick_view',
			[
				'label'   => esc_html__( 'Quick View', TEXT_DOMAIN ),
				'type'    => Controls_Manager::SWITCHER,
				'default'   => 'yes',
			]
		);

		$this->add_control(
			'show_filter',
			[
				'label'        => esc_html__( 'Show Filter', TEXT_DOMAIN ),
				'type'         => Controls_Manager::SWITCHER,
				'prefix_class' => 'rbt-cart-hide-on-mobile-',
				'default'   => 'yes',
			]
		);

		$this->end_controls_section();

    }

	// style //
	protected function register_general_style_item_controls() {

		$this->start_controls_section(
			'section_style_item',
			[
				'label'     => esc_html__( 'Item', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs( 'tabs_item_style' );

		$this->start_controls_tab(
			'tab_item_normal',
			[
				'label' => esc_html__( 'Normal', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'item_background',
			[
				'label'     => esc_html__( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product .rbt-wc-product-inner' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'item_shadow',
				'selector' => '{{WRAPPER}} .rbt-wc-products .rbt-wc-product .rbt-wc-product-inner',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'item_border',
				'label'       => esc_html__( 'Border Color', TEXT_DOMAIN ),
				'selector'    => '{{WRAPPER}} .rbt-wc-products .rbt-wc-product .rbt-wc-product-inner',
				// 'fields_options' => [
				// 	'border' => [
				// 		'default' => 'solid',
				// 	],
				// 	'width' => [
				// 		'default' => [
				// 			'top' => '1',
				// 			'right' => '1',
				// 			'bottom' => '1',
				// 			'left' => '1',
				// 			'isLinked' => false,
				// 		],
				// 	],
				// 	'color' => [
				// 		'default' => '#eee',
				// 	],
				// ],
				'separator'   => 'before',
			]
		);

		$this->add_responsive_control(
			'item_radius',
			[
				'label'      => esc_html__( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product .rbt-wc-product-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
				],
			]
		);
		


		$this->add_responsive_control(
			'item_padding',
			[
				'label'      => esc_html__( 'Item Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product .rbt-wc-product-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'desc_padding',
			[
				'label'      => esc_html__( 'Description Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product-desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_item_hover',
			[
				'label' => esc_html__( 'Hover', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'item_hover_background',
			[
				'label'     => esc_html__( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product .rbt-wc-product-inner:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_hover_border_color',
			[
				'label'     => esc_html__( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'condition' => [
					'item_border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product .rbt-wc-product-inner:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'item_hover_shadow',
				'selector' => '{{WRAPPER}} .rbt-wc-products .rbt-wc-product .rbt-wc-product-inner:hover',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

    }

	protected function register_general_select_field_style_controls() {

		$this->start_controls_section(
			'section_select_field_style',
			[
				'label'     => esc_html__( 'Select Field', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_filter' => 'yes',
				],
			]
		);

		$this->start_controls_tabs( 'tabs_select_field_style' );

		$this->start_controls_tab(
			'tab_select_field_normal',
			[
				'label' => esc_html__( 'Normal', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'select_field_text_color',
			[
				'label'     => esc_html__( 'Text Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products select'   => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'select_field_background_color',
			[
				'label'     => esc_html__( 'Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products select' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'select_field_border',
				'label'       => esc_html__( 'Border', TEXT_DOMAIN ),
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .rbt-wc-products select',
				'separator'   => 'before',
			]
		);

		$this->add_control(
			'select_field_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-wc-products select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'select_field_padding',
			[
				'label'      => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-wc-products select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'select_text_color',
			[
				'label'     => esc_html__( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'condition' => [
					'select_field_border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .dataTables_length label' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'select_text_typography',
				'label'     => esc_html__( 'Text Typography', TEXT_DOMAIN ),
				//'scheme'    => Schemes\Typography::TYPOGRAPHY_4,
				'selector'  => '{{WRAPPER}} .rbt-wc-products .dataTables_length label',
				'separator' => 'before',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_select_field_focus',
			[
				'label' => esc_html__( 'Focus', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'select_field_hover_border_color',
			[
				'label'     => esc_html__( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'condition' => [
					'select_field_border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products select:focus'   => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

    }

	protected function register_general_style_image_controls() {

		$this->start_controls_section(
			'section_style_image',
			[
				'label' => esc_html__( 'Image', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'image_border',
				'label'    => esc_html__( 'Image Border', TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rbt-wc-products .rbt-wc-product-image',
			]
		);

		$this->add_responsive_control(
			'image_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'    => 'image_shadow',
				'exclude' => [
					'shadow_position',
				],
				'selector' => '{{WRAPPER}} .rbt-wc-products .rbt-wc-product-image',
			]
		);

		$this->end_controls_section();

    }

	protected function register_general_style_title_controls() {

		$this->start_controls_section(
			'section_style_title',
			[
				'label'     => esc_html__( 'Title', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_title' => 'yes',
				],
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product-title .rbt-link-reset' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'hover_title_color',
			[
				'label'     => esc_html__( 'Hover Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product-title:hover .rbt-link-reset' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'title_margin',
			[
				'label'      => esc_html__( 'Margin', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'    => esc_html__( 'Typography', TEXT_DOMAIN ),
				//'scheme'   => Schemes\Typography::TYPOGRAPHY_4,
				'selector' => '{{WRAPPER}} .rbt-wc-products .rbt-wc-product-title',
			]
		);

		$this->end_controls_section();

    }

	protected function register_general_style_rating_controls() {

		$this->start_controls_section(
			'section_style_rating',
			[
				'label'     => esc_html__( 'Rating', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_rating' => 'yes',
				],
			]
		);

		$this->add_control(
			'rating_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#e7e7e7',
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .star-rating:before' => 'color: {{VALUE}};',
				]
			]
		);

		$this->add_control(
			'active_rating_color',
			[
				'label'     => esc_html__( 'Active Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#FFCC00',
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .star-rating span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'rating_margin',
			[
				'label'      => esc_html__( 'Margin', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-wc-products .star-rating' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

    }

	protected function register_general_style_price_controls() {

		$this->start_controls_section(
			'section_style_price',
			[
				'label'     => esc_html__( 'Price', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_price' => 'yes',
				],
			]
		);

		$this->add_control(
			'old_price_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product .rbt-wc-product-price .amount' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'old_price_margin',
			[
				'label'      => esc_html__( 'Margin', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product-price del' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'old_price_typography',
				'label'    => esc_html__( 'Typography', TEXT_DOMAIN ),
				//'scheme'   => Schemes\Typography::TYPOGRAPHY_4,
				'selector' => '{{WRAPPER}} .rbt-wc-products .rbt-wc-product-price del .amount',
			]
		);

		$this->add_control(
			'sale_price_heading',
			[
				'label'     => esc_html__( 'Sale Price', TEXT_DOMAIN ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'sale_price_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product-price, {{WRAPPER}} .rbt-wc-products .rbt-wc-product .rbt-wc-product-price ins .amount' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'sale_price_margin',
			[
				'label'      => esc_html__( 'Margin', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product-price, {{WRAPPER}} .rbt-wc-products .rbt-wc-product-price ins' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'sale_price_typography',
				'label'    => esc_html__( 'Typography', TEXT_DOMAIN ),
				//'scheme'   => Schemes\Typography::TYPOGRAPHY_4,
				'selector' => '{{WRAPPER}} .rbt-wc-products .rbt-wc-product-price, {{WRAPPER}} .rbt-wc-products .rbt-wc-product-price ins .amount, {{WRAPPER}} .rbt-wc-products .rbt-wc-product-price .amount',
			]
		);

		$this->end_controls_section();

    }

	protected function register_general_style_button_controls() {

		$this->start_controls_section(
			'section_style_button',
			[
				'label'     => esc_html__( 'Button', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_cart' => 'yes',
				],
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => esc_html__( 'Normal', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label'     => esc_html__( 'Text Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-add-to-cart a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'background_color',
			[
				'label'     => esc_html__( 'Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-add-to-cart a' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'border',
				'label'       => esc_html__( 'Border', TEXT_DOMAIN ),
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .rbt-wc-products .rbt-wc-add-to-cart a',
				'separator'   => 'before',
			]
		);

		$this->add_control(
			'border_radius',
			[
				'label'      => esc_html__( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-add-to-cart a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'button_padding',
			[
				'label'      => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-add-to-cart a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_control(
			'button_fullwidth',
			[
				'label'     => esc_html__( 'Fullwidth Button', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SWITCHER,
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-add-to-cart a' => 'width: 100%;',
				],
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'button_shadow',
				'selector' => '{{WRAPPER}} .rbt-wc-products .rbt-wc-add-to-cart a',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'button_typography',
				'label'     => esc_html__( 'Typography', TEXT_DOMAIN ),
				//'scheme'    => Schemes\Typography::TYPOGRAPHY_4,
				'selector'  => '{{WRAPPER}} .rbt-wc-products .rbt-wc-add-to-cart a',
				'separator' => 'before',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => esc_html__( 'Hover', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'hover_color',
			[
				'label'     => esc_html__( 'Text Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-add-to-cart a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_background_hover_color',
			[
				'label'     => esc_html__( 'Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-add-to-cart a:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_hover_border_color',
			[
				'label'     => esc_html__( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'condition' => [
					'border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-add-to-cart a:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

    }

	protected function register_general_style_quick_view_controls() {

		$this->start_controls_section(
			'section_style_quick_view',
			[
				'label'     => esc_html__( 'Quick View Button', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_quick_view' => 'yes',
				],
			]
		);

		$this->start_controls_tabs( 'tabs_quick_view_style' );

		$this->start_controls_tab(
			'tab_quick_view_normal',
			[
				'label' => esc_html__( 'Normal', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'quick_view_text_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-quick-view a i' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'quick_view_background_color',
			[
				'label'     => esc_html__( 'Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-quick-view a' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'quick_view_border',
				'label'       => esc_html__( 'Border', TEXT_DOMAIN ),
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .rbt-wc-products .rbt-quick-view a',
				'separator'   => 'before',
			]
		);

		$this->add_control(
			'quick_view_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-wc-products .rbt-quick-view a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'quick_view_padding',
			[
				'label'      => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-wc-products .rbt-quick-view a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'quick_view_shadow',
				'selector' => '{{WRAPPER}} .rbt-wc-products .rbt-quick-view a',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'quick_view_typography',
				'selector'  => '{{WRAPPER}} .rbt-wc-products .rbt-quick-view a i',
				'separator' => 'before',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_quick_view_hover',
			[
				'label' => esc_html__( 'Hover', TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'quick_view_hover_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-quick-view a:hover i' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'quick_view_background_hover_color',
			[
				'label'     => esc_html__( 'Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-quick-view a:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'quick_view_hover_border_color',
			[
				'label'     => esc_html__( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'condition' => [
					'quick_view_border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-quick-view a:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

    }

	protected function register_general_style_badge_controls() {

		$this->start_controls_section(
			'section_style_badge',
			[
				'label'     => esc_html__( 'Badge', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'badge_text_color',
			[
				'label'     => esc_html__( 'Text Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product .rbt-badge' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'badge_bg_color',
			[
				'label'     => esc_html__( 'Background Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product .rbt-badge' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'badge_padding',
			[
				'label'      => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product .rbt-badge' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'badge_margin',
			[
				'label'      => esc_html__( 'Margin', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product .rbt-badge' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'        => 'badge_border',
				'label'       => esc_html__( 'Border', TEXT_DOMAIN ),
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .rbt-wc-products .rbt-wc-product .rbt-badge',
				'separator'   => 'before',
			]
		);

		$this->add_control(
			'badge_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', TEXT_DOMAIN ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rbt-wc-products .rbt-wc-product .rbt-badge' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'badge_shadow',
				'selector' => '{{WRAPPER}} .rbt-wc-products .rbt-wc-product .rbt-badge',
				'separator' => 'before',
			]
		);

		$this->end_controls_section();

    }

	protected function register_general_style_pagination_controls() {

		$this->start_controls_section(
			'section_style_pagination',
			[
				'label'     => esc_html__( 'Pagination', TEXT_DOMAIN ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);
	
		$this->start_controls_tabs( 'tabs_pagination_style' );
	
		$this->start_controls_tab(
			'tab_pagination_normal',
			[
				'label' => esc_html__( 'Normal', TEXT_DOMAIN ),
			]
		);
	
		$this->add_control(
			'pagination_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.rbt-pagination li a, {{WRAPPER}} ul.rbt-pagination li span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pagination_bg_color',
			[
				'label'     => esc_html__( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.rbt-pagination li a' => 'background: {{VALUE}};',
				],
			]
		);
	
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'pagination_border',
				'label'    => esc_html__( 'Border', TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} ul.rbt-pagination li a',
			]
		);
	
		$this->add_responsive_control(
			'pagination_offset',
			[
				'label'     => esc_html__( 'Offset', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .rbt-pagination' => 'margin-top: {{SIZE}}px;',
				],
			]
		);
	
		$this->add_responsive_control(
			'pagination_space',
			[
				'label'     => esc_html__( 'Spacing', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .rbt-pagination'     => 'margin-left: {{SIZE}}px;',
					'{{WRAPPER}} .rbt-pagination > *' => 'padding-left: {{SIZE}}px;',
				],
			]
		);
	
		$this->add_responsive_control(
			'pagination_padding',
			[
				'label'     => esc_html__( 'Padding', TEXT_DOMAIN ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} ul.rbt-pagination li a' => 'padding: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				],
			]
		);
	
		$this->add_responsive_control(
			'pagination_radius',
			[
				'label'     => esc_html__( 'Radius', TEXT_DOMAIN ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} ul.rbt-pagination li a' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				],
			]
		);
	
		$this->add_responsive_control(
			'pagination_arrow_size',
			[
				'label'     => esc_html__( 'Arrow Size', TEXT_DOMAIN ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} ul.rbt-pagination li a svg' => 'height: {{SIZE}}px; width: auto;',
				],
			]
		);
	
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'pagination_typography',
				'label'    => esc_html__( 'Typography', TEXT_DOMAIN ),
				//'scheme'   => Schemes\Typography::TYPOGRAPHY_4,
				'selector' => '{{WRAPPER}} ul.rbt-pagination li a, {{WRAPPER}} ul.rbt-pagination li span',
			]
		);
	
		$this->end_controls_tab();
	
		$this->start_controls_tab(
			'tab_pagination_hover',
			[
				'label' => esc_html__( 'Hover', TEXT_DOMAIN ),
			]
		);
	
		$this->add_control(
			'pagination_hover_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.rbt-pagination li a:hover' => 'color: {{VALUE}};',
				],
			]
		);
	
		$this->add_control(
			'pagination_hover_border_color',
			[
				'label'     => esc_html__( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.rbt-pagination li a:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pagination_hover_bg_color',
			[
				'label'     => esc_html__( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.rbt-pagination li a:hover' => 'background: {{VALUE}};',
				],
			]
		);
	
		$this->end_controls_tab();
	
		$this->start_controls_tab(
			'tab_pagination_active',
			[
				'label' => esc_html__( 'Active', TEXT_DOMAIN ),
			]
		);
	
		$this->add_control(
			'pagination_active_color',
			[
				'label'     => esc_html__( 'Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.rbt-pagination li.rbt-active a' => 'color: {{VALUE}};',
				],
			]
		);
	
		$this->add_control(
			'pagination_active_bg_color',
			[
				'label'     => esc_html__( 'Background', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.rbt-pagination li.rbt-active a' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pagination_active_border_color',
			[
				'label'     => esc_html__( 'Border Color', TEXT_DOMAIN ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.rbt-pagination li.rbt-active a' => 'border-color: {{VALUE}};',
				],
			]
		);
	
		$this->end_controls_tab();
		$this->end_controls_tabs();		
		$this->end_controls_section();

    }


















	
    // render //
	public function render_image() {
		$settings = $this->get_settings_for_display();
		?>
		<div class="rbt-wc-product-image rbt-position-relative">
			<a href="<?php the_permalink(); ?>">
				<img src="<?php echo wp_get_attachment_image_url(get_post_thumbnail_id(), $settings['image_size']); ?>" alt="<?php echo get_the_title(); ?>">
			</a>

        	<?php if ('yes' == $settings['show_cart']) : ?>
            	<div class="rbt-wc-add-to-cart">
					<?php woocommerce_template_loop_add_to_cart();?>
				</div>
			<?php endif; ?>
		</div>
		<?php
	}

	public function render_quick_view($product_id){
		$settings = $this->get_settings_for_display();
		if ( 'yes' == $settings['show_quick_view'] ) : ?>
            <div class="rbt-quick-view">
				<?php wp_nonce_field( 'ajax-ep-wc-product-nonce', 'rbt-wc-product-modal-sc' ); ?>
                <input type="hidden" class="rbt_modal_spinner_message" value="<?php echo __( 'Please wait...', TEXT_DOMAIN ); ?>"/>
				<a href="javascript:void(0)" data-id="<?php echo absint( $product_id ); ?>" rbt-tooltip="title: <?php echo __( 'Quick View', TEXT_DOMAIN ); ?>; pos: left;">
					<i class="ep-eye"></i>
				</a>
            </div>
		<?php endif;
	}

	public function render_header() {

		$settings = $this->get_settings_for_display();

		$this->add_render_attribute('wc-products', 'class', 'rbt-wc-products');

		?>
		<div <?php echo $this->get_render_attribute_string( 'wc-products' ); ?> >
		<?php

        if($settings['show_filter'] == 'yes') {
			do_action( 'woocommerce_before_shop_loop' );
		} 
 
	}

	public function render_footer() {
		?> 
		</div>
		<?php
	}

	public function render_query() {
		$settings = $this->get_settings_for_display();

		if ( get_query_var('paged') ) { $paged = get_query_var('paged'); } 
		elseif ( get_query_var('page') ) { $paged = get_query_var('page'); } 
		else { $paged = 1; }

		$exclude_products = ($settings['exclude_products']) ? explode(',', $settings['exclude_products']) : [];

		$query_args = array(
			'post_type'           => 'product',
			'post_status'         => 'publish',
			'posts_per_page'      => $settings['posts_per_page'],
			'ignore_sticky_posts' => 1,
			'meta_query'          => [],
			'tax_query'           => [ 'relation' => 'AND' ],
			'paged'               => $paged,
			'order'               => $settings['order'],
			'post__not_in'        => $exclude_products,
		);

		$product_visibility_term_ids = wc_get_product_visibility_term_ids();

		
		if ( 'by_name' === $settings['source'] and !empty($settings['product_categories']) ) {			  
			$query_args['tax_query'][] = [
				'taxonomy'           => 'product_cat',
				'field'              => 'slug',
				'terms'              => $settings['product_categories'],
				'post__not_in'       => $exclude_products,
			];
		}

		if ( 'yes' == $settings['hide_free'] ) {
			$query_args['meta_query'][] = [
				'key'     => '_price',
				'value'   => 0,
				'compare' => '>',
				'type'    => 'DECIMAL',
			];
		}

		if ( 'yes' == $settings['hide_out_stock'] ) {
			$query_args['tax_query'][] = [
				[
					'taxonomy' => 'product_visibility',
					'field'    => 'term_taxonomy_id',
					'terms'    => $product_visibility_term_ids['outofstock'],
					'operator' => 'NOT IN',
				],
			]; // WPCS: slow query ok.
		}

		switch ( $settings['show_product_type'] ) {
			case 'featured':
				$query_args['tax_query'][] = [
					'taxonomy' => 'product_visibility',
					'field'    => 'term_taxonomy_id',
					'terms'    => $product_visibility_term_ids['featured'],
				];
				break;
			case 'onsale':
				$product_ids_on_sale    = wc_get_product_ids_on_sale();
				$product_ids_on_sale[]  = 0;
				$query_args['post__in'] = $product_ids_on_sale;
				break;
		}


		switch ( $settings['orderby'] ) {
			case 'price':
				$query_args['meta_key'] = '_price'; // WPCS: slow query ok.
				$query_args['orderby']  = 'meta_value_num';
				break;
			case 'rand':
				$query_args['orderby'] = 'rand';
				break;
			case 'sales':
				$query_args['meta_key'] = 'total_sales'; // WPCS: slow query ok.
				$query_args['orderby']  = 'meta_value_num';
				break;
			default:
				$query_args['orderby'] = 'date';
		}

		return new WP_Query($query_args);
	}

	public function render_loop_item() {
		$settings = $this->get_settings_for_display();
		$id       = 'rbt-wc-product-' . $this->get_id();

		$wp_query = $this->render_query();

		if($wp_query->have_posts()) {

			$this->add_render_attribute('wc-products-wrapper', 'rbt-grid', '');

			$this->add_render_attribute(
				[
					'wc-products-wrapper' => [
						'class' => [
							'rbt-wc-products-wrapper',
							'inline-flex flex-wrap',
							'rbt-grid-medium',
							'rbt-child-width-1-1',
							'rbt-child-width-1-2'.'@s',
							'rbt-child-width-1-'. $settings['columns'] .'@m',
						],
						'id' => esc_attr( $id ),
					],
				]
			);

			?>
			<div <?php echo $this->get_render_attribute_string( 'wc-products-wrapper' ); ?>>
			<?php	
			
				$this->add_render_attribute( 'wc-product', 'class', 'rbt-wc-product' );

				$this->add_render_attribute( 'rbt-wc-product-title', 'class', 'rbt-wc-product-title' );

				while ( $wp_query->have_posts() ) : $wp_query->the_post(); global $post, $product; ?>

					<div <?php echo $this->get_render_attribute_string( 'wc-product' ); ?>>
						<div class="rbt-wc-product-inner">

							<?php if ( $settings['show_badge'] and ! $product->is_in_stock() ) : ?>
								<div class="rbt-badge rbt-position-top-left rbt-position-small">
									<?php //woocommerce_show_product_loop_sale_flash(); ?>
									<?php echo apply_filters( 'woocommerce_product_is_in_stock', '<span class="rbt-onsale">' . esc_html__( 'Sold Out!', 'woocommerce' ) . '</span>', $post, $product ); ?>
								</div>
							<?php elseif ( $settings['show_badge'] and $product->is_on_sale() ) : ?>
								<div class="rbt-badge rbt-position-top-left rbt-position-small">
									<?php //woocommerce_show_product_loop_sale_flash(); ?>
									<?php echo apply_filters( 'woocommerce_sale_flash', '<span class="rbt-onsale">' . esc_html__( 'Sale!', 'woocommerce' ) . '</span>', $post, $product ); ?>
								</div>
							<?php endif; ?>

						<?php $this->render_image(); ?>

						<?php $this->render_quick_view($product->get_id())?>

							<div class="rbt-wc-product-desc">
								<?php if ( 'yes' == $settings['show_title']) : ?>
									<<?php echo esc_html($settings['title_tags']); ?> <?php echo $this->get_render_attribute_string('rbt-wc-product-title'); ?>>
										<a href="<?php the_permalink(); ?>" class="rbt-link-reset">
										<?php the_title(); ?>
									</a>
								</<?php echo esc_html($settings['title_tags']); ?>>
								<?php endif; ?>

								<?php if (('yes' == $settings['show_price']) or ('yes' == $settings['show_rating'])) : ?>
									<?php if ( 'yes' == $settings['show_price']) : ?>
										<span class="rbt-wc-product-price">
											<?php woocommerce_template_single_price(); ?>
										</span>
									<?php endif; ?>
										
								<?php if ('yes' == $settings['show_rating']) : ?>
										<div class="rbt-wc-rating">
											<?php woocommerce_template_loop_rating(); ?>
										</div>
									<?php endif; ?>
								<?php endif; ?>
							</div>

						</div>
					</div>
					
				<?php endwhile;	?>

			</div>
			<?php

			if ($settings['show_pagination']) { ?>
				<div class="rbt-num-pagination">
					<?php rbt_post_pagination($wp_query); ?>
				</div>
				<?php
			}

			wp_reset_postdata();
			
		} else {
			echo '<div class="rbt-alert-warning" rbt-alert>' . esc_html__( 'Ops! There no product to display.', TEXT_DOMAIN ) .'<div>';
		}
	}

	public function render_loop() {
		$settings = $this->get_settings_for_display();
		$id       = 'rbt-wc-product-' . $this->get_id();

		if(have_posts()) {

			$this->add_render_attribute('wc-products-wrapper', 'rbt-grid', '');

			$this->add_render_attribute(
				[
					'wc-products-wrapper' => [
						'class' => [
							'rbt-wc-products-wrapper',
							'inline-flex flex-wrap',
							'rbt-grid-medium',
							'rbt-child-width-1-'. $settings['columns_mobile'],
							'rbt-child-width-1-'. $settings['columns_tablet'] .'@s',
							'rbt-child-width-1-'. $settings['columns'] .'@m',
						],
						'id' => esc_attr( $id ),
					],
				]
			);

			?>
			<div <?php echo $this->get_render_attribute_string( 'wc-products-wrapper' ); ?>>
			<?php	
			
				$this->add_render_attribute( 'wc-product', 'class', 'rbt-wc-product' );

				$this->add_render_attribute( 'rbt-wc-product-title', 'class', 'rbt-wc-product-title' );

				while ( have_posts() ) : the_post(); global $post, $product; ?>

					<div <?php echo $this->get_render_attribute_string( 'wc-product' ); ?>>
						<div class="rbt-wc-product-inner">

							<?php if ( $settings['show_badge'] and ! $product->is_in_stock() ) : ?>
								<div class="rbt-badge rbt-position-top-left rbt-position-small">
									<?php //woocommerce_show_product_loop_sale_flash(); ?>
									<?php echo apply_filters( 'woocommerce_product_is_in_stock', '<span class="rbt-onsale">' . esc_html__( 'Sold Out!', 'woocommerce' ) . '</span>', $post, $product ); ?>
								</div>
							<?php elseif ( $settings['show_badge'] and $product->is_on_sale() ) : ?>
								<div class="rbt-badge rbt-position-top-left rbt-position-small">
									<?php //woocommerce_show_product_loop_sale_flash(); ?>
									<?php echo apply_filters( 'woocommerce_sale_flash', '<span class="rbt-onsale">' . esc_html__( 'Sale!', 'woocommerce' ) . '</span>', $post, $product ); ?>
								</div>
							<?php endif; ?>

						<?php $this->render_image(); ?>

						<?php $this->render_quick_view($product->get_id())?>

							<div class="rbt-wc-product-desc">
								<?php if ( 'yes' == $settings['show_title']) : ?>
									<<?php echo esc_html($settings['title_tags']); ?> <?php echo $this->get_render_attribute_string('rbt-wc-product-title'); ?>>
										<a href="<?php the_permalink(); ?>" class="rbt-link-reset">
										<?php the_title(); ?>
									</a>
								</<?php echo esc_html($settings['title_tags']); ?>>
								<?php endif; ?>

								<?php if (('yes' == $settings['show_price']) or ('yes' == $settings['show_rating'])) : ?>
									<?php if ( 'yes' == $settings['show_price']) : ?>
										<span class="rbt-wc-product-price">
											<?php woocommerce_template_single_price(); ?>
										</span>
									<?php endif; ?>
										
								<?php if ('yes' == $settings['show_rating']) : ?>
										<div class="rbt-wc-rating">
											<?php woocommerce_template_loop_rating(); ?>
										</div>
									<?php endif; ?>
								<?php endif; ?>
							</div>

						</div>
					</div>
					
				<?php endwhile;	?>

			</div>
			<?php

			the_posts_pagination(
				array(
					'mid_size' => 2,
					'prev_text' => ('<i class="fas fa-angle-double-right"></i>'),
					'next_text' => ('<i class="fas fa-angle-double-left"></i>'),
				)
			);

			wp_reset_postdata();
			
		}

	}

	public function render() {
		$editor = Plugin::$instance->editor->is_edit_mode();

		$this->render_header();

		if( $editor ) {
			$this->render_loop_item();
		}else{
			if( is_shop() ) {
				$this->render_loop_item();
			}elseif( is_product_category() ){
				$this->render_loop();
			}
		}

		$this->render_footer();
	}

}