<?php
namespace RoboTheme\inc\elementor\Modules\Woocommerce\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RBT_Product_Title extends Widget_Base {

    public function get_name() {
        return 'rbt-product-title';
    }

    public function get_title() {
        return __( 'Product Title', TEXT_DOMAIN );
    }

    public function get_icon() {
        return 'eicon-post-title';
    }

    public function get_categories() {
        return [ RBT_CAT ];
    }

    public function get_keywords() {
        return [ 'title', 'heading', 'post' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'tags_setting',
            [
                'label' => __( 'Setting', TEXT_DOMAIN ),
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => __( 'Title Tag', TEXT_DOMAIN ),
                'type' => Controls_Manager::SELECT,
                'default' => 'h1',
                'options' => rbt_title_tags(),
            ]
        );
        $this->add_responsive_control(
            'text_align',
            [
                'label' => __( 'Alignment', TEXT_DOMAIN ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', TEXT_DOMAIN ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', TEXT_DOMAIN ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', TEXT_DOMAIN ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'right',
                'toggle' => true,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typography',
                'label' => __( 'Typography', TEXT_DOMAIN ),
                'selector' => '{{WRAPPER}} .title',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Title Color', TEXT_DOMAIN ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title' => 'color: {{VALUE}}',
                ],
            ]
        );


        $this->end_controls_section();

    }

    protected function render() {

        $settings = $this->get_settings();
        $title_tag = $settings['title_tag'];
        $text_align = $settings['text_align'];


        echo "<$title_tag class='title text-$text_align'>". get_the_title() . "</$title_tag>";

    }
}