<?php

namespace RoboTheme\inc\elementor\Modules\Member\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;
use Elementor\Icons_Manager;

use RoboTheme\inc\elementor\Modules\Member\Skins;

if ( !defined('ABSPATH') ) {
    exit; // Exit if accessed directly.
}

class RBT_Member extends Widget_Base {
    public function get_name() {
        return 'rbt-member';
    }

    public function get_title() {
        return esc_html__('Member', TEXT_DOMAIN);
    }

    public function get_icon() {
        return 'eicon-person';
    }

    public function get_categories() {
        return [RBT_CAT];
    }

    public function get_keywords() {
        return ['member', 'team', 'experts'];
    }

    public function get_style_depends() {
        return ['rbt-member'];
    }

    protected function register_skins() {
        $this->add_skin(new Skins\Skin_Band($this));
        $this->add_skin(new Skins\Skin_Calm($this));
        $this->add_skin(new Skins\Skin_Ekip($this));
        $this->add_skin(new Skins\Skin_Phaedra($this));
        $this->add_skin(new Skins\Skin_Partait($this));
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__('Layout', TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'photo',
            [
                'label'   => esc_html__('Choose Photo', TEXT_DOMAIN),
                'type'    => Controls_Manager::MEDIA,
                'dynamic' => ['active' => true],
                'default' => [
                    'url' => RBT_ASSETS_URL . 'images/member.svg',
                ],
            ]
        );

        $this->add_control(
            'member_alternative_photo',
            [
                'label' => esc_html__('Alternative Photo', TEXT_DOMAIN),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'alternative_photo',
            [
                'label'     => esc_html__('Choose Photo', TEXT_DOMAIN),
                'type'      => Controls_Manager::MEDIA,
                'dynamic'   => ['active' => true],
                'default'   => [
                    'url' => RBT_ASSETS_URL . 'images/member.svg',
                ],
                'condition' => [
                    'member_alternative_photo' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'image_mask_popover',
            [
                'label'        => __('Image Mask', TEXT_DOMAIN),
                'type'         => Controls_Manager::POPOVER_TOGGLE,
                'render_type'  => 'ui',
                'return_value' => 'yes',
            ]
        );

        $this->start_popover();

        $this->add_control(
            'image_mask_shape',
            [
                'label'     => __('Masking Shape', TEXT_DOMAIN),
                'title'     => __('Masking Shape', TEXT_DOMAIN),
                'type'      => Controls_Manager::CHOOSE,
                'default'   => 'default',
                'options'   => [
                    'default' => [
                        'title' => __('Default Shapes', TEXT_DOMAIN),
                        'icon'  => 'eicon-star',
                    ],
                    'custom'  => [
                        'title' => __('Custom Shape', TEXT_DOMAIN),
                        'icon'  => 'eicon-image-bold',
                    ],
                ],
                'toggle'    => false,
                'condition' => [
                    'image_mask_popover' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'image_mask_shape_default',
            [
                'label'          => _x('Default', 'Mask Image', TEXT_DOMAIN),
                'label_block'    => true,
                'show_label'     => false,
                'type'           => Controls_Manager::SELECT,
                'default'        => '',
                'options'        => rbt_mask_shapes(),
                'selectors'      => [
                    '{{WRAPPER}} .rbt-image-mask' => '-webkit-mask-image: url({{VALUE}}); mask-image: url({{VALUE}});',
                ],
                'condition'      => [
                    'image_mask_popover' => 'yes',
                    'image_mask_shape'   => 'default',
                ],
                'style_transfer' => true,
            ]
        );

        $this->add_control(
            'image_mask_shape_custom',
            [
                'label'      => _x('Custom Shape', 'Mask Image', TEXT_DOMAIN),
                'type'       => Controls_Manager::MEDIA,
                'show_label' => false,
                'selectors'  => [
                    '{{WRAPPER}} .rbt-image-mask' => '-webkit-mask-image: url({{URL}}); mask-image: url({{URL}});',
                ],
                'condition'  => [
                    'image_mask_popover' => 'yes',
                    'image_mask_shape'   => 'custom',
                ],
            ]
        );

        $this->add_control(
            'image_mask_shape_position',
            [
                'label'                => __('Position', TEXT_DOMAIN),
                'type'                 => Controls_Manager::SELECT,
                'default'              => 'center-center',
                'options'              => [
                    'center-center' => __('Center Center', TEXT_DOMAIN),
                    'center-left'   => __('Center Left', TEXT_DOMAIN),
                    'center-right'  => __('Center Right', TEXT_DOMAIN),
                    'top-center'    => __('Top Center', TEXT_DOMAIN),
                    'top-left'      => __('Top Left', TEXT_DOMAIN),
                    'top-right'     => __('Top Right', TEXT_DOMAIN),
                    'bottom-center' => __('Bottom Center', TEXT_DOMAIN),
                    'bottom-left'   => __('Bottom Left', TEXT_DOMAIN),
                    'bottom-right'  => __('Bottom Right', TEXT_DOMAIN),
                ],
                'selectors_dictionary' => [
                    'center-center' => 'center center',
                    'center-left'   => 'center left',
                    'center-right'  => 'center right',
                    'top-center'    => 'top center',
                    'top-left'      => 'top left',
                    'top-right'     => 'top right',
                    'bottom-center' => 'bottom center',
                    'bottom-left'   => 'bottom left',
                    'bottom-right'  => 'bottom right',
                ],
                'selectors'            => [
                    '{{WRAPPER}} .rbt-image-mask' => '-webkit-mask-position: {{VALUE}}; mask-position: {{VALUE}};',
                ],
                'condition'            => [
                    'image_mask_popover' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'image_mask_shape_size',
            [
                'label'     => __('Size', TEXT_DOMAIN),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'contain',
                'options'   => [
                    'auto'    => __('Auto', TEXT_DOMAIN),
                    'cover'   => __('Cover', TEXT_DOMAIN),
                    'contain' => __('Contain', TEXT_DOMAIN),
                    'initial' => __('Custom', TEXT_DOMAIN),
                ],
                'selectors' => [
                    '{{WRAPPER}} .rbt-image-mask' => '-webkit-mask-size: {{VALUE}}; mask-size: {{VALUE}};',
                ],
                'condition' => [
                    'image_mask_popover' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'image_mask_shape_custom_size',
            [
                'label'      => _x('Custom Size', 'Mask Image', TEXT_DOMAIN),
                'type'       => Controls_Manager::SLIDER,
                'responsive' => true,
                'size_units' => ['px', 'em', '%', 'vw'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'vw' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'size' => 100,
                    'unit' => '%',
                ],
                'required'   => true,
                'selectors'  => [
                    '{{WRAPPER}} .rbt-image-mask' => '-webkit-mask-size: {{SIZE}}{{UNIT}}; mask-size: {{SIZE}}{{UNIT}};',
                ],
                'condition'  => [
                    'image_mask_popover'    => 'yes',
                    'image_mask_shape_size' => 'initial',
                ],
            ]
        );

        $this->add_control(
            'image_mask_shape_repeat',
            [
                'label'                => __('Repeat', TEXT_DOMAIN),
                'type'                 => Controls_Manager::SELECT,
                'default'              => 'no-repeat',
                'options'              => [
                    'repeat'          => __('Repeat', TEXT_DOMAIN),
                    'repeat-x'        => __('Repeat-x', TEXT_DOMAIN),
                    'repeat-y'        => __('Repeat-y', TEXT_DOMAIN),
                    'space'           => __('Space', TEXT_DOMAIN),
                    'round'           => __('Round', TEXT_DOMAIN),
                    'no-repeat'       => __('No-repeat', TEXT_DOMAIN),
                    'repeat-space'    => __('Repeat Space', TEXT_DOMAIN),
                    'round-space'     => __('Round Space', TEXT_DOMAIN),
                    'no-repeat-round' => __('No-repeat Round', TEXT_DOMAIN),
                ],
                'selectors_dictionary' => [
                    'repeat'          => 'repeat',
                    'repeat-x'        => 'repeat-x',
                    'repeat-y'        => 'repeat-y',
                    'space'           => 'space',
                    'round'           => 'round',
                    'no-repeat'       => 'no-repeat',
                    'repeat-space'    => 'repeat space',
                    'round-space'     => 'round space',
                    'no-repeat-round' => 'no-repeat round',
                ],
                'selectors'            => [
                    '{{WRAPPER}} .rbt-image-mask' => '-webkit-mask-repeat: {{VALUE}}; mask-repeat: {{VALUE}};',
                ],
                'condition'            => [
                    'image_mask_popover' => 'yes',
                ],
            ]
        );


        $this->end_popover();

        $this->add_control(
            'name',
            [
                'label'       => esc_html__('Name', TEXT_DOMAIN),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('John Doe', TEXT_DOMAIN),
                'placeholder' => esc_html__('Member Name', TEXT_DOMAIN),
                'dynamic'     => ['active' => true],
            ]
        );

        $this->add_control(
            'role',
            [
                'label'       => esc_html__('Role', TEXT_DOMAIN),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('Managing Director', TEXT_DOMAIN),
                'placeholder' => esc_html__('Member Role', TEXT_DOMAIN),
                'dynamic'     => ['active' => true],
            ]
        );

        $this->add_control(
            'description_text',
            [
                'label'       => esc_html__('Description', TEXT_DOMAIN),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => esc_html__('Type here some info about this team member, the man very important person of our company.', TEXT_DOMAIN),
                'placeholder' => esc_html__('Member Description', TEXT_DOMAIN),
                'rows'        => 10,
                'condition'   => ['_skin' => ['', 'rbt-partait', 'rbt-band']],
                'dynamic'     => ['active' => true],
            ]
        );

        $this->add_control(
            'member_social_icon',
            [
                'label'   => esc_html__('Social Icon', TEXT_DOMAIN),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();






















































        
        $this->start_controls_section(
            'section_content_social_link',
            [
                'label'     => esc_html__('Social Icon', TEXT_DOMAIN),
                'condition' => ['member_social_icon' => 'yes'],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'social_link_title',
            [
                'label'   => esc_html__('Title', TEXT_DOMAIN),
                'type'    => Controls_Manager::TEXT,
                'default' => 'Facebook',
            ]
        );

        $repeater->add_control(
            'social_link',
            [
                'label'   => esc_html__('Link', TEXT_DOMAIN),
                'type'    => Controls_Manager::TEXT,
                'default' => esc_html__('http://www.facebook.com/rbthemes/', TEXT_DOMAIN),
            ]
        );

        $repeater->add_control(
            'social_share_icon',
            [
                'label'            => esc_html__('Choose Icon', TEXT_DOMAIN),
                'type'             => Controls_Manager::ICONS,
                'fa4compatibility' => 'social_icon',
            ]
        );

        $repeater->add_control(
            'icon_background',
            [
                'label'     => esc_html__('Icon Background', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-icons {{CURRENT_ITEM}}' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    '_skin!' => 'rbt-band',
                ],
            ]
        );

        $repeater->add_control(
            'icon_color',
            [
                'label'     => esc_html__('Icon Color', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-icons {{CURRENT_ITEM}}' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    '_skin!' => 'rbt-band',
                ],
            ]
        );

        $this->add_control(
            'social_link_list',
            [
                'type'        => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default'     => [
                    [
                        'social_link'       => esc_html__('http://www.facebook.com/rbthemes/', TEXT_DOMAIN),
                        'social_share_icon' => ['value' => 'fab fa-facebook-f', 'library' => 'fa-brands'],
                        'social_link_title' => 'Facebook',
                    ],
                    [
                        'social_link'       => esc_html__('http://www.twitter.com/rbthemes/', TEXT_DOMAIN),
                        'social_share_icon' => ['value' => 'fab fa-twitter', 'library' => 'fa-brands'],
                        'social_link_title' => 'Twitter',
                    ],
                    [
                        'social_link'       => esc_html__('http://www.linkedin.com/rbthemes/', TEXT_DOMAIN),
                        'social_share_icon' => ['value' => 'fab fa-linkedin-in', 'library' => 'fa-brands'],
                        'social_link_title' => 'Linkedin',
                    ],
                ],
                'title_field' => '{{{ social_link_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style',
            [
                'label'     => esc_html__('Member', TEXT_DOMAIN),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    '_skin' => ['', 'rbt-band'],
                ],
            ]
        );

        $this->add_control(
            'band_item_background_color',
            [
                'label'     => __('Background Color', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-member.rbt-member-skin-band .rbt-member-item-wrapper' => 'background: {{VALUE)}};',
                ],
                'condition' => [
                    '_skin' => ['rbt-band'],
                ],
            ]
        );

        $this->add_control(
            'band_overlay_color',
            [
                'label'     => __('Overlay Color', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-member.rbt-member-skin-band .rbt-member-photo:before' => 'background: {{VALUE)}};',
                ],
                'condition' => [
                    '_skin' => ['rbt-band'],
                ],
            ]
        );

        $this->add_responsive_control(
            'text_align',
            [
                'label'     => esc_html__('Text Alignment', TEXT_DOMAIN),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'    => [
                        'title' => esc_html__('Left', TEXT_DOMAIN),
                        'icon'  => 'fas fa-align-left',
                    ],
                    'center'  => [
                        'title' => esc_html__('Center', TEXT_DOMAIN),
                        'icon'  => 'fas fa-align-center',
                    ],
                    'right'   => [
                        'title' => esc_html__('Right', TEXT_DOMAIN),
                        'icon'  => 'fas fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__('Justified', TEXT_DOMAIN),
                        'icon'  => 'fas fa-align-justify',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rbt-member' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'desc_padding',
            [
                'label'      => esc_html__('Description Padding', TEXT_DOMAIN),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-member .rbt-member-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_photo',
            [
                'label' => esc_html__('Photo', TEXT_DOMAIN),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('tabs_photo_style');

        $this->start_controls_tab(
            'tab_photo_normal',
            [
                'label' => esc_html__('Normal', TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'photo_background',
            [
                'label'     => esc_html__('Background', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-photo' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'photo_border',
                'label'       => esc_html__('Border', TEXT_DOMAIN),
                'placeholder' => '1px',
                'default'     => '1px',
                'selector'    => '{{WRAPPER}} .rbt-member .rbt-member-photo',
                'separator'   => 'before',
            ]
        );

        $this->add_control(
            'photo_border_radius',
            [
                'label'      => esc_html__('Border Radius', TEXT_DOMAIN),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-member .rbt-member-photo' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
                ],
            ]
        );

        $this->add_control(
            'photo_opacity',
            [
                'label'     => esc_html__('Opacity (%)', TEXT_DOMAIN),
                'type'      => Controls_Manager::SLIDER,
                'default'   => [
                    'size' => 1,
                ],
                'range'     => [
                    'px' => [
                        'max'  => 1,
                        'min'  => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-photo img' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_control(
            'photo_spacing',
            [
                'label'     => esc_html__('Spacing', TEXT_DOMAIN),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-photo' => 'margin-bottom: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    '_skin!' => ['rbt-band'],
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_photo_hover',
            [
                'label' => esc_html__('Hover', TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'photo_hover_border_color',
            [
                'label'     => esc_html__('Border Color', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'condition' => [
                    'border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-photo:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'photo_hover_opacity',
            [
                'label'     => esc_html__('Opacity (%)', TEXT_DOMAIN),
                'type'      => Controls_Manager::SLIDER,
                'default'   => [
                    'size' => 1,
                ],
                'range'     => [
                    'px' => [
                        'max'  => 1,
                        'min'  => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-photo:hover img' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_control(
            'photo_hover_animation',
            [
                'label'   => esc_html__('Animation', TEXT_DOMAIN),
                'type'    => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    ''     => 'None',
                    'up'   => 'Scale Up',
                    'down' => 'Scale Down',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_name',
            [
                'label' => esc_html__('Name', TEXT_DOMAIN),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label'     => esc_html__('Color', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-name' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'name_typography',
                'selector' => '{{WRAPPER}} .rbt-member .rbt-member-name',
            ]
        );

        $this->add_responsive_control(
            'name_bottom_space',
            [
                'label'     => esc_html__('Spacing', TEXT_DOMAIN),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rbt-member-name' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    '_skin!' => 'rbt-ekip',
                ],
            ]
        );

        $this->add_responsive_control(
            'ekip_name_bottom_space',
            [
                'label'      => esc_html__('Spacing', TEXT_DOMAIN),
                'type'       => Controls_Manager::SLIDER,
                'default'    => [
                    'unit' => '%',
                ],
                'size_units' => ['%'],
                'range'      => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-member-skin-ekip:hover .rbt-member-name' => 'top: {{SIZE}}{{UNIT}};',
                ],
                'condition'  => [
                    '_skin' => 'rbt-ekip',
                ],
            ]
        );

        $this->end_controls_section();































































        $this->start_controls_section(
            'section_style_role',
            [
                'label' => esc_html__('Role', TEXT_DOMAIN),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'role_color',
            [
                'label'     => esc_html__('Color', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-role' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'role_bottom_space',
            [
                'label'     => esc_html__('Spacing', TEXT_DOMAIN),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-role' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    '_skin!' => 'rbt-ekip',
                ],
            ]
        );

        $this->add_responsive_control(
            'ekip_role_bottom_space',
            [
                'label'      => esc_html__('Spacing', TEXT_DOMAIN),
                'type'       => Controls_Manager::SLIDER,
                'default'    => [
                    'unit' => '%',
                ],
                'size_units' => ['%'],
                'range'      => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-member-skin-ekip:hover .rbt-member-role' => 'top: {{SIZE}}{{UNIT}};',
                ],
                'condition'  => [
                    '_skin' => 'rbt-ekip',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'role_typography',
                'selector' => '{{WRAPPER}} .rbt-member .rbt-member-role',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_text',
            [
                'label'     => esc_html__('Text', TEXT_DOMAIN),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    '_skin' => ['', 'rbt-band'],
                ],
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label'     => esc_html__('Color', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'text_typography',
                'selector' => '{{WRAPPER}} .rbt-member .rbt-member-text',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_social_icon',
            [
                'label'     => esc_html__('Social Icon', TEXT_DOMAIN),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => ['member_social_icon' => 'yes'],
            ]
        );

        $this->add_control(
            'icon_content_background',
            [
                'label'     => esc_html__('Icons Background', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-icons' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    '_skin!' => 'rbt-band',
                ],
            ]
        );

        $this->add_responsive_control(
            'social_icon_content_padding',
            [
                'label'      => esc_html__('Icons Padding', TEXT_DOMAIN),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-member .rbt-member-icons' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'  => [
                    '_skin!' => 'rbt-band',
                ],
            ]
        );

        $this->start_controls_tabs('tabs_social_icon_style');

        $this->start_controls_tab(
            'tab_social_icon_normal',
            [
                'label' => esc_html__('Normal', TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'icon_background',
            [
                'label'     => esc_html__('Background', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-icon' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    '_skin!' => 'rbt-band',
                ],
            ]
        );

        $this->add_control(
            'band_icon_background',
            [
                'label'     => esc_html__('Background', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-member.rbt-member-skin-band .rbt-member-icons .rbt-member-icon:before' => 'background: {{VALUE}}',
                ],
                'condition' => [
                    '_skin' => 'rbt-band',
                ],
            ]
        );

        $this->add_control(
            'social_icon_color',
            [
                'label'     => esc_html__('Color', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-icon i'   => 'color: {{VALUE}};',
                    '{{WRAPPER}} .rbt-member .rbt-member-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'social_icons_top_border_color',
            [
                'label'     => esc_html__('Top Border Color', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-icons' => 'border-top-color: {{VALUE}}',
                ],
                'condition' => [
                    '_skin!' => 'rbt-band',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'social_icon_border',
                'label'       => esc_html__('Border', TEXT_DOMAIN),
                'placeholder' => '1px',
                'default'     => '1px',
                'selector'    => '{{WRAPPER}} .rbt-member .rbt-member-icon',
                'condition'   => [
                    '_skin!' => 'rbt-band',
                ],
            ]
        );

        $this->add_control(
            'social_icon_border_radius',
            [
                'label'      => esc_html__('Border Radius', TEXT_DOMAIN),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-member .rbt-member-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'  => [
                    '_skin!' => 'rbt-band',
                ],
            ]
        );

        $this->add_responsive_control(
            'social_icon_padding',
            [
                'label'      => esc_html__('Padding', TEXT_DOMAIN),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-member .rbt-member-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'  => [
                    '_skin!' => 'rbt-band',
                ],
            ]
        );

        $this->add_control(
            'social_icon_size',
            [
                'label'     => esc_html__('Icon Size', TEXT_DOMAIN),
                'type'      => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-icon i'        => 'min-width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .rbt-member .rbt-member-icon i:before' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .rbt-member .rbt-member-icon svg'      => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    '_skin!' => 'rbt-band',
                ],
            ]
        );

        $this->add_control(
            'social_icon_indent',
            [
                'label'     => esc_html__('Icon Spacing', TEXT_DOMAIN),
                'type'      => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-icon + .rbt-member-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'ekip_icon_vertical_space',
            [
                'label'      => esc_html__('Vertical Spacing', TEXT_DOMAIN),
                'type'       => Controls_Manager::SLIDER,
                'default'    => [
                    'unit' => '%',
                ],
                'size_units' => ['%'],
                'range'      => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .rbt-member-skin-ekip:hover .rbt-member-icons' => 'top: {{SIZE}}{{UNIT}};',
                ],
                'condition'  => [
                    '_skin' => 'rbt-ekip',
                ],
            ]
        );

        $this->add_control(
            'social_icon_tooltip',
            [
                'label'   => esc_html__('Tooltip', TEXT_DOMAIN),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_social_icon_hover',
            [
                'label' => esc_html__('Hover', TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'icon_hover_background',
            [
                'label'     => esc_html__('Background', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-icon:hover' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    '_skin!' => 'rbt-band',
                ],
            ]
        );

        $this->add_control(
            'icon_hover_color',
            [
                'label'     => esc_html__('Color', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-icon:hover i'   => 'color: {{VALUE}};',
                    '{{WRAPPER}} .rbt-member .rbt-member-icon:hover svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_hover_border_color',
            [
                'label'     => esc_html__('Border Color', TEXT_DOMAIN),
                'type'      => Controls_Manager::COLOR,
                'condition' => [
                    'social_icon_border_border!' => '',
                    '_skin!'                     => 'rbt-band',
                ],
                'selectors' => [
                    '{{WRAPPER}} .rbt-member .rbt-member-icon:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        if ( !isset($settings['social_icon']) && !Icons_Manager::is_migration_allowed() ) {
            // add old default
            $settings['social_icon'] = 'fab fa-facebook-f';
        }

        ?>
        <div class="rbt-member rbt-member-skin-default rbt-transition-toggle">
            <?php

            if ( !empty($settings['photo']['url']) ) :
                $photo_hover_animation = ('' != $settings['photo_hover_animation']) ? ' rbt-transition-scale-' . $settings['photo_hover_animation'] : ''; ?>

                <div class="rbt-member-photo-wrapper rbt-image-mask">

                    <?php if (($settings['member_alternative_photo']) and (!empty($settings['alternative_photo']['url']))) : ?>
                    <div class="rbt-position-relative rbt-overflow-hidden"
                         rbt-toggle="target: > .rbt-member-photo-flip; mode: hover; animation: rbt-animation-fade; queued: true; duration: 300;">

                        <div class="rbt-member-photo-flip rbt-position-absolute rbt-position-z-index">
                            <?php echo Group_Control_Image_Size::get_attachment_image_html($settings, 'alternative_photo'); ?>
                        </div>
                        <?php endif; ?>

                        <div class="rbt-member-photo">
                            <div class="<?php echo($photo_hover_animation); ?>">
                                <?php echo Group_Control_Image_Size::get_attachment_image_html($settings, 'photo'); ?>
                            </div>
                        </div>

                        <?php if (($settings['member_alternative_photo']) and (!empty($settings['alternative_photo']['url']))) : ?>
                    </div>
                <?php endif; ?>

                </div>
            <?php endif; ?>

            <div class="rbt-member-description">
                <?php if ( !empty($settings['name']) ) : ?>
                    <span class="rbt-member-name"><?php echo wp_kses($settings['name'], rbt_allow_tags('title')); ?></span>
                <?php endif; ?>
                <?php if ( !empty($settings['role']) ) : ?>
                    <span class="rbt-member-role"><?php echo wp_kses($settings['role'], rbt_allow_tags('title')); ?></span>
                <?php endif; ?>
                <?php if ( !empty($settings['description_text']) ) : ?>
                    <div class="rbt-member-text rbt-content-wrap"><?php echo wp_kses($settings['description_text'], rbt_allow_tags('text')); ?></div>
                <?php endif; ?>
            </div>

            <?php if ( 'yes' == $settings['member_social_icon'] ) : ?>
                <div class="rbt-member-icons">
                    <?php
                    foreach ( $settings['social_link_list'] as $link ) :
                        $tooltip = ('yes' == $settings['social_icon_tooltip']) ? ' rbt-tooltip="' . $link['social_link_title'] . '"' : ''; ?>

                        <?php
                        $migrated = isset($link['__fa4_migrated']['social_share_icon']);
                        $is_new   = empty($link['social_icon']) && Icons_Manager::is_migration_allowed();
                        ?>

                        <a href="<?php echo esc_url($link['social_link']); ?>"
                           class="rbt-member-icon elementor-repeater-item-<?php echo esc_attr($link['_id']); ?>"
                           target="_blank"<?php echo wp_kses_post($tooltip); ?>>

                            <?php if ( $is_new || $migrated ) :
                                Icons_Manager::render_icon($link['social_share_icon'], ['aria-hidden' => 'true', 'class' => 'fa-fw']);
                            else : ?>
                                <i class="<?php echo esc_attr($link['social_icon']); ?>" aria-hidden="true"></i>
                            <?php endif; ?>

                        </a>

                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

        </div>
        <?php
    }

}