<?php
namespace RoboTheme\inc\elementor\Modules\BeforeAfter\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin;
use Elementor\Icons_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RBT_Before_After extends Widget_Base {

    public function get_name() {
        return 'rbt-before-after';
    }

    public function get_title() {
        return __( 'Before & After Post', TEXT_DOMAIN );
    }

    public function get_icon() {
        return 'eicon-post-title';
    }

    public function get_categories() {
        return [ RBT_CAT ];
    }

    public function get_keywords() {
        return [ 'before', 'after', 'post' ];
    }

	protected function register_controls() {
        $this->register_content_controls();
		$this->register_style_controls();
		$this->register_style_icon_controls();
		$this->register_style_image_controls();
	}

	protected function register_content_controls() {
		$this->start_controls_section(
            'content_setting',
            [
                'label' => __( 'Content', TEXT_DOMAIN ),
            ]
        );
        $this->add_control(
			'side_post',
			[
				'label' => __( 'Side Post', TEXT_DOMAIN ),
				'type' => Controls_Manager::SELECT,
				'default' => 'icon',
				'options' => [
					'none'  => __( 'None', TEXT_DOMAIN ),
					'icon'  => __( 'Icon', TEXT_DOMAIN ),
					'image' => __( 'Image', TEXT_DOMAIN ),
				],
			]
        );
        
        $this->add_control(
			'reverse',
			[
				'label' => __( 'Reverse', TEXT_DOMAIN ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', TEXT_DOMAIN ),
				'label_off' => __( 'No', TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default' => 'no',
			]
        );
        
        $this->add_control(
			'before_options',
			[
				'label' => __( 'Before Options', TEXT_DOMAIN ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
        );
        $this->add_control(
			'before_icon',
			[
				'label' => __( 'Icon', TEXT_DOMAIN ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-angle-right',
					'library' => 'solid',
                ],
                'condition' => [
					'side_post' => 'icon',
				],
			]
		);
        $this->add_control(
			'before_text',
			[
				'label' => __( 'Before Text', TEXT_DOMAIN ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Previous Post:', TEXT_DOMAIN ),
			]
        );
        $this->add_control(
			'before_text_align',
			[
				'label' => __( 'Alignment', TEXT_DOMAIN ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', TEXT_DOMAIN ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', TEXT_DOMAIN ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', TEXT_DOMAIN ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'right',
				'toggle' => true,
			]
		);
        
        $this->add_control(
			'after_options',
			[
				'label' => __( 'After Options', TEXT_DOMAIN ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
        );
        $this->add_control(
			'after_icon',
			[
				'label' => __( 'Icon', TEXT_DOMAIN ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-angle-left',
					'library' => 'solid',
                ],
                'condition' => [
					'side_post' => 'icon',
				],
			]
		);
        $this->add_control(
			'after_text',
			[
				'label' => __( 'After Text', TEXT_DOMAIN ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Next Post:', TEXT_DOMAIN ),
			]
        );
        $this->add_control(
			'after_text_align',
			[
				'label' => __( 'Alignment', TEXT_DOMAIN ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', TEXT_DOMAIN ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', TEXT_DOMAIN ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', TEXT_DOMAIN ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
			]
		);

        $this->end_controls_section();
	}

	protected function register_style_controls() {
		$this->start_controls_section(
			'style_content_section',
			[
				'label' => __( 'Content', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'bg_before_after',
			[
				'label' => __( 'Background', TEXT_DOMAIN ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rbt-before-after .before-after' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'before_after_padding',
			[
				'label' => __( 'Padding', TEXT_DOMAIN ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .rbt-before-after .before-after' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'before_after_radius',
			[
				'label' => __( 'Border Radius', TEXT_DOMAIN ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .rbt-before-after .before-after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'label' => __( 'Text Typography', TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .text',
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => __( 'Text Color', TEXT_DOMAIN ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'content_margin',
			[
				'label' => __( 'Margin', TEXT_DOMAIN ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Title Typography', TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .title',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => __( 'Title Color', TEXT_DOMAIN ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
	}

	protected function register_style_icon_controls() {
		$this->start_controls_section(
			'style_icon_section',
			[
				'label' => __( 'Icon', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'side_post' => 'icon',
				],
			]
		);
		$this->add_control(
			'icon_size',
			[
				'label' => __( 'Size', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 16,
				],
				'selectors' => [
					'{{WRAPPER}} i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'side_post' => 'icon',
				],
			]
		);
		$this->add_responsive_control(
			'icon_padding',
			[
				'label' => __( 'Padding', TEXT_DOMAIN ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => '6',
					'right' => '12',
					'bottom' => '2',
					'left' => '12',
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};transition: .3s;',
				],
				'condition' => [
					'side_post' => 'icon',
				],
			]
		);
		$this->add_control(
			'icon_margin',
			[
				'label' => __( 'Margin', TEXT_DOMAIN ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => '0',
					'right' => '8',
					'bottom' => '0',
					'left' => '8',
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'side_post' => 'icon',
				],
			]
		);
		$this->add_responsive_control(
			'icon_radius',
			[
				'label' => __( 'Radius', TEXT_DOMAIN ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => '5',
					'right' => '5',
					'bottom' => '5',
					'left' => '5',
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'side_post' => 'icon',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'icon_border',
				'label' => __( 'Border', TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .icon',
				'condition' => [
					'side_post' => 'icon',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'icon_box_shadow',
				'label' => __( 'Box Shadow', TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .icon',
				'condition' => [
					'side_post' => 'icon',
				],
			]
		);
		$this->start_controls_tabs('icon_tabs');
        $this->start_controls_tab('icon_normal_tab', ['label' => __( 'Normal', TEXT_DOMAIN ),]);
        $this->add_control(
			'icon_color',
			[
				'label' => __( 'Icon Color', TEXT_DOMAIN ),
				'type' => Controls_Manager::COLOR,
				'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} i' => 'color: {{VALUE}};transition: .3s;',
					'{{WRAPPER}} svg' => 'fill: {{VALUE}};transition: .3s;',
				],
				'condition' => [
					'side_post' => 'icon',
				],
			]
		);
		$this->add_control(
			'icon_bg_color',
			[
				'label' => __( 'Background Color', TEXT_DOMAIN ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ececec',
				'selectors' => [
					'{{WRAPPER}} .icon' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'side_post' => 'icon',
				],
			]
		);
        $this->end_controls_tab();
        $this->start_controls_tab('icon_hover_tab', ['label' => __( 'Hover', TEXT_DOMAIN ),]);
		$this->add_control(
			'h_icon_color',
			[
				'label' => __( 'Icon Color', TEXT_DOMAIN ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .before-after:hover i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .before-after:hover svg' => 'fill: {{VALUE}}',
				],
				'condition' => [
					'side_post' => 'icon',
				],
			]
		);
		$this->add_control(
			'h_icon_bg_color',
			[
				'label' => __( 'Background Color', TEXT_DOMAIN ),
				'type' => Controls_Manager::COLOR,
				'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .before-after:hover .icon' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'side_post' => 'icon',
				],
			]
		);
        $this->end_controls_tab();
        $this->end_controls_tabs();
		$this->end_controls_section();
	}

	protected function register_style_image_controls() {
		$this->start_controls_section(
			'style_image_section',
			[
				'label' => __( 'Image', TEXT_DOMAIN ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'side_post' => 'image',
				],
			]
		);
		$this->add_control(
			'image_size',
			[
				'label' => __( 'Size', TEXT_DOMAIN ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 150,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} img' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'side_post' => 'image',
				],
			]
		);
		$this->add_control(
			'image_margin',
			[
				'label' => __( 'Margin', TEXT_DOMAIN ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => '0',
					'right' => '8',
					'bottom' => '0',
					'left' => '8',
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'side_post' => 'image',
				],
			]
		);
		$this->add_responsive_control(
			'image_radius',
			[
				'label' => __( 'Radius', TEXT_DOMAIN ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => '5',
					'right' => '5',
					'bottom' => '5',
					'left' => '5',
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'side_post' => 'image',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'image_border',
				'label' => __( 'Border', TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} img',
				'condition' => [
					'side_post' => 'image',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'image_box_shadow',
				'label' => __( 'Box Shadow', TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} img',
				'condition' => [
					'side_post' => 'image',
				],
			]
		);
		$this->end_controls_section();
	}

    protected function render() {
        $settings = $this->get_settings();
        $side_post = $settings['side_post'];
        $reverse = $settings['reverse'];
        if($reverse == 'yes') {
            $this->add_render_attribute('rbt_before_after','class', 'rbt-flex-row-reverse');
            $this->add_render_attribute('before','class', 'rbt-flex-row-reverse');
            $this->add_render_attribute('after','class', 'rbt-flex-row-reverse');
        }
        $this->add_render_attribute('rbt_before_after','class', ['rbt-before-after','rbt-flex','rbt-flex-middle','rbt-flex-between']);
        $rbt_before_after = $this->get_render_attribute_string( 'rbt_before_after' );

        echo "<div $rbt_before_after>";

			# Button Prev
			$prev_post = get_adjacent_post(false, '', true);
			if(!empty($prev_post)) {
				$before_text = $settings['before_text'];
				$before_text_align = $settings['before_text_align'];
				$prev_link = get_permalink($prev_post->ID);
				if (!Plugin::$instance->editor->is_edit_mode()) {
					$this->add_render_attribute( 'before', 'onclick', "window.open('$prev_link', '_self')" );
				}
				$this->add_render_attribute('before','class', ['before','before-after','rbt-flex','rbt-flex-middle']);
				$before = $this->get_render_attribute_string( 'before' );
				echo "<div $before>"
					. "<a href='$prev_link' class='icon'>";
						switch($side_post) {
							case 'icon' :
								Icons_Manager::render_icon( $settings['before_icon'], [ 'aria-hidden' => 'true' ] );
							break;
							case 'image' :
								echo get_the_post_thumbnail($prev_post->ID, 'thumbnail');
							break;
						}
					echo "</a>"
					. "<div><a class='rbt-flex rbt-flex-column align-items-$before_text_align' href='$prev_link'><span class='text'>$before_text</span><span class='title'>$prev_post->post_title</span></a></div>"
				. "</div>";
			}

			# Button Next
			$next_post = get_adjacent_post(false, '', false);
			if(!empty($next_post)) {
				$after_text = $settings['after_text'];
				$after_text_align = $settings['after_text_align'];
				$next_link = get_permalink($next_post->ID);
				if (!Plugin::$instance->editor->is_edit_mode()) {
					$this->add_render_attribute( 'after', 'onclick', "window.open('$next_link', '_self')" );
				}
				$this->add_render_attribute( 'after','class', ['after','before-after','rbt-flex','rbt-flex-middle']  );
				$after = $this->get_render_attribute_string( 'after' );
				echo "<div $after>"
					. "<div><a class='rbt-flex rbt-flex-column align-items-$after_text_align' href='$next_link'><span class='text'>$after_text</span><span class='title'>$next_post->post_title</span></a></div>"
					. "<a href='$next_link' class='icon'>";
						switch($side_post) {
							case 'icon' :
								Icons_Manager::render_icon( $settings['after_icon'], [ 'aria-hidden' => 'true' ] );
							break;
							case 'image' :
								echo get_the_post_thumbnail($next_post->ID, 'thumbnail');
							break;
						}
					echo "</a>"
				. "</div>";
			}
        echo "</div>";

    }

}