<?php

namespace RoboTheme\inc\elementor\Modules\Aparat\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RBT_Aparat extends Widget_Base {

	public function get_name(){
		return 'rbt-aparat';
	}

	public function get_title(){
		return __( 'Aparat', TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-video-camera';
	}

    public function get_keywords() {
        return [ 'video', 'aparat', 'film' ];
    }

	public function get_categories() {
        return [ RBT_CAT ];
    }

    public function get_style_depends() {
        return ['rbt-aparat'];
    }
   
    protected function register_controls() {
        $this->start_controls_section(
            'section_general_style',
            [
                'label' => __( 'Content', TEXT_DOMAIN ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'aparat_id',
            [
                'label' => __( 'Aparat ID', TEXT_DOMAIN ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'jtTaW', TEXT_DOMAIN ),
                'description' => __( 'Paste the video ID from the address bar For example the video address https://www.aparat.com/v/jtTaW Just put jtTaW ID', TEXT_DOMAIN ),
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings();

        echo '<div class="h_iframe-aparat_embed_frame">
            <span class="aparat_embed_frame_span"></span>
            <iframe src="https://www.aparat.com/video/video/embed/videohash/'. $settings['aparat_id'] . '/vt/frame" allowFullScreen="true" webkitallowfullscreen="true" mozallowfullscreen="true"></iframe>
        </div>';

    }

}