<?php 
$rbt_register_options = get_option( 'rbt_register_template_options' );
if ( isset( $rbt_register_options['rbt_position_header'] ) ) {
    $rbt_header_position = $rbt_register_options['rbt_position_header'];
}
?>

<div class="rbt-card">

    <div class='rbt-options-title'>
        <div class='eicon-settings rbt-title-icon'></div>
        <h1><?php echo esc_html__( 'Configuration', TEXT_DOMAIN ); ?></h1>
    </div>

    <form method='POST' action='options.php'>
        
        <?php settings_fields('rbt_register_template_options'); ?>

        <div class="content">

            <div class= 'rbt-alert'>
                <div class='eicon-alert icon'></div>
                <p><?php echo esc_html__( 'Templates are created in the Counter > Templates panel. You can choose the format you want according to your saree order.', TEXT_DOMAIN ); ?></p>
            </div>

            <!-- Header -->
            <div class='section'>

                <div class='Heading'>
                    <div class='eicon-header icon'></div>
                    <h1><?php echo esc_html__( 'Config Header', TEXT_DOMAIN ); ?></h1>
                </div>
    
                <div class='inner-section'>
                    <div class='title'>
                        <h3><?php echo esc_html__( 'Choosing Home Page Header Template', TEXT_DOMAIN ); ?></h3>
                    </div>
                    <?php Admin_Panal::selects_template('rbt_header_home_template'); ?>
                </div>

                <div class='inner-section'>
                    <div class='title'>
                        <h3><?php echo esc_html__( 'Choosing Inner Page Header Template', TEXT_DOMAIN ); ?></h3>
                    </div>
                    <?php Admin_Panal::selects_template('rbt_header_inner_template'); ?>
                </div>

                <div class='inner-section'>
                    <div class='title'>
                        <h3><?php echo esc_html__( 'Mode Header', TEXT_DOMAIN ); ?></h3>
                    </div>
                    <label>
                        <input name="rbt_register_template_options[rbt_position_header]" type="checkbox" <?php  if( isset( $rbt_header_position ) ) { if( $rbt_header_position == "on" ) {echo "checked";} } ?> >
                        <?php echo esc_html__( 'Position Header', TEXT_DOMAIN ); ?>
                    </label>
                </div>

            </div>

            <!-- Footer -->
            <div class='section'>

                <div class='Heading'>
                    <div class='eicon-footer icon'></div>
                    <h1><?php echo esc_html__( 'Config Footer', TEXT_DOMAIN ); ?></h1>
                </div>

                <div class='inner-section'>
                    <div class='title'>
                        <h3><?php echo esc_html__( 'Choosing Home Page Footer Template', TEXT_DOMAIN ); ?></h3>
                    </div>
                    <?php Admin_Panal::selects_template('rbt_footer_template'); ?>
                </div>

            </div>
        
            <!-- Blog -->
            <div class='section'>

                <div class='Heading'>
                    <div class='eicon-archive icon'></div>
                    <h1><?php echo esc_html__( 'Config Blog', TEXT_DOMAIN ); ?></h1>
                </div>

                <div class='inner-section'>
                    <div class='title'>
                        <h3><?php echo esc_html__( 'Choosing Archive Blog Template', TEXT_DOMAIN ); ?></h3>
                    </div>
                    <?php Admin_Panal::selects_template('rbt_archive_blog_template'); ?>
                </div>

                <div class='inner-section'>
                    <div class='title'>
                        <h3><?php echo esc_html__( 'Choosing Single Blog Template', TEXT_DOMAIN ); ?></h3>
                    </div>
                    <?php Admin_Panal::selects_template('rbt_single_blog_template'); ?>
                </div>

            </div>

            <!-- Portfolio -->
            <div class='section'>

                <div class='Heading'>
                    <div class='eicon-archive icon'></div>
                    <h1><?php echo esc_html__( 'Config Portfolio', TEXT_DOMAIN ); ?></h1>
                </div>

                <div class='inner-section'>
                    <div class='title'>
                        <h3><?php echo esc_html__( 'Choosing Archive Portfolio Template', TEXT_DOMAIN ); ?></h3>
                    </div>
                    <?php Admin_Panal::selects_template('rbt_archive_project_template'); ?>
                </div>

                <div class='inner-section'>
                    <div class='title'>
                        <h3><?php echo esc_html__( 'Choosing Single Portfolio Template', TEXT_DOMAIN ); ?></h3>
                    </div>
                    <?php Admin_Panal::selects_template('rbt_single_project_template'); ?>
                </div>

            </div>

            <!-- Shop -->
            <div class='section'>

                <div class='Heading'>
                    <div class='eicon-archive icon'></div>
                    <h1><?php echo esc_html__( 'Config Shop', TEXT_DOMAIN ); ?></h1>
                </div>

                <div class='inner-section'>
                    <div class='title'>
                        <h3><?php echo esc_html__( 'Choosing Archive Shop Template', TEXT_DOMAIN ); ?></h3>
                    </div>
                    <?php Admin_Panal::selects_template('rbt_archive_shop_template'); ?>
                </div>

                <div class='inner-section'>
                    <div class='title'>
                        <h3><?php echo esc_html__( 'Choosing Single Shop Template', TEXT_DOMAIN ); ?></h3>
                    </div>
                    <?php Admin_Panal::selects_template('rbt_single_shop_template'); ?>
                </div>

            </div>

            <!-- 404 -->
            <div class='section'>

                <div class='Heading'>
                    <div class='eicon-error-404 icon'></div>
                    <h1><?php echo esc_html__( 'Config 404', TEXT_DOMAIN ); ?></h1>
                </div>

                <div class='inner-section'>
                    <div class='title'>
                        <h3><?php echo esc_html__( 'Choosing 404 Template', TEXT_DOMAIN ); ?></h3>
                    </div>
                    <?php Admin_Panal::selects_template('rbt_error_template'); ?>
                </div>

            </div>

            <!-- Search -->
            <div class='section'>

                <div class='Heading'>
                    <div class='eicon-search icon'></div>
                    <h1><?php echo esc_html__( 'Config Search', TEXT_DOMAIN ); ?></h1>
                </div>

                <div class='inner-section'>
                    <div class='title'>
                        <h3><?php echo esc_html__( 'Choosing Search Template', TEXT_DOMAIN ); ?></h3>
                    </div>
                    <?php Admin_Panal::selects_template('rbt_search_template'); ?>
                </div>

            </div>

        </div>

        <p class="submit">
            <input type="submit" class="button-save" value="<?php _e('Save Changes', TEXT_DOMAIN ); ?>"/>
        </p>

    </form>

</div>