( function( $, elementor ) {

	'use strict';

	var widgetPanelSlider = function( $scope, $ ) {

		var $slider = $scope.find( '.rbt-panel-slider' );
				
        if ( ! $slider.length ) {
            return;
        }

		var $sliderContainer = $slider.find('.swiper-container'),
			$settings 		 = $slider.data('settings');

		// Access swiper class
		const Swiper = elementorFrontend.utils.swiper;
		initSwiper();

		async function initSwiper() {

			var swiper = new Swiper($sliderContainer, $settings);

			if ($settings.pauseOnHover) {
				$($sliderContainer).hover(function() {
					(this).swiper.autoplay.stop();
				}, function() {
					(this).swiper.autoplay.start();
				});
			}
		};	

	};

	jQuery(window).on('elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/rbt-testimonial.default', widgetPanelSlider );
		elementorFrontend.hooks.addAction( 'frontend/element_ready/rbt-testimonial.rbt-middle', widgetPanelSlider );
	});

}( jQuery, window.elementorFrontend ) );