(function($, elementor) {

    'use strict';

    var widgetCarousel = function($scope, $) {

        var $carousel = $scope.find('.rbt-carousel');

        if (!$carousel.length) {
            return;
        }

        var $carouselContainer = $carousel.find('.swiper-container'),
            $settings = $carousel.data('settings');

        // Access swiper class
		const Swiper = elementorFrontend.utils.swiper;
		initSwiper();

        async function initSwiper() {

            var swiper = new Swiper($carouselContainer, $settings);

            if ($settings.pauseOnHover) {
                $($carouselContainer).hover(function() {
                    (this).swiper.autoplay.stop();
                }, function() {
                    (this).swiper.autoplay.start();
                });
            }

        };	

    };

    jQuery(window).on('elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/rbt-carousel.default', widgetCarousel);
    });

}(jQuery, window.elementorFrontend));